/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.xforceplus.phoenix.bill.client.model.SourceBillNoRequest;
import com.xforceplus.phoenix.bill.client.model.SourceBillNoResponse;
import com.xforceplus.phoenix.match.bean.PushMatchInvoiceBean;
import com.xforceplus.phoenix.match.client.BillClient;
import com.xforceplus.phoenix.match.client.PimInvoiceInnerQueryClient;
import com.xforceplus.phoenix.match.common.enums.EventTypeEnum;
import com.xforceplus.phoenix.match.common.enums.NewMatchStatusEnum;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillInvoiceDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceExample;
import com.xforceplus.phoenix.pim.client.model.MsGetPimInvoiceByIdsRequest;
import com.xforceplus.phoenix.pim.client.model.PimFullFieldResponse;
import com.xforceplus.phoenix.pim.client.model.PimInvoiceMainFields;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplat.aws.common.AwsHelper;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.wicp.tams.common.Result;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private BillClient billClient;
    @Autowired
    SqsService sqsService;
    @Autowired
    MtcSalesbillInvoiceDao mtcSalesbillInvoiceDao;
    @Autowired
    PimInvoiceInnerQueryClient pimInvoiceInnerQueryClient;

    public List<String> querySourceBillNo(String salesbillNo, Long salesbillId) {
        List list = Lists.newArrayList();
        SourceBillNoRequest sourceBillNoRequest = new SourceBillNoRequest();
        sourceBillNoRequest.setBillNo(salesbillNo);
        sourceBillNoRequest.setSalesbillId(String.valueOf(salesbillId));
        log.info("\u8c03\u7528\u9500\u9879\u670d\u52a1\u83b7\u53d6\u539f\u5355\u5165\u53c2:{}", (Object)JsonUtils.writeObjectToJson((Object)sourceBillNoRequest));
        SourceBillNoResponse sourceBillNoResponse = this.billClient.querySourceBillNo(sourceBillNoRequest);
        if (Response.OK.equals(sourceBillNoResponse.getCode())) {
            list = sourceBillNoResponse.getResult();
        }
        log.info("\u8c03\u7528\u9500\u9879\u670d\u52a1\u83b7\u53d6\u539f\u5355\u8fd4\u56de\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToJson((Object)sourceBillNoResponse));
        return list;
    }

    public Boolean billRendCooperation(String sendMsg, String customerNo, String salesbillNo, String methodName, Long salesbillId, Long purchaserGroupId, Long sellerGroupId) {
        HashMap<String, String> sqsProperties = new HashMap<String, String>();
        sqsProperties.put("eventType", EventTypeEnum.PUSH_MATCH_STATUS.getValue());
        sqsProperties.put("customerNo", customerNo);
        sqsProperties.put("originatorNo", "");
        sqsProperties.put("platformNo", "4");
        sqsProperties.put("businessNo", salesbillNo);
        sqsProperties.put("salesbillId", NullableUtil.toStringValue((Object)salesbillId, (String)""));
        sqsProperties.put("purchaserGroupId", NullableUtil.toStringValue((Object)purchaserGroupId, (String)""));
        sqsProperties.put("sellerGroupId", NullableUtil.toStringValue((Object)sellerGroupId, (String)""));
        log.info("\u914d\u5355\u7ed3\u679c\u901a\u8fc7sqs\u961f\u5217\u4e0b\u53d1\u96c6\u6210,\u65b9\u6cd5\u540d:{},\u6d88\u606f\u4f53:{}", (Object)methodName, (Object)sendMsg);
        log.info("\u914d\u5355\u7ed3\u679c\u901a\u8fc7sqs\u961f\u5217\u4e0b\u53d1\u96c6\u6210,\u65b9\u6cd5\u540d:{},\u6d88\u606f\u5c5e\u6027:{}", (Object)methodName, (Object)JsonUtils.writeObjectToJson(sqsProperties));
        boolean sendStatus = true;
        try {
            Result result = this.sqsService.sendStrMsg(AwsHelper.buildQueueName((String)"it-bus-priority-high"), sendMsg, sqsProperties);
            sendStatus = result.isSuc();
        }
        catch (Exception e) {
            log.error("\u914d\u5355\u7ed3\u679c\u901a\u8fc7sqs\u961f\u5217\u4e0b\u53d1\u96c6\u6210,\u65b9\u6cd5\u540d:{},SQS\u53d1\u9001\u5f02\u5e38:{}", (Object)methodName, (Object)e);
            sendStatus = false;
        }
        log.info("\u914d\u5355\u7ed3\u679c\u901a\u8fc7sqs\u961f\u5217\u4e0b\u53d1\u96c6\u6210,\u65b9\u6cd5\u540d:{},SQS\u53d1\u9001\u7ed3\u679c:{}", (Object)methodName, (Object)sendStatus);
        return sendStatus;
    }

    public Map<Long, List<PushMatchInvoiceBean>> queryBillMatchedInvoice(List<Long> salesbillIds) {
        HashMap<Long, List<PushMatchInvoiceBean>> result = new HashMap<Long, List<PushMatchInvoiceBean>>();
        MtcSalesbillInvoiceExample mtcSalesbillInvoiceExample = new MtcSalesbillInvoiceExample();
        mtcSalesbillInvoiceExample.createCriteria().andSalesbillIdIn(salesbillIds).andStatusEqualTo(NewMatchStatusEnum.OK.getValue());
        List mtcSalesbillInvoiceEntities = this.mtcSalesbillInvoiceDao.selectByExample(mtcSalesbillInvoiceExample);
        if (CollectionUtils.isEmpty((Collection)mtcSalesbillInvoiceEntities)) {
            return result;
        }
        Map<Long, List<MtcSalesbillInvoiceEntity>> relationGroupBySalesbillId = mtcSalesbillInvoiceEntities.stream().collect(Collectors.groupingBy(r -> r.getSalesbillId()));
        List invoiceIds = mtcSalesbillInvoiceEntities.stream().map(r -> r.getInvoiceId()).distinct().collect(Collectors.toList());
        PimFullFieldResponse msResponse = this.getPimInvoiceFields(((MtcSalesbillInvoiceEntity)mtcSalesbillInvoiceEntities.get(0)).getPurchaserGroupId(), invoiceIds);
        if (CollectionUtils.isEmpty((Collection)msResponse.getResult())) {
            return result;
        }
        Map<Long, PimInvoiceMainFields> invoiceMap = msResponse.getResult().stream().collect(Collectors.toMap(r -> r.getId(), r -> r));
        for (Map.Entry<Long, List<MtcSalesbillInvoiceEntity>> entry : relationGroupBySalesbillId.entrySet()) {
            ArrayList<PushMatchInvoiceBean> invoiceBeans = new ArrayList<PushMatchInvoiceBean>();
            for (MtcSalesbillInvoiceEntity entity : entry.getValue()) {
                PushMatchInvoiceBean invoiceBean = new PushMatchInvoiceBean();
                CommonUtils.copyProperties((Object)invoiceMap.get(entity.getInvoiceId()), (Object)invoiceBean);
                invoiceBeans.add(invoiceBean);
            }
            result.put(entry.getKey(), invoiceBeans);
        }
        return result;
    }

    private PimFullFieldResponse getPimInvoiceFields(Long purchaserGroupId, List<Long> invoiceIds) {
        MsGetPimInvoiceByIdsRequest msRequest = new MsGetPimInvoiceByIdsRequest();
        msRequest.setInvoiceIds(invoiceIds);
        msRequest.setFields(Arrays.asList("id", "invoice_no", "invoice_code", "paper_drew_date", "amount_with_tax", "amount_without_tax", "tax_amount", "tax_rate", "invoice_type", "status", "bussiness_no", "purchaser_name", "purchaser_tax_no", "purchaser_no", "seller_name", "seller_tax_no", "seller_no", "special_invoice_flag", "sale_list_flag", "veri_status", "auth_status", "auth_tax_period", "red_status", "red_time", "red_notification_no", "match_status", "match_time", "charge_up_status", "purchaser_address", "purchaser_tel", "purchaser_addr_tel", "purchaser_bank_name", "purchaser_bank_account", "purchaser_bank_name_account", "seller_address", "seller_tel", "seller_addr_tel", "seller_bank_name", "seller_bank_account", "seller_bank_name_account", "recog_deduction_image_url", "recog_invoice_image_url", "pdf_url", "remark", "report_no", "report_status", "business_tag", "ext1", "ext2", "ext3", "ext4", "ext5", "ext6", "ext7", "ext8", "ext9", "ext10", "ext11", "ext12", "ext13", "ext14", "ext15", "ext16", "ext17", "ext18", "ext19", "ext20", "ext21", "ext22", "ext23", "ext24", "ext25"));
        return this.pimInvoiceInnerQueryClient.getInvoiceByIds(purchaserGroupId, msRequest);
    }

    public String getPureCargoName(String cargoName) {
        return cargoName.replaceAll(" ", "");
    }
}

