/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.match.bean.MatchConditionDetailBean;
import com.xforceplus.phoenix.match.bean.MessageMiddleRequest;
import com.xforceplus.phoenix.match.bean.MessageMiddleResponse;
import com.xforceplus.phoenix.match.bean.PimParamBean;
import com.xforceplus.phoenix.match.client.MessageMiddleClient;
import com.xforceplus.phoenix.match.client.NoticeClient;
import com.xforceplus.phoenix.match.client.PimInvoiceDetailClient;
import com.xforceplus.phoenix.match.client.PimInvoiceMatchClient;
import com.xforceplus.phoenix.match.client.PimInvoiceQueryClient;
import com.xforceplus.phoenix.match.client.PurconfigItemClient;
import com.xforceplus.phoenix.match.client.model.MsExportMatchRequest;
import com.xforceplus.phoenix.match.client.response.Response;
import com.xforceplus.phoenix.match.common.enums.CooperateFlagEnum;
import com.xforceplus.phoenix.match.common.enums.InvoiceOriginEnum;
import com.xforceplus.phoenix.match.common.enums.MatchExportEnum;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.NewMatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.PaymentStatusEnum;
import com.xforceplus.phoenix.match.common.enums.PimQueryEnum;
import com.xforceplus.phoenix.match.common.enums.RetreatStatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.PimInvoiceMapper;
import com.xforceplus.phoenix.match.common.utils.DateTools;
import com.xforceplus.phoenix.match.common.utils.MatchExportUtil;
import com.xforceplus.phoenix.match.common.utils.MatchRedisUtil;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillInvoiceDao;
import com.xforceplus.phoenix.match.repository.daoext.MtcSalesbillDaoExt;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceExample;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.ValidateService;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.phoenix.pim.client.model.MsBatchUpdateMatchStatusRequest;
import com.xforceplus.phoenix.pim.client.model.MsDetailListInvoiceRequest;
import com.xforceplus.phoenix.pim.client.model.MsDetailListResponse;
import com.xforceplus.phoenix.pim.client.model.MsGetPimInvoiceByIdsRequest;
import com.xforceplus.phoenix.pim.client.model.MsMatchBean;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetByIdRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetByIdResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetDetailRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetDetailResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceParam;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceParamGroup;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import com.xforceplus.phoenix.tools.enums.InvoiceStatusEnum;
import com.xforceplus.phoenix.tools.util.ExcelUtil;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.DateUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.client.model.config.ConfigItemCodeEnum;
import com.xforceplus.purconfig.client.model.config.ConfigItemRequest;
import com.xforceplus.purconfig.client.model.config.ConfigItemResponse;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionBillBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionDetailBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionInvoiceBean;
import com.xforceplus.purconfig.client.model.config.item.MatchRulesTypeBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DependServiceImpl
implements DependService {
    private static final Logger logger = LoggerFactory.getLogger(DependServiceImpl.class);
    @Autowired
    PimInvoiceQueryClient pimInvoiceQueryClient;
    @Autowired
    PimInvoiceMatchClient pimInvoiceMatchClient;
    @Autowired
    PurconfigItemClient purconfigItemClient;
    @Autowired
    MatchRedisUtil redisLock;
    @Autowired
    ValidateService validateService;
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    MtcSalesbillDaoExt mtcSalesbillDaoExt;
    @Autowired
    MtcSalesbillInvoiceDao mtcSalesbillInvoiceDao;
    @Autowired
    PimInvoiceDetailClient pimInvoiceDetailClient;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    NoticeClient noticeClient;
    @Autowired
    IDGenerator idGenerator;
    @Value(value="${bangbang.server.url}")
    private String url;
    @Value(value="${bangbang.server.timeout}")
    private int timeout;
    @Autowired
    PimInvoiceMapper pimInvoiceMapper;
    @Value(value="${messageSwitcher:0}")
    private Integer messageSwitcher;
    @Autowired
    private MessageMiddleClient messageMiddleClient;
    private static final Long productId = 20L;
    private static final List<String> exportInvoiceFields = Arrays.asList("id", "invoiceNo", "invoiceCode", "purchaserName", "sellerName", "amountWithTax", "amountWithoutTax", "taxAmount", "matchStatus", "matchAmount", "sellerOrigin");
    private static final List<Function<PimParamBean, MsPimInvoiceParam>> pimParamList = DependServiceImpl.createPimParamList();

    public List<MatchConditionBean.AuthConditionInfo> getMatchConfigCondition(Long companyId, ConfigItemCodeEnum configItemCodeEnum, Long groupId) {
        String val = this.getConfigItem(groupId, companyId, configItemCodeEnum);
        MatchConditionBean matchCfBean = (MatchConditionBean)JsonUtils.writeJsonToObject((String)val, MatchConditionBean.class);
        List<MatchConditionBean.AuthConditionInfo> matchList = matchCfBean.getMatchConditionList().stream().filter(c -> MatchConditionBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        return matchList;
    }

    public String getConfigItem(Long groupId, Long companyId, ConfigItemCodeEnum configItemCodeEnum) {
        ConfigItemRequest req = new ConfigItemRequest();
        req.setGroupId(groupId);
        req.setCompanyId(companyId);
        req.setConfigItemCode(configItemCodeEnum);
        logger.info("purconfigItemClient.getConfigItem.request:{}", (Object)req);
        ConfigItemResponse confResp = this.purconfigItemClient.getConfigItem(req);
        logger.info("purconfigItemClient.getConfigItem.response:{}", (Object)confResp);
        if (Objects.isNull(confResp) || !confResp.getCode().equals(Response.RESULT_SUCESS)) {
            throw new RuntimeException(Objects.isNull(confResp) ? "\u89c4\u5219\u914d\u7f6e\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u89c4\u5219\u914d\u7f6e\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + confResp.getMessage());
        }
        return confResp.getResult().getConfigContent();
    }

    public Boolean getGoodsNameValidate(Long companyId, Long groupId) {
        List matchList = this.getMatchDetailCondition(companyId, ConfigItemCodeEnum.MATCH_CONDITION_DETAIL, groupId);
        if (CollectionUtils.isEmpty((Collection)matchList)) {
            return Boolean.FALSE;
        }
        return matchList.stream().anyMatch(obj -> obj.getCondition().equals((Object)MatchConditionDetailBean.ConditionEnum.C01));
    }

    public List<MatchConditionDetailBean.AuthConditionInfo> getMatchDetailCondition(Long companyId, Long groupId) {
        return this.getMatchDetailCondition(companyId, ConfigItemCodeEnum.MATCH_CONDITION_DETAIL, groupId);
    }

    public BigDecimal getTolerance(Long companyId, Long groupId) {
        List matchList = this.getMatchRuleTypeCondition(companyId, ConfigItemCodeEnum.MATCH_RULES_TYPE, groupId);
        if (CollectionUtils.isEmpty((Collection)matchList)) {
            return BigDecimal.ZERO;
        }
        return CollectionUtils.isEmpty(matchList = matchList.stream().filter(obj -> obj.getCondition().equals((Object)MatchRulesTypeBean.ConditionEnum.C01)).collect(Collectors.toList())) ? BigDecimal.ZERO : new BigDecimal(((MatchRulesTypeBean.AuthConditionInfo)matchList.get(0)).getValue());
    }

    public String lockBillAndInvoice(List<Long> salesbillIds, List<Long> invoiceIds, List<Long> relationIds, Map<Long, String> lockedMap) {
        String relationLockCheck = this.checkLock("\u53d1\u7968\u4e1a\u52a1\u5355\u5339\u914d\u5173\u7cfb\u5df2\u88ab\u9501\u5b9a\uff01", lockedMap, relationIds);
        if (StringUtils.isNotEmpty((CharSequence)relationLockCheck)) {
            return relationLockCheck;
        }
        String salesbillLockCheck = this.checkLock("\u4e1a\u52a1\u5355\u5df2\u88ab\u9501\u5b9a\uff01", lockedMap, salesbillIds);
        if (StringUtils.isNotEmpty((CharSequence)salesbillLockCheck)) {
            return salesbillLockCheck;
        }
        String invoiceLockCheck = this.checkLock("\u53d1\u7968\u5df2\u88ab\u9501\u5b9a\uff01", lockedMap, invoiceIds);
        if (StringUtils.isNotEmpty((CharSequence)invoiceLockCheck)) {
            return invoiceLockCheck;
        }
        return "";
    }

    private String checkLock(String errorMessage, Map<Long, String> lockedMap, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return "";
        }
        for (Long id : ids) {
            String lockValue = UUID.randomUUID().toString();
            if (!this.redisLock.tryGetDistributedLock("MATH_BILL_INVOICE" + id, lockValue, 60000, 10, 5000L)) {
                return errorMessage;
            }
            lockedMap.put(id, lockValue);
        }
        return "";
    }

    public void unLockBillAndInvoice(Map<Long, String> lockedMap) {
        for (Long lockedId : lockedMap.keySet()) {
            this.redisLock.releaseDistributedLock("MATH_BILL_INVOICE" + lockedId, lockedMap.get(lockedId));
            logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u300b\u300blockKey[{}],lockValue[{}]", (Object)lockedId, (Object)lockedMap.get(lockedId));
        }
    }

    public List<MsPimInvoiceRow> getMsPimInvoiceRowList(List<Long> invoiceIds) {
        MsGetPimInvoiceByIdsRequest request = new MsGetPimInvoiceByIdsRequest();
        request.setInvoiceIds(invoiceIds);
        logger.info("pimInvoiceQueryClient.getPimInvoiceByIds.request:{}", (Object)request);
        MsPimInvoiceGetPageResponse response = this.pimInvoiceQueryClient.getPimInvoiceByIds(request);
        logger.info("pimInvoiceQueryClient.getPimInvoiceByIds.response:{}", (Object)response);
        if (Objects.isNull(response) || !response.getCode().equals(Response.RESULT_SUCESS)) {
            throw new RuntimeException(Objects.isNull(response) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + response.getMessage());
        }
        return response.getResult();
    }

    public MsPimInvoiceRow getMsPimInvoiceRowById(Long invoiceId) {
        MsPimInvoiceGetByIdRequest request = new MsPimInvoiceGetByIdRequest();
        request.setInvoiceId(invoiceId);
        logger.info("pimInvoiceQueryClient.getById.request:{}", (Object)request);
        MsPimInvoiceGetByIdResponse msPimInvoiceGetByIdResponse = this.pimInvoiceQueryClient.getById(request);
        logger.info("pimInvoiceQueryClient.getById.msPimInvoiceGetByIdResponse.code:{}", (Object)msPimInvoiceGetByIdResponse.getCode());
        if (Objects.isNull(msPimInvoiceGetByIdResponse) || !msPimInvoiceGetByIdResponse.getCode().equals(Response.RESULT_SUCESS)) {
            throw new RuntimeException(Objects.isNull(msPimInvoiceGetByIdResponse) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + msPimInvoiceGetByIdResponse.getMessage());
        }
        return msPimInvoiceGetByIdResponse.getResult();
    }

    public MsDetailListResponse getMsPimInvoiceDetailRowByIds(Long invoiceId, String itemMatchStatus, Integer page, Integer size) {
        MsDetailListInvoiceRequest request = new MsDetailListInvoiceRequest();
        request.setInvoiceId(invoiceId);
        request.setItemMatchStatus(itemMatchStatus);
        request.setPageIndex(page);
        request.setPageRowCount(size);
        logger.info("DetailApi.getDetailList.MsDetailListRequest:{}", (Object)request);
        MsDetailListResponse response = this.pimInvoiceDetailClient.getDetailListInvoiceId(request);
        logger.info("DetailApi.getDetailList.MsDetailListResponse.size:{}", (Object)response.getResult().size());
        if (Objects.isNull(response) || !Response.RESULT_SUCESS.equals(response.getCode())) {
            throw new RuntimeException(Objects.isNull(response) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + response.getMessage());
        }
        return response;
    }

    public List<MsPimInvoiceDetailRow> getMsPimInvoiceDetailRowById(Long invoiceId) {
        MsPimInvoiceGetDetailRequest msPimInvoiceGetDetailRequest = new MsPimInvoiceGetDetailRequest();
        msPimInvoiceGetDetailRequest.setInvoiceId(invoiceId);
        logger.info("pimInvoiceQueryClient.getDetail.msPimInvoiceGetDetailRequest:{}", (Object)msPimInvoiceGetDetailRequest);
        MsPimInvoiceGetDetailResponse msPimInvoiceGetDetailResponse = this.pimInvoiceQueryClient.getDetail(msPimInvoiceGetDetailRequest);
        logger.info("pimInvoiceQueryClient.getDetail.msPimInvoiceGetDetailResponse.size:{}", (Object)msPimInvoiceGetDetailResponse.getResult().size());
        if (Objects.isNull(msPimInvoiceGetDetailResponse) || !msPimInvoiceGetDetailResponse.getCode().equals(Response.RESULT_SUCESS)) {
            throw new RuntimeException(Objects.isNull(msPimInvoiceGetDetailResponse) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + msPimInvoiceGetDetailResponse.getMessage());
        }
        return msPimInvoiceGetDetailResponse.getResult();
    }

    public MsPimInvoiceGetPageResponse getMsPimInvoiceGetPageResponse(List<Long> orgIds, MtcSalesbillEntity mtcSalesbillEntity) {
        MsPimInvoiceGetPageRequest msPimInvoiceGetPageRequest = new MsPimInvoiceGetPageRequest();
        ArrayList<MsPimInvoiceParamGroup> paramGroups = new ArrayList<MsPimInvoiceParamGroup>();
        MsPimInvoiceParamGroup msPimInvoiceParamGroup = new MsPimInvoiceParamGroup();
        msPimInvoiceParamGroup.addParamsItem(DependServiceImpl.setClientParam((String)"purchaserCompanyId", (String)"eq", (String)mtcSalesbillEntity.getPurchaserId().toString()));
        msPimInvoiceParamGroup.addParamsItem(DependServiceImpl.setClientParam((String)"sellerTaxNo", (String)"eq", (String)mtcSalesbillEntity.getSellerTaxNo()));
        msPimInvoiceParamGroup.addParamsItem(DependServiceImpl.setClientParam((String)"matchStatus", (String)"in", (String)"0#1#4"));
        msPimInvoiceParamGroup.addParamsItem(DependServiceImpl.setClientParam((String)"status", (String)"eq", (String)"1"));
        msPimInvoiceParamGroup.addParamsItem(DependServiceImpl.setClientParam((String)"retreatStatus", (String)"eq", (String)"0"));
        MsPimInvoiceParamGroup msPimInvoiceParamGroupDk = new MsPimInvoiceParamGroup();
        msPimInvoiceParamGroupDk.addParamsItem(DependServiceImpl.setClientParam((String)"purchaserCompanyId", (String)"eq", (String)mtcSalesbillEntity.getPurchaserId().toString()));
        msPimInvoiceParamGroupDk.addParamsItem(DependServiceImpl.setClientParam((String)"issueTaxNo", (String)"eq", (String)mtcSalesbillEntity.getSellerTaxNo()));
        msPimInvoiceParamGroupDk.addParamsItem(DependServiceImpl.setClientParam((String)"matchStatus", (String)"in", (String)"0#1#4"));
        msPimInvoiceParamGroupDk.addParamsItem(DependServiceImpl.setClientParam((String)"status", (String)"eq", (String)"1"));
        msPimInvoiceParamGroupDk.addParamsItem(DependServiceImpl.setClientParam((String)"retreatStatus", (String)"eq", (String)"0"));
        paramGroups.add(msPimInvoiceParamGroup);
        paramGroups.add(msPimInvoiceParamGroupDk);
        msPimInvoiceGetPageRequest.setParamGroups(paramGroups);
        msPimInvoiceGetPageRequest.setOrgIds(orgIds);
        logger.info("pimInvoiceQueryClient.getInvoiceRequest.msPimInvoiceGetPageRequest:{}", (Object)msPimInvoiceGetPageRequest);
        MsPimInvoiceGetPageResponse msPimInvoiceGetPageResponse = this.pimInvoiceQueryClient.getInvoiceRequest(msPimInvoiceGetPageRequest);
        logger.info("pimInvoiceQueryClient.getInvoiceRequest.msPimInvoiceGetPageResponse.size:{}", (Object)msPimInvoiceGetPageResponse.getResult().size());
        return msPimInvoiceGetPageResponse;
    }

    public void doBatchUpdateMatchStatus(List<MsMatchBean> invoiceMatchList) {
        Map<Long, DoubleSummaryStatistics> collectGroupByInvoiceId = invoiceMatchList.stream().collect(Collectors.groupingBy(MsMatchBean::getInvoiceId, Collectors.summarizingDouble(e -> new BigDecimal(e.getMatchAmount()).doubleValue())));
        ArrayList invoiceMatchListTmp = new ArrayList();
        collectGroupByInvoiceId.forEach((key, value) -> invoiceMatchList.forEach(matchBean -> {
            if (matchBean.equals(key)) {
                matchBean.setMatchAmount(String.valueOf(value.getSum()));
            }
        }));
        MsBatchUpdateMatchStatusRequest request = new MsBatchUpdateMatchStatusRequest();
        request.setMatchList(invoiceMatchList);
        logger.info("pimInvoiceMatchClient.batchUpdateMatchStatus.request:{}", (Object)request);
        MsPimInvoiceResponse msPimInvoiceResponse = this.pimInvoiceMatchClient.batchUpdateMatchStatus(request);
        logger.info("pimInvoiceMatchClient.batchUpdateMatchStatus.msPimInvoiceResponse:{}", (Object)msPimInvoiceResponse);
        if (Objects.isNull(msPimInvoiceResponse) || !msPimInvoiceResponse.getCode().equals(Response.RESULT_SUCESS)) {
            throw new RuntimeException(Objects.isNull(msPimInvoiceResponse) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + msPimInvoiceResponse.getMessage());
        }
    }

    public List<MatchConditionBillBean.AuthConditionInfo> getMatchBillCondition(Long companyId, ConfigItemCodeEnum configItemCodeEnum, Long groupId) {
        String val = this.getConfigItem(groupId, companyId, configItemCodeEnum);
        MatchConditionBillBean matchCfBean = (MatchConditionBillBean)JsonUtils.writeJsonToObject((String)val, MatchConditionBillBean.class);
        List<MatchConditionBillBean.AuthConditionInfo> matchList = matchCfBean.getMatchConditionBill().stream().filter(c -> MatchConditionBillBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        return matchList;
    }

    private List<MatchRulesTypeBean.AuthConditionInfo> getMatchRuleTypeCondition(Long companyId, ConfigItemCodeEnum configItemCodeEnum, Long groupId) {
        String val = this.getConfigItem(groupId, companyId, configItemCodeEnum);
        MatchRulesTypeBean matchRulesTypeBean = (MatchRulesTypeBean)JsonUtils.writeJsonToObject((String)val, MatchRulesTypeBean.class);
        List<MatchRulesTypeBean.AuthConditionInfo> matchList = matchRulesTypeBean.getMatchRulesTypeList().stream().filter(c -> MatchRulesTypeBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        return matchList;
    }

    private List<MatchConditionDetailBean.AuthConditionInfo> getMatchDetailCondition(Long companyId, ConfigItemCodeEnum configItemCodeEnum, Long groupId) {
        String val = this.getConfigItem(groupId, companyId, configItemCodeEnum);
        MatchConditionDetailBean matchConditionDetailBean = (MatchConditionDetailBean)JsonUtils.writeJsonToObject((String)val, MatchConditionDetailBean.class);
        List<MatchConditionDetailBean.AuthConditionInfo> matchList = matchConditionDetailBean.getMatchConditionDetailList().stream().filter(c -> MatchConditionDetailBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        return matchList;
    }

    public Map<String, String> getInvoiceCargoNames(String purchaserName, String sellerName, List<String> businessNoList, List<String> goodsNameList) {
        Map map;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("purchaserName", purchaserName);
        paramMap.put("sellerName", sellerName);
        paramMap.put("businessNo", businessNoList);
        paramMap.put("goodsNameList", goodsNameList);
        logger.info("getInvoiceCargoNames.request:{}", paramMap);
        String result = ((HttpRequest)HttpRequest.post((String)this.url).header(Header.CONTENT_TYPE, "application/json")).body(JSONUtil.toJsonStr(paramMap)).timeout(this.timeout).execute().body();
        logger.info("getInvoiceCargoNames.result:{}", (Object)result);
        Map<String, String> resultMap = new HashMap<String, String>();
        Boolean isSucess = Boolean.FALSE;
        if (JSONUtil.isJson((String)result) && ((String)(map = (Map)JSONUtil.toBean((String)result, Map.class)).get("code")).equals("0000")) {
            isSucess = Boolean.TRUE;
            if ("SUCCESS".equals(map.get("message"))) {
                resultMap = (Map)JSONUtil.toBean((String)JsonUtils.writeObjectToJson(map.get("data")), Map.class);
            }
        }
        if (!isSucess.booleanValue()) {
            logger.error("\u90a6\u90a6\u6c7d\u670d\u670d\u52a1\u8c03\u7528\u9519\u8bef!");
        }
        return resultMap;
    }

    public Boolean checkInvoiceRecommend(MsPimInvoiceRow msPimInvoiceRow) {
        Boolean result = true;
        if (!InvoiceStatusEnum.NORMAL.code().equals(msPimInvoiceRow.getStatus())) {
            result = false;
            return result;
        }
        if (RetreatStatusEnum.RETREAT.code().equals(msPimInvoiceRow.getRetreatStatus())) {
            result = false;
            return result;
        }
        List msPimInvoiceRowList = Lists.newArrayList((Object[])new MsPimInvoiceRow[]{msPimInvoiceRow});
        msPimInvoiceRowList = this.validateService.validateMatchConditionRulesForRecommend(msPimInvoiceRow.getPurchaserCompanyId(), msPimInvoiceRow.getPurchaserGroupId(), msPimInvoiceRowList);
        if (CommonUtils.isEmpty((List)msPimInvoiceRowList)) {
            result = false;
            return result;
        }
        return result;
    }

    public List<MtcSalesbillEntity> getExportBillByCondition(MsExportMatchRequest request) {
        MtcSalesbillExample mtcSalesbillExample = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = mtcSalesbillExample.createCriteria();
        criteria.andMatchStatusEqualTo(MatchExportEnum.getMatchStatusByCode((Integer)request.getTabStatus()).toString()).andPurchaserGroupIdEqualTo(request.getGroupId()).andSysOrgIdIn(request.getOrgIds());
        if (StringUtils.isNotEmpty((CharSequence)request.getPurchaserName())) {
            criteria.andPurchaserNameEqualTo(request.getPurchaserName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSellerName())) {
            criteria.andSellerNameLike("%" + request.getSellerName() + "%");
        }
        if (request.getCooperateFlag() != null) {
            criteria.andCooperateFlagEqualTo(request.getCooperateFlag());
        }
        List keyword = null;
        if (CollectionUtils.isNotEmpty((Collection)request.getKeyword())) {
            keyword = request.getKeyword();
        }
        List mtcSalesbillEntityList = CollectionUtils.isEmpty((Collection)request.getItemKeyword()) ? this.mtcSalesbillDaoExt.selectByExample(mtcSalesbillExample, keyword) : this.mtcSalesbillDaoExt.selectByExampleJoinItem(mtcSalesbillExample, keyword, request.getItemKeyword());
        return mtcSalesbillEntityList;
    }

    public List<MtcSalesbillEntity> getExportBillById(List<Long> salesbillIds) {
        MtcSalesbillExample example = new MtcSalesbillExample();
        example.createCriteria().andSalesbillIdIn(salesbillIds);
        return this.mtcSalesbillDao.selectByExample(example);
    }

    public List<MsPimInvoiceRow> getExportInvoice(MsExportMatchRequest request, List<Long> invoiceIds) {
        List<Object> msPimInvoiceRowList = new ArrayList<MsPimInvoiceRow>();
        MsPimInvoiceGetPageResponse pimResponse = null;
        try {
            if (CollectionUtils.isEmpty(invoiceIds)) {
                MsPimInvoiceGetPageRequest pimInvoicePageRequest = new MsPimInvoiceGetPageRequest();
                pimInvoicePageRequest.setFields(exportInvoiceFields);
                pimInvoicePageRequest.setOrgIds(request.getOrgIds());
                pimInvoicePageRequest.setParamGroups(this.setPimParams(this.pimInvoiceMapper.msExportMatchRequestToBean(request)));
                logger.info("\u83b7\u53d6\u5bfc\u51fa\u53d1\u7968\u8c03\u7528\u53d1\u7968\u6c60\u5165\u53c2, request: {}", (Object)pimInvoicePageRequest);
                pimResponse = this.pimInvoiceQueryClient.getInvoiceRequest(pimInvoicePageRequest);
            } else {
                MsGetPimInvoiceByIdsRequest pimInvoiceIdRequest = new MsGetPimInvoiceByIdsRequest();
                pimInvoiceIdRequest.setFields(exportInvoiceFields);
                pimInvoiceIdRequest.setInvoiceIds(invoiceIds);
                logger.info("\u83b7\u53d6\u5bfc\u51fa\u53d1\u7968\u8c03\u7528\u53d1\u7968\u6c60\u5165\u53c2\uff0crequest:{}", (Object)pimInvoiceIdRequest);
                pimResponse = this.pimInvoiceQueryClient.getPimInvoiceByIds(pimInvoiceIdRequest);
            }
            if (null != pimResponse.getResult() && CollectionUtils.isNotEmpty((Collection)pimResponse.getResult())) {
                logger.info("\u83b7\u53d6\u5bfc\u51fa\u53d1\u7968\u8c03\u7528\u53d1\u7968\u6c60\u7ed3\u679c, total: {}", (Object)pimResponse.getResult().size());
                msPimInvoiceRowList = pimResponse.getResult();
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u5bfc\u51fa\u53d1\u7968\u5f02\u5e38\uff0c{}", (Throwable)e);
        }
        return msPimInvoiceRowList;
    }

    public List<MtcSalesbillInvoiceEntity> getRelation(List<Long> invoiceIds, List<Long> salesbillIds) {
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        MtcSalesbillInvoiceExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(NewMatchStatusEnum.CANCEL.getValue());
        if (CollectionUtils.isNotEmpty(invoiceIds)) {
            criteria.andInvoiceIdIn(invoiceIds);
        }
        if (CollectionUtils.isNotEmpty(salesbillIds)) {
            criteria.andSalesbillIdIn(salesbillIds);
        }
        return this.mtcSalesbillInvoiceDao.selectByExample(example);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMatchExcel(List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList, List<MtcSalesbillInvoiceEntity> relation, MsExportMatchRequest request) {
        ArrayList<String[]> contentList = new ArrayList<String[]>();
        String[] contents = null;
        ArrayList titleList = new ArrayList();
        MatchExportUtil.initTitleListAndAlign(titleList);
        if (CollectionUtils.isEmpty(relation)) {
            if (CollectionUtils.isNotEmpty(mtcSalesbillEntityList)) {
                for (MtcSalesbillEntity entity : mtcSalesbillEntityList) {
                    contents = new String[titleList.size()];
                    contents = this.setExcelContents(contents, entity, null);
                    contentList.add(contents);
                }
            }
            if (CollectionUtils.isNotEmpty(msPimInvoiceRowList)) {
                for (MsPimInvoiceRow row : msPimInvoiceRowList) {
                    contents = new String[titleList.size()];
                    contents = this.setExcelContents(contents, null, row);
                    contentList.add(contents);
                }
            }
        } else {
            Map<Long, MtcSalesbillEntity> mtcSalesbillEntityMap = mtcSalesbillEntityList.stream().collect(Collectors.toMap(r -> r.getSalesbillId(), r -> r));
            Map<Long, MsPimInvoiceRow> msPimInvoiceRowMap = msPimInvoiceRowList.stream().collect(Collectors.toMap(r -> r.getId(), r -> r));
            MtcSalesbillEntity entity = null;
            MsPimInvoiceRow row = null;
            for (MtcSalesbillInvoiceEntity relationEntity : relation) {
                entity = mtcSalesbillEntityMap.get(relationEntity.getSalesbillId());
                row = msPimInvoiceRowMap.get(relationEntity.getInvoiceId());
                contents = new String[titleList.size()];
                contents = this.setExcelContents(contents, entity, row);
                contentList.add(contents);
            }
        }
        SXSSFWorkbook workbook = ExcelUtil.createSXSSFWorkbookWithBillInvoice((String)"\u914d\u5355\u4fe1\u606f", titleList, null, contentList, null, (Integer)MatchExportUtil.BILL_AND_INVOICE_BORDER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = null;
        try {
            workbook.write((OutputStream)baos);
            bais = new ByteArrayInputStream(baos.toByteArray());
            String name = "\u914d\u5355\u4fe1\u606f\u5bfc\u51fa";
            String fileName = String.format(name + "_%s.%s", DateUtils.toDateStr((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206"), "xlsx");
            String fileOssKey = String.format("tmp/export_files/%s/%s", UUID.randomUUID().toString(), fileName);
            fileOssKey = this.ossUtil.uploadFileByInputStream(fileOssKey, (InputStream)bais, Module.PURCHASER, true);
            logger.info("\u914d\u5355\u5bfc\u51fa\u5904\u7406--\u4fdd\u5b58\u81f3\u963f\u91cc\u4e91\u6210\u529f\uff0cossKey[{}]", (Object)fileOssKey);
            String dowloadUrl = this.ossUtil.fileKeyToDownloadUrlViaPlatform(fileOssKey);
            logger.info("\u914d\u5355\u5bfc\u51fa\u5904\u7406--\u4e0b\u8f7d\u5730\u5740\uff0cdowloadUrl[{}]", (Object)dowloadUrl);
            this.sendNoticeMesssage(request, Integer.valueOf(1), dowloadUrl, "\u4e0a\u4f20OSS\u6210\u529f", name, fileName);
        }
        catch (IOException e) {
            logger.error("\u914d\u5355\u5bfc\u51fa\u5904\u7406--\u4e0a\u4f20OSS\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u914d\u5355\u5bfc\u51fa\u5904\u7406--\u4e0a\u4f20OSS\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] setExcelContents(String[] contents, MtcSalesbillEntity entity, MsPimInvoiceRow row) {
        if (null != entity) {
            contents[0] = entity.getSalesbillNo();
            contents[1] = entity.getSellerName();
            contents[2] = entity.getPurchaserName();
            contents[3] = entity.getTaxAmount().toString();
            contents[4] = entity.getAmountWithoutTax().toString();
            contents[5] = entity.getAmountWithTax().toString();
            contents[6] = PaymentStatusEnum.getMsgByCode((Integer)entity.getPaymentStatus());
            contents[7] = entity.getExt1();
            contents[8] = entity.getExt2();
            contents[9] = entity.getExt3();
            contents[10] = MatchStatusEnum.getNameByValue((Integer)Integer.parseInt(entity.getMatchStatus()));
        }
        if (null != row) {
            contents[11] = row.getInvoiceCode();
            contents[12] = row.getInvoiceNo();
            contents[13] = MatchStatusEnum.getNameByValue((Integer)row.getMatchStatus());
            contents[14] = row.getMatchAmount();
            contents[15] = row.getSellerName();
            contents[16] = row.getPurchaserName();
            contents[17] = row.getTaxAmount();
            contents[18] = row.getAmountWithoutTax();
            contents[19] = row.getAmountWithTax();
            contents[20] = InvoiceOriginEnum.getMsgByCode((Integer)row.getSellerOrigin());
        }
        return contents;
    }

    public void sendDownloadMessage(Long userId, Long groupId, String downloadUrl, String title, String content) {
        try {
            MessageMiddleRequest request = new MessageMiddleRequest();
            request.setTitle(title);
            request.setContent(content);
            ArrayList<Long> receiverIdList = new ArrayList<Long>();
            receiverIdList.add(userId);
            request.setReceiverIds(receiverIdList);
            HashMap<String, String> extendParam = new HashMap<String, String>();
            extendParam.put("url", downloadUrl);
            request.setExtendParam(extendParam);
            logger.info("\u53d1\u9001\u6d88\u606f\u5230\u65b0\u6d88\u606f\u4e2d\u5fc3request {}", (Object)JSONObject.toJSONString((Object)request));
            MessageMiddleResponse reponse = this.messageMiddleClient.sendMessages(groupId, productId, request);
            logger.info("\u53d1\u9001\u6d88\u606f\u5230\u65b0\u6d88\u606f\u4e2d\u5fc3response:{}", (Object)com.xforceplus.xplatframework.utils.JsonUtils.writeObjectToFastJson((Object)reponse));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u4e0b\u8f7d\u6d88\u606f\u5230\u65b0\u6d88\u606f\u4e2d\u5fc3\u5f02\u5e38 {}", (Throwable)e);
        }
    }

    private void sendNoticeMesssage(MsExportMatchRequest request, Integer status, String downloadUrl, String remark, String msgTitle, String fileName) {
        if (this.messageSwitcher == 1) {
            this.sendDownloadMessage(request.getUserId(), request.getGroupId(), downloadUrl, msgTitle, fileName);
        }
        try {
            MsOperateMessageRequest messageRequest = new MsOperateMessageRequest();
            messageRequest.setAppid("PHOENIX-MATCH-SERVICE");
            messageRequest.setDoType(MsDoBase.DoTypeEnum.I);
            messageRequest.setGroupId(request.getGroupId());
            messageRequest.setMessageType(Integer.valueOf(1));
            messageRequest.setMessageTitle(msgTitle);
            messageRequest.setMessageContent(fileName);
            messageRequest.setMessageUrl(downloadUrl);
            messageRequest.setUserId(request.getUserId());
            messageRequest.setOperaterid(String.valueOf(request.getUserId()));
            messageRequest.setOperater(request.getUserName());
            messageRequest.setRid(String.valueOf(this.idGenerator.nextId()));
            logger.info("\u53d1\u9001\u7528\u6237\u6d88\u606f--\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)messageRequest);
            MsOperateMessageResponse messageResponse = this.noticeClient.operateMessage(messageRequest);
            logger.info("\u53d1\u9001\u7528\u6237\u6d88\u606f--\u56de\u590d\u4fe1\u606f\uff1a{}", (Object)messageResponse);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u7528\u6237\u6d88\u606f--\u5f02\u5e38\uff1amsgUrl[{}]", (Object)downloadUrl, (Object)e);
        }
    }

    private static List<Function<PimParamBean, MsPimInvoiceParam>> createPimParamList() {
        ArrayList<Function<PimParamBean, MsPimInvoiceParam>> list = new ArrayList<Function<PimParamBean, MsPimInvoiceParam>>();
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getPaperDrewDateStart()) ? DependServiceImpl.setClientParam((String)"paperDrewDate", (String)"gteq", (String)bean.getPaperDrewDateStart()) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getPaperDrewDateEnd()) ? DependServiceImpl.setClientParam((String)"paperDrewDate", (String)"lteq", (String)bean.getPaperDrewDateEnd()) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getRecogResponseTimeStart()) ? DependServiceImpl.setClientParam((String)"recogResponseTime", (String)"gteq", (String)DateTools.toDateString19((String)bean.getRecogResponseTimeStart())) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getRecogResponseTimeEnd()) ? DependServiceImpl.setClientParam((String)"recogResponseTime", (String)"lteq", (String)DateTools.toDateString19((String)bean.getRecogResponseTimeEnd())) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getPurchaserName()) ? DependServiceImpl.setClientParam((String)"purchaserName", (String)"eq", (String)bean.getPurchaserName()) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getSellerName()) ? DependServiceImpl.setClientParam((String)"sellerName", (String)"fulllike", (String)bean.getSellerName()) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getInvoiceNo()) ? DependServiceImpl.setClientParam((String)"invoiceNo", (String)"eq", (String)bean.getInvoiceNo()) : null);
        list.add(bean -> StringUtils.isNotEmpty((CharSequence)bean.getInvoiceCode()) ? DependServiceImpl.setClientParam((String)"invoiceCode", (String)"eq", (String)bean.getInvoiceCode()) : null);
        list.add(bean -> null != bean.getInvoiceId() ? DependServiceImpl.setClientParam((String)"id", (String)"eq", (String)String.valueOf(bean.getInvoiceId())) : null);
        list.add(bean -> null == bean.getCooperateFlag() ? null : (CooperateFlagEnum.NOT_COOPERATE.getCode().equals(bean.getCooperateFlag()) ? DependServiceImpl.setClientParam((String)"sellerSyncStatus", (String)"in", (String)CooperateFlagEnum.NOT_COOPERATE.getInvoice()) : DependServiceImpl.setClientParam((String)"sellerSyncStatus", (String)"eq", (String)CooperateFlagEnum.COOPERATE.getInvoice())));
        list.add(bean -> CollectionUtils.isEmpty((Collection)bean.getMatchStatus()) ? null : DependServiceImpl.setClientParam((String)"matchStatus", (String)"in", (String)(bean.getMatchStatus().contains(MatchStatusEnum.MATCH_END.getValue()) ? String.valueOf(MatchStatusEnum.MATCH_END.getValue()) : bean.getMatchStatus().stream().map(r -> String.valueOf(r)).collect(Collectors.joining("#")))));
        list.add(bean -> null != bean.getPageOrigin() && 1 == bean.getPageOrigin() ? DependServiceImpl.setClientParam((String)"status", (String)"in", (String)"0#1") : null);
        list.add(bean -> CollectionUtils.isNotEmpty((Collection)bean.getSellerOrigin()) ? DependServiceImpl.setClientParam((String)"sellerOrigin", (String)"in", (String)bean.getSellerOrigin().stream().map(r -> r.toString()).collect(Collectors.joining("#"))) : null);
        return list;
    }

    public List<MsPimInvoiceParamGroup> setPimParams(PimParamBean bean) {
        List invoiceParams = pimParamList.stream().map(r -> (MsPimInvoiceParam)r.apply(bean)).filter(r -> r != null).collect(Collectors.toList());
        ArrayList invoiceIssueParams = null;
        if (CollectionUtils.isNotEmpty((Collection)bean.getBussinessNo())) {
            MtcSalesbillExample example = new MtcSalesbillExample();
            example.createCriteria().andSalesbillNoIn(bean.getBussinessNo());
            List salesbillEntities = this.mtcSalesbillDao.selectByExample(example);
            String purchaserCompanyIdList = salesbillEntities.stream().map(r -> r.getPurchaserId().toString()).collect(Collectors.joining("#"));
            String sellerTaxNoList = salesbillEntities.stream().map(r -> r.getSellerTaxNo()).collect(Collectors.joining("#"));
            if (StringUtils.isNotEmpty((CharSequence)purchaserCompanyIdList)) {
                invoiceParams.add(PimQueryEnum.setClientParam((PimQueryEnum)PimQueryEnum.PURCHASERCOMOPANYID_IN, (String)purchaserCompanyIdList));
            }
            if (StringUtils.isNotEmpty((CharSequence)sellerTaxNoList)) {
                invoiceIssueParams = Lists.newArrayList(invoiceParams);
                invoiceIssueParams.add(PimQueryEnum.setClientParam((PimQueryEnum)PimQueryEnum.ISSUE_TAX_NO_IN, (String)sellerTaxNoList));
                invoiceParams.add(PimQueryEnum.setClientParam((PimQueryEnum)PimQueryEnum.SELLERTAXNO_IN, (String)sellerTaxNoList));
            }
        }
        MsPimInvoiceParamGroup paramsInvoice = new MsPimInvoiceParamGroup().params(invoiceParams);
        ArrayList params = Lists.newArrayList((Object[])new MsPimInvoiceParamGroup[]{paramsInvoice});
        if (invoiceIssueParams != null) {
            MsPimInvoiceParamGroup paramsIssue = new MsPimInvoiceParamGroup().params(invoiceIssueParams);
            params.add(paramsIssue);
        }
        return params;
    }

    private static MsPimInvoiceParam setClientParam(String key, String condition, String value) {
        return new MsPimInvoiceParam().paramKey(key).paramCondition(condition).paramValue(value);
    }

    public List<MatchConditionInvoiceBean.AuthConditionInfo> getCancelMatchInvoiceCondition(Long companyId, ConfigItemCodeEnum configItemCodeEnum, Long groupId) {
        String val = this.getConfigItem(groupId, companyId, configItemCodeEnum);
        MatchConditionInvoiceBean matchCfBean = (MatchConditionInvoiceBean)JsonUtils.writeJsonToObject((String)val, MatchConditionInvoiceBean.class);
        List<MatchConditionInvoiceBean.AuthConditionInfo> matchList = matchCfBean.getMatchConditionInvoice().stream().filter(c -> MatchConditionInvoiceBean.CheckedFlagEnum.YES.equals((Object)c.getCheckedFlag())).collect(Collectors.toList());
        return matchList;
    }
}

