/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.match.bean.PimMatchCountBean;
import com.xforceplus.phoenix.match.bean.PimParamBean;
import com.xforceplus.phoenix.match.client.PimInvoiceQueryClient;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailRowDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MatchInvoiceDetailDTO;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceDetailRequest;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceDetailResponse;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceListRequest;
import com.xforceplus.phoenix.match.client.model.invoice.MsInvoiceListStatResponse;
import com.xforceplus.phoenix.match.common.MatchException;
import com.xforceplus.phoenix.match.common.enums.ErrorCodeEnum;
import com.xforceplus.phoenix.match.common.mapstruct.PimInvoiceMapper;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.MatchInvoiceService;
import com.xforceplus.phoenix.pim.client.model.MsPimCountGroupByParamRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetDetailRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetDetailResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageRequest;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchInvoiceServiceImpl
implements MatchInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(MatchInvoiceServiceImpl.class);
    @Autowired
    private PimInvoiceQueryClient pimInvoice;
    @Autowired
    private DependService dependService;
    @Autowired
    private PimInvoiceMapper pimInvoiceMapper;

    public MsInvoiceListStatResponse getListStat(MsInvoiceListRequest request) {
        MsInvoiceListStatResponse response = new MsInvoiceListStatResponse();
        response.setCode(Integer.valueOf(ErrorCodeEnum.FAILED.getValue()));
        List invoiceListStats = new ArrayList();
        try {
            request.setMatchStatus(null);
            MsPimInvoiceResponse pimResponse = this.getCountUseByListStat(request);
            if (Response.OK.equals(pimResponse.getCode())) {
                List pimMatchCountBeans = JsonUtils.writeJsonToListObject((String)pimResponse.getResult(), PimMatchCountBean.class);
                invoiceListStats = this.pimInvoiceMapper.invoiceCountToDTOList(Arrays.asList(0, 1, 4, 2), pimMatchCountBeans);
            } else {
                response.setMessage(pimResponse.getMessage());
            }
        }
        catch (Exception e) {
            log.error("\u5217\u8868\u9875\u8c03\u7528\u53d1\u7968\u6c60\u670d\u52a1\u5f02\u5e38 PimInvoiceQueryClient.countGroupByParam: {}", (Throwable)e);
            response.setMessage(ErrorCodeEnum.CLIENT_ERR.getName());
            return response;
        }
        if (CollectionUtils.isNotEmpty(invoiceListStats)) {
            response.setCode(Integer.valueOf(ErrorCodeEnum.SUCCESS.getValue()));
            response.setResult(invoiceListStats);
        }
        return response;
    }

    public MsInvoiceDetailResponse getDetail(MsInvoiceDetailRequest request) {
        MsPimInvoiceGetPageResponse pimResponse;
        MsInvoiceDetailResponse response = new MsInvoiceDetailResponse();
        MsPimInvoiceGetPageRequest pimInvoiceRequest = this.getPimInvoiceRequestWithSort(request);
        pimInvoiceRequest.setOrgIds(request.getOrgIds());
        PimParamBean pimParamBean = this.pimInvoiceMapper.msInvoiceDetailRequestToBean(request);
        pimInvoiceRequest.setParamGroups(this.dependService.setPimParams(pimParamBean));
        try {
            log.info("getDetail\u8c03\u7528\u53d1\u7968\u6c60\u65b9\u6cd5\u5165\u53c2\uff1a{}", (Object)pimInvoiceRequest);
            pimResponse = this.pimInvoice.getPage(pimInvoiceRequest);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u53d1\u7968\u6c60\u670d\u52a1\u5f02\u5e38 PimInvoiceQueryClient.getPage : {}", (Throwable)e);
            response.setCode(Integer.valueOf(ErrorCodeEnum.FAILED.getValue()));
            response.setMessage(ErrorCodeEnum.CLIENT_ERR.getName());
            return response;
        }
        if (!Response.OK.equals(pimResponse.getCode())) {
            response.setCode(Integer.valueOf(ErrorCodeEnum.FAILED.getValue()));
            response.setMessage(pimResponse.getMessage());
            return response;
        }
        List invoiceRows = pimResponse.getResult();
        Map<Long, List> invoiceDetailMap = invoiceRows.stream().collect(Collectors.toMap(MsPimInvoiceRow::getId, r -> this.getInvoiceDetailRow(request.getGroupId(), request.getOrgIds(), r.getId())));
        List invoiceDetailDTOS = this.pimInvoiceMapper.invoiceRowToDetailDTO(invoiceRows, invoiceDetailMap);
        response.setCode(Integer.valueOf(ErrorCodeEnum.SUCCESS.getValue()));
        response.setResult((Object)new MatchInvoiceDetailDTO().setTotal(String.valueOf(pimResponse.getTotal())).setList(invoiceDetailDTOS));
        return response;
    }

    private List<InvoiceDetailRowDTO> getInvoiceDetailRow(Long userGroupId, List<Long> orgIds, Long invoiceId) {
        MsPimInvoiceGetDetailRequest request = new MsPimInvoiceGetDetailRequest();
        request.invoiceId(invoiceId);
        MsPimInvoiceGetDetailResponse pimResponse = this.pimInvoice.getDetail(request);
        return Response.OK.equals(pimResponse.getCode()) ? this.pimInvoiceMapper.msDetailRowToDetailRowDTO(pimResponse.getResult()) : Lists.newArrayList();
    }

    private MsPimInvoiceResponse getCountUseByListStat(MsInvoiceListRequest request) {
        MsPimCountGroupByParamRequest pimRequest = new MsPimCountGroupByParamRequest();
        pimRequest.orgIds(request.getOrgIds()).fields((List)Lists.newArrayList((Object[])new String[]{"matchStatus"})).groupParam((List)Lists.newArrayList((Object[])new String[]{"match_status"})).paramGroups(this.dependService.setPimParams(this.pimInvoiceMapper.msInvoiceListRequestToBean(request)));
        MsPimInvoiceResponse pimResponse = this.pimInvoice.countGroupByParam(pimRequest);
        log.info("getInvoiceCount, response:{}", (Object)pimResponse);
        return pimResponse;
    }

    private MsPimInvoiceGetPageRequest getPimInvoiceRequestWithSort(MsInvoiceDetailRequest request) {
        MsPimInvoiceGetPageRequest pimInvoiceRequest = new MsPimInvoiceGetPageRequest();
        if (null == request.getGroupId() || CollUtil.isEmpty((Collection)request.getOrgIds())) {
            throw new MatchException(ErrorCodeEnum.VERIFY_GROUP_OR_ORG_ERR);
        }
        pimInvoiceRequest.setOrgIds(request.getOrgIds());
        if (StrUtil.isNotBlank((CharSequence)request.getPageNo()) && StrUtil.isNotBlank((CharSequence)request.getPageSize())) {
            pimInvoiceRequest.setPageIndex(Integer.valueOf(request.getPageNo()));
            pimInvoiceRequest.setPageRowCount(Integer.valueOf(request.getPageSize()));
        }
        if (!CommonUtils.isEmpty((List)request.getOrders())) {
            pimInvoiceRequest.setOrders(request.getOrders());
            pimInvoiceRequest.setOrderSort(request.getOrderSort());
        }
        return pimInvoiceRequest;
    }
}

