/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.google.api.client.util.Lists;
import com.xforceplus.phoenix.match.client.PimInvoiceDetailClient;
import com.xforceplus.phoenix.match.client.model.MsDetailComparedRequest;
import com.xforceplus.phoenix.match.client.model.MsDetailComparedResponse;
import com.xforceplus.phoenix.match.client.model.MsDetailComparedResult;
import com.xforceplus.phoenix.match.client.model.MsInvoiceDetails;
import com.xforceplus.phoenix.match.client.model.MsMtcSalesbillItemDTO;
import com.xforceplus.phoenix.match.client.model.MsResponse;
import com.xforceplus.phoenix.match.common.enums.ItemMatchStatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.MatchMapper;
import com.xforceplus.phoenix.match.common.mapstruct.SalesBillEntityMapper;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemExample;
import com.xforceplus.phoenix.match.service.MatchService;
import com.xforceplus.phoenix.pim.client.model.MsDetailListInvoiceIdsRequest;
import com.xforceplus.phoenix.pim.client.model.MsDetailListResponse;
import com.xforceplus.phoenix.pim.client.model.MsDetailRow;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import com.xforceplus.xplatframework.model.Response;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchServiceImpl
implements MatchService {
    private static final Logger logger = LoggerFactory.getLogger(MatchServiceImpl.class);
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    private MtcSalesbillItemDao salesbillItemDao;
    @Autowired
    private MatchMapper matchMapper;
    @Autowired
    private SalesBillEntityMapper salesBillEntityMapper;
    @Autowired
    private PimInvoiceDetailClient pimInvoiceDetailClient;

    public MsResponse getSalesbillByNo(String billNo, Long purchaserCompanyId) {
        MsResponse response = new MsResponse();
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            return response.code(Response.Fail).message("\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        MtcSalesbillEntity entity = this.getMtcSalesbillEntity(billNo, purchaserCompanyId);
        if (entity == null) {
            return response.code(Response.Fail).message("\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u4e1a\u52a1\u5355.");
        }
        return response.code(Response.OK).message("\u6210\u529f").result((Object)entity);
    }

    public MsDetailComparedResponse detailCompare(MsDetailComparedRequest request) {
        MsDetailComparedResponse response = new MsDetailComparedResponse();
        if (CollectionUtils.isEmpty((Collection)request.getBillIds())) {
            return response.code(Integer.valueOf(0)).message("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)request.getInvoiceIds())) {
            return response.code(Integer.valueOf(0)).message("\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        MtcSalesbillItemExample.Criteria criteria = example.createCriteria();
        if (request.getBillIds().size() == 1) {
            criteria.andSalesbillIdEqualTo((Long)request.getBillIds().get(0));
        } else {
            criteria.andSalesbillIdIn(request.getBillIds());
        }
        List salesbillDetails = this.salesbillItemDao.selectByExample(example);
        MsDetailListInvoiceIdsRequest detailRequest = new MsDetailListInvoiceIdsRequest();
        detailRequest.setInvoiceIds(request.getInvoiceIds());
        MsDetailListResponse invoceDetailsResponse = this.pimInvoiceDetailClient.getDetailListInvoiceId(detailRequest);
        List salesbillDetailsSorted = this.groupSumAndSorted(salesbillDetails, MtcSalesbillItemEntity::getItemName, arg_0 -> this.sumAndConverterToSalesbillDetails(arg_0), (o1, o2) -> this.sortByItemMatchStatus(o1.getItemMatchStatus(), o2.getItemMatchStatus()));
        List invoceDetailsSorted = this.groupSumAndSorted(invoceDetailsResponse.getResult(), MsDetailRow::getCargoName, arg_0 -> this.sumAndConverterToInvoiceDetails(arg_0), (o1, o2) -> this.sortByItemMatchStatus(o1.getItemMatchStatus(), o2.getItemMatchStatus()));
        MsDetailComparedResult result = new MsDetailComparedResult();
        result.setSalesbillDetails(salesbillDetailsSorted);
        result.setInvoiceDetails(invoceDetailsSorted);
        response.setResult(result);
        response.setCode(Integer.valueOf(1));
        response.setMessage("\u6210\u529f");
        return response;
    }

    private MsMtcSalesbillItemDTO sumAndConverterToSalesbillDetails(List<MtcSalesbillItemEntity> value) {
        BigDecimal quantity = value.stream().map(MtcSalesbillItemEntity::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountWithoutTax = value.stream().map(MtcSalesbillItemEntity::getAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountWithTax = value.stream().map(MtcSalesbillItemEntity::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmount = value.stream().map(MtcSalesbillItemEntity::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.salesBillEntityMapper.map(value.get(0), quantity.toPlainString(), amountWithoutTax.toPlainString(), amountWithTax.toPlainString(), taxAmount.toPlainString());
    }

    private MsInvoiceDetails sumAndConverterToInvoiceDetails(List<MsDetailRow> value) {
        BigDecimal quantity = value.stream().map(i -> NullableUtil.toBigDecimalValue((Object)i.getQuantity(), (BigDecimal)BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountWithoutTax = value.stream().map(i -> new BigDecimal(i.getAmountWithoutTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountWithTax = value.stream().map(i -> new BigDecimal(i.getAmountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmount = value.stream().map(i -> new BigDecimal(i.getTaxAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.salesBillEntityMapper.mapListDetailRow(value.get(0), quantity, amountWithoutTax, amountWithTax, taxAmount);
    }

    private <I, T> List<T> groupSumAndSorted(List<I> source, Function<? super I, ?> groupBy, Function<List<I>, T> sumFunction, Comparator<? super T> comparator) {
        if (CollectionUtils.isEmpty(source)) {
            return Lists.newArrayList();
        }
        return source.parallelStream().collect(Collectors.groupingBy(groupBy)).entrySet().parallelStream().map(entry -> sumFunction.apply((List)entry.getValue())).sorted(comparator).collect(Collectors.toList());
    }

    private int sortByItemMatchStatus(String itemMatchStatus, String itemMatchStatus2) {
        if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCHED.value()) || itemMatchStatus2.contains(ItemMatchStatusEnum.MATCHED.value())) {
            if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCHED.value()) && itemMatchStatus2.contains(ItemMatchStatusEnum.MATCHED.value())) {
                return 0;
            }
            if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCHED.value()) && !itemMatchStatus2.contains(ItemMatchStatusEnum.MATCHED.value())) {
                return -1;
            }
            return 1;
        }
        if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value()) || itemMatchStatus2.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value())) {
            if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value()) && itemMatchStatus2.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value())) {
                return 0;
            }
            if (itemMatchStatus.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value()) && !itemMatchStatus2.contains(ItemMatchStatusEnum.MATCH_NAME_ERROR.value())) {
                return 1;
            }
            return -1;
        }
        return Objects.compare(itemMatchStatus.split(",").length, itemMatchStatus2.split(",").length, Integer::compareTo);
    }

    private MtcSalesbillEntity getMtcSalesbillEntity(String billNo, Long purchaserCompanyId) {
        List entityList;
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoEqualTo(billNo);
        criteria.andStatusEqualTo(Integer.valueOf(1));
        if (null != purchaserCompanyId) {
            criteria.andPurchaserIdEqualTo(purchaserCompanyId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entityList = this.mtcSalesbillDao.selectByExample(example)))) {
            return (MtcSalesbillEntity)entityList.get(0);
        }
        return null;
    }

    public List<MtcSalesbillEntity> getSalesbillByNos(List<String> billNos, Long purchaserCompanyId, Long purchaserGroupId) {
        MsResponse response = new MsResponse();
        if (CollectionUtils.isEmpty(billNos)) {
            return null;
        }
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoIn(billNos);
        criteria.andStatusEqualTo(Integer.valueOf(1));
        if (null != purchaserCompanyId) {
            criteria.andPurchaserIdEqualTo(purchaserCompanyId);
        }
        if (null != purchaserGroupId) {
            criteria.andPurchaserGroupIdEqualTo(purchaserGroupId);
        }
        List entityList = this.mtcSalesbillDao.selectByExample(example);
        return entityList;
    }
}

