/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.xforceplus.phoenix.match.client.PimInvoiceMatchClient;
import com.xforceplus.phoenix.match.client.model.invoice.InvoiceDetailRowDTO;
import com.xforceplus.phoenix.match.client.model.match.BillItemVO;
import com.xforceplus.phoenix.match.client.model.match.BillVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceBillCheckListVO;
import com.xforceplus.phoenix.match.client.model.match.MatchRelationVO;
import com.xforceplus.phoenix.match.client.model.match.MatchType;
import com.xforceplus.phoenix.match.client.request.CancelMatchRequest;
import com.xforceplus.phoenix.match.client.request.ConfirmStatusRequest;
import com.xforceplus.phoenix.match.client.request.MatchRequest;
import com.xforceplus.phoenix.match.client.request.RecommendBillsRequest;
import com.xforceplus.phoenix.match.client.request.RecommendInvoicesRequest;
import com.xforceplus.phoenix.match.client.request.SearchMatchRequest;
import com.xforceplus.phoenix.match.client.request.SearchNotMatchByInvoiceRequest;
import com.xforceplus.phoenix.match.client.response.GetInvoiceDetailResult;
import com.xforceplus.phoenix.match.client.response.RecommendBillsResult;
import com.xforceplus.phoenix.match.client.response.RecommendInvoicesResult;
import com.xforceplus.phoenix.match.client.response.Response;
import com.xforceplus.phoenix.match.client.response.SearchMatchResult;
import com.xforceplus.phoenix.match.client.response.SearchNotMatchByInvoiceResult;
import com.xforceplus.phoenix.match.common.MatchConstant;
import com.xforceplus.phoenix.match.common.enums.CancelMatchTypeEnum;
import com.xforceplus.phoenix.match.common.enums.ConfirmStatusTypeEnum;
import com.xforceplus.phoenix.match.common.enums.ItemCheckSwitcherEnum;
import com.xforceplus.phoenix.match.common.enums.MatchLogTypeEnum;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.NewMatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.NewMatchTypeEnum;
import com.xforceplus.phoenix.match.common.mapstruct.MatchMapper;
import com.xforceplus.phoenix.match.common.mapstruct.NewMatchMapper;
import com.xforceplus.phoenix.match.common.mapstruct.SalesBillEntityMapper;
import com.xforceplus.phoenix.match.monitor.MatchMonitorService;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillInvoiceDao;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.daoext.MtcSalesbillDaoExt;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemExample;
import com.xforceplus.phoenix.match.service.BillInvoiceGroupService;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.MatchOperateLogService;
import com.xforceplus.phoenix.match.service.NewMatchService;
import com.xforceplus.phoenix.match.service.SalesbillItemService;
import com.xforceplus.phoenix.match.service.ValidateService;
import com.xforceplus.phoenix.pim.client.model.MsMatchBean;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceGetPageResponse;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import com.xforceplus.phoenix.tools.enums.InvoiceStatusEnum;
import com.xforceplus.phoenix.tools.transaction.TransactionServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.TransactionalEventService;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewMatchServiceImpl
implements NewMatchService {
    private static final Logger logger = LoggerFactory.getLogger(NewMatchServiceImpl.class);
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;
    @Autowired
    MtcSalesbillItemDao mtcSalesbillItemDao;
    @Autowired
    MtcSalesbillInvoiceDao mtcSalesbillInvoiceDao;
    @Autowired
    MatchOperateLogService matchOperateLogService;
    @Autowired
    DependService dependService;
    @Autowired
    ValidateService validateService;
    @Autowired
    RabbitmqService rabbitmqService;
    @Resource
    TransactionalEventService transactionalEventService;
    @Resource
    TransactionServiceInvoker transactionServiceInvoker;
    @Autowired
    MtcSalesbillDaoExt mtcSalesbillDaoExt;
    @Autowired
    MatchMapper matchMapper;
    @Autowired
    NewMatchMapper newMatchMapper;
    @Autowired
    SalesBillEntityMapper salesBillEntityMapper;
    @Autowired
    SalesbillItemService salesbillItemService;
    @Autowired
    PimInvoiceMatchClient pimInvoiceMatchClient;
    @Autowired
    BillInvoiceGroupService billInvoiceGroupService;
    @Value(value="${auto_match_item_check:0}")
    private Set<Long> AUTO_MATCH_ITEM_CHECK;
    @Value(value="${handle_match_item_check:0}")
    private Integer HANDLE_MATCH_ITEM_CHECK;
    @Autowired
    private MatchMonitorService matchMonitorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public Response createMatch(MatchRequest data) {
        logger.info("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb\u5165\u53c2:{}", (Object)data);
        String validateResponse = this.validateService.validateCreateMatchParameter(data);
        if (StringUtils.isNotBlank((CharSequence)validateResponse)) {
            return Response.fail((String)validateResponse);
        }
        HashMap lockedMap = new HashMap();
        String lockBillAndInvoiceMsg = this.dependService.lockBillAndInvoice(data.getSalesBillIds(), data.getInvoiceIds(), Collections.EMPTY_LIST, lockedMap);
        if (StringUtils.isNotEmpty((CharSequence)lockBillAndInvoiceMsg)) {
            logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfblockBillAndInvoiceMsg:{}, request:{}", (Object)lockBillAndInvoiceMsg, (Object)data);
            return Response.fail((String)lockBillAndInvoiceMsg);
        }
        try {
            boolean isMatchItem;
            long startTime = System.currentTimeMillis();
            List mtcSalesbillEntityList = this.getMtcSalesbillEntityList(data.getSalesBillIds());
            if (data.getSalesBillIds().size() != mtcSalesbillEntityList.size()) {
                logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,errorMessage:{},createMatch.mtcSalesbillEntityList:{}", (Object)"\u4e1a\u52a1\u5355ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!", (Object)mtcSalesbillEntityList);
                Response response = Response.fail((String)"\u4e1a\u52a1\u5355ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
                return response;
            }
            List msPimInvoiceRowList = this.dependService.getMsPimInvoiceRowList(data.getInvoiceIds());
            if (data.getInvoiceIds().size() != msPimInvoiceRowList.size()) {
                logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,errorMessage:{},createMatch.msPimInvoiceRowList:{}", (Object)"\u53d1\u7968ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!", (Object)msPimInvoiceRowList);
                Response response = Response.fail((String)"\u53d1\u7968ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
                return response;
            }
            if (msPimInvoiceRowList.stream().anyMatch(r -> r.getStatus() > 1)) {
                logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,errorMessage:{},createMatch.msPimInvoiceRowList:{}", (Object)"\u53d1\u7968\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u72b6\u6001", (Object)msPimInvoiceRowList);
                Response response = Response.fail((String)"\u8fdb\u884c\u5339\u914d\u64cd\u4f5c\u7684\u53d1\u7968\u72b6\u6001\u5fc5\u987b\u662f\u6b63\u5e38\u7684");
                return response;
            }
            HashMap unMatchedAmountSumMap = new HashMap(2);
            String validateSellerAndPurchaserMsg = this.validateService.validateSellerAndPurchaser(mtcSalesbillEntityList, msPimInvoiceRowList, unMatchedAmountSumMap);
            if (StringUtils.isNotEmpty((CharSequence)validateSellerAndPurchaserMsg)) {
                logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,validateSellerAndPurchaserMsg:{}", (Object)validateSellerAndPurchaserMsg);
                Response response = Response.fail((String)validateSellerAndPurchaserMsg);
                return response;
            }
            List invoiceErrorVOList = this.validateService.validateMatchConditionRules(((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserId(), ((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserGroupId(), msPimInvoiceRowList);
            if (CollectionUtils.isNotEmpty((Collection)invoiceErrorVOList)) {
                logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,errorMessage:{},invoiceErrorVOList:{}", (Object)"\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\uff01", (Object)invoiceErrorVOList);
                Response response = Response.fail((Integer)Response.RESULT_FAIL_INVOICE_LIST_CODE, (String)"\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\uff01", (Object)invoiceErrorVOList);
                return response;
            }
            InvoiceBillCheckListVO invoiceBillCheckListVO = null;
            boolean isAutoItemCheck = MatchType.AUTO.getCode().equals(data.getMatchType()) && this.AUTO_MATCH_ITEM_CHECK.contains(((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserGroupId());
            boolean isHandItemCheck = MatchType.HANDWORK.getCode().equals(data.getMatchType()) && this.HANDLE_MATCH_ITEM_CHECK.equals(ItemCheckSwitcherEnum.OPENED.value());
            boolean bl = isMatchItem = isAutoItemCheck || isHandItemCheck;
            if (!data.getMatchType().equals(NewMatchTypeEnum.FORCE_MATCH.getValue())) {
                logger.info("\u6821\u9a8c\u53d1\u7968\u660e\u7ec6\u54c1\u540d");
                invoiceBillCheckListVO = this.validateService.validateInvoiceCargoNameForMatch(mtcSalesbillEntityList, msPimInvoiceRowList);
                if (!Objects.isNull(invoiceBillCheckListVO) && !CommonUtils.isEmpty((List)invoiceBillCheckListVO.getInvoiceErrorVOList())) {
                    logger.warn("createMatch\u521b\u5efa\u914d\u5355\u5173\u7cfb,errorMessage:{},invoiceBillListErrorVO:{}", (Object)"\u53d1\u7968\u54c1\u540d\u6216\u522b\u540d\u4e0e\u7968\u636e\u54c1\u540d\u6ca1\u6709\u76f8\u4e92\u5339\u914d!", (Object)invoiceBillCheckListVO);
                    if (!isMatchItem) {
                        Response response = Response.fail((Integer)Response.RESULT_FAIL_FORCE, (String)"\u53d1\u7968\u54c1\u540d\u6216\u522b\u540d\u4e0e\u7968\u636e\u54c1\u540d\u6ca1\u6709\u76f8\u4e92\u5339\u914d!", (Object)invoiceBillCheckListVO);
                        return response;
                    }
                }
            }
            this.transactionServiceInvoker.callNewTx(() -> {
                List invoiceMatchList = this.doMatchBillAndInvoice(data, mtcSalesbillEntityList, msPimInvoiceRowList, unMatchedAmountSumMap);
                this.transactionalEventService.callNewAsyncTxAfterCommit(() -> {
                    if (isMatchItem) {
                        Long companyId = ((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserId();
                        Long groupId = ((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserGroupId();
                        List matchDetailConditions = this.dependService.getMatchDetailCondition(companyId, groupId);
                        logger.info("\u8bfb\u53d6\u5230\u7684\u914d\u5355\u660e\u7ec6\u6821\u9a8c\u89c4\u5219 {}, companyId {},groupId {}", new Object[]{JSONObject.toJSONString((Object)matchDetailConditions), companyId, groupId});
                        this.billInvoiceGroupService.validateGroupItemByBillAndInvoice(new HashSet(data.getInvoiceIds()), new HashSet(data.getSalesBillIds()), true, matchDetailConditions, data.getAbleConfirm().booleanValue());
                    }
                    String sendMsg = JsonUtils.writeObjectToJson((Object)invoiceMatchList);
                    logger.info("\u5f3a\u5236\u5339\u914d\u6216\u5df2\u5339\u914d\u53d1\u7968\u4e0b\u53d1\u96c6\u6210\uff0csendMsg:{}", (Object)sendMsg);
                    this.rabbitmqService.sendByTopicExchange("send.match.invoice.queue", (Object)sendMsg);
                });
            });
            long endTime = System.currentTimeMillis();
            logger.info("\u521b\u5efa\u914d\u5355\u5173\u7cfb\u4e3b\u6d41\u7a0b\u8017\u65f6\uff1a{}\uff0c\u5355\u636e\uff1a{}", (Object)(endTime - startTime), (Object)JSONObject.toJSONString((Object)data.getSalesBillIds()));
        }
        finally {
            this.dependService.unLockBillAndInvoice(lockedMap);
        }
        return Response.success(null);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    private List<MsMatchBean> doMatchBillAndInvoice(MatchRequest data, List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList, Map<String, BigDecimal> unMatcheAmountSumMap) {
        BigDecimal unMatchedBillAmountSum = unMatcheAmountSumMap.get("UN_MATCHED_BILL_AMOUNT_SUM");
        BigDecimal unMatchedInvoiceAmountSum = unMatcheAmountSumMap.get("UN_MATCHED_INVOICE_AMOUNT_SUM");
        BigDecimal minUnMatchedAmountSum = unMatchedBillAmountSum;
        if (unMatchedBillAmountSum.compareTo(unMatchedInvoiceAmountSum) > 0) {
            minUnMatchedAmountSum = unMatchedInvoiceAmountSum;
        }
        if (unMatchedBillAmountSum.compareTo(BigDecimal.ZERO) < 0 && unMatchedInvoiceAmountSum.compareTo(BigDecimal.ZERO) < 0) {
            minUnMatchedAmountSum = unMatchedBillAmountSum.abs().compareTo(unMatchedInvoiceAmountSum.abs()) > 0 ? unMatchedInvoiceAmountSum : unMatchedBillAmountSum;
        }
        ArrayList<MsMatchBean> invoiceMatchList = new ArrayList<MsMatchBean>();
        ArrayList sendMatchEndBillList = Lists.newArrayList();
        BigDecimal tolerance = this.dependService.getTolerance(mtcSalesbillEntityList.get(0).getPurchaserId(), mtcSalesbillEntityList.get(0).getPurchaserGroupId());
        for (MtcSalesbillEntity mtcSalesbillEntity : mtcSalesbillEntityList) {
            BigDecimal unMatchedBillAmount = mtcSalesbillEntity.getAmountWithTax().subtract(mtcSalesbillEntity.getDiscountWithTaxTotal()).subtract(mtcSalesbillEntity.getAlreadyAmountWithTax());
            BigDecimal unMatchedBillAmountRatio = unMatchedBillAmount.divide(unMatchedBillAmountSum, 10, 4);
            BigDecimal matchedBillAmountSum = BigDecimal.ZERO;
            for (MsPimInvoiceRow msPimInvoiceRow : msPimInvoiceRowList) {
                BigDecimal unMatchedInvoiceAmount = new BigDecimal(msPimInvoiceRow.getAmountWithTax()).subtract(new BigDecimal(msPimInvoiceRow.getMatchAmount()));
                BigDecimal unMatchedInvoiceAmountRatio = unMatchedInvoiceAmount.divide(unMatchedInvoiceAmountSum, 10, 4);
                BigDecimal matchAmount = unMatchedBillAmountRatio.multiply(unMatchedInvoiceAmountRatio).multiply(minUnMatchedAmountSum);
                MtcSalesbillInvoiceEntity record = new MtcSalesbillInvoiceEntity();
                record = this.newMatchMapper.toBillInvoiceRecord(mtcSalesbillEntity);
                record.setForceMatchReason(data.getForceMatchReason());
                record.setForceMatchReasonType(data.getForceMatchReasonType());
                record.setInvoiceCode(msPimInvoiceRow.getInvoiceCode());
                record.setInvoiceId(msPimInvoiceRow.getId());
                record.setInvoiceNo(msPimInvoiceRow.getInvoiceNo());
                MtcSalesbillInvoiceExample exampleSelect = new MtcSalesbillInvoiceExample();
                MtcSalesbillInvoiceExample.Criteria criteria = exampleSelect.createCriteria();
                criteria.andInvoiceIdEqualTo(msPimInvoiceRow.getId()).andInvoiceCodeEqualTo(msPimInvoiceRow.getInvoiceCode()).andInvoiceNoEqualTo(msPimInvoiceRow.getInvoiceNo()).andStatusNotEqualTo(NewMatchStatusEnum.CANCEL.getValue());
                List mtcSalesbillInvoiceEntityList = this.mtcSalesbillInvoiceDao.selectByExample(exampleSelect);
                List<Object> mtcSalesbillInvoiceEntityListNew = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)mtcSalesbillInvoiceEntityList)) {
                    mtcSalesbillInvoiceEntityListNew = mtcSalesbillInvoiceEntityList.stream().filter(obj -> obj.getSalesbillId().equals(mtcSalesbillEntity.getSalesbillId())).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty(mtcSalesbillInvoiceEntityListNew)) {
                    record.setCreateTime(new Date());
                    record.setCreateUser(data.getSysUserId());
                    record.setInvoicePaperDrewDate(msPimInvoiceRow.getPaperDrewDate());
                    record.setInvoiceScanTime(StringUtils.isBlank((CharSequence)msPimInvoiceRow.getRecogResponseTime()) ? null : new Date(Long.parseLong(msPimInvoiceRow.getRecogResponseTime())));
                    record.setInvoiceType(msPimInvoiceRow.getInvoiceType());
                    record.setInvoiceSellerOrigin(msPimInvoiceRow.getSellerOrigin());
                    record.setStatus(data.getAbleConfirm() != false ? NewMatchStatusEnum.UNCONFIRMED.getValue() : NewMatchStatusEnum.OK.getValue());
                    record.setMatchType(data.getMatchType());
                    record.setPurchaserGroupId(msPimInvoiceRow.getPurchaserGroupId());
                    record.setPurchaserName(msPimInvoiceRow.getPurchaserName());
                    record.setPurchaserTaxNo(msPimInvoiceRow.getPurchaserTaxNo());
                    record.setSysOrgId(data.getSysOrgId());
                    record.setInvoiceAmountWithoutTax(new BigDecimal(msPimInvoiceRow.getAmountWithoutTax()));
                    record.setInvoiceAmountWithTax(new BigDecimal(msPimInvoiceRow.getAmountWithTax()));
                    record.setInvoiceTaxAmount(new BigDecimal(msPimInvoiceRow.getTaxAmount()));
                    if (!CommonUtils.isEmpty((String)msPimInvoiceRow.getRecogResponseTime())) {
                        record.setInvoiceScanTime(new Date(new Long(msPimInvoiceRow.getRecogResponseTime())));
                    }
                    record.setMatchAmount(matchAmount);
                    this.mtcSalesbillInvoiceDao.insertSelective(record);
                    this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.MATCH.getValue().intValue(), mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), record.toString(), "\u65b0\u589e\u914d\u5355", data.getSysUserId(), data.getSysUserName());
                } else {
                    record.setMatchAmount(matchAmount.add(((MtcSalesbillInvoiceEntity)mtcSalesbillInvoiceEntityListNew.get(0)).getMatchAmount()));
                    record.setStatus(data.getAbleConfirm() != false || ((MtcSalesbillInvoiceEntity)mtcSalesbillInvoiceEntityListNew.get(0)).getStatus().equals(NewMatchStatusEnum.UNCONFIRMED.getValue()) ? NewMatchStatusEnum.UNCONFIRMED.getValue() : NewMatchStatusEnum.OK.getValue());
                    record.setUpdateTime(new Date());
                    record.setUpdateUser(data.getSysUserId());
                    criteria.andSalesbillIdEqualTo(mtcSalesbillEntity.getSalesbillId());
                    this.mtcSalesbillInvoiceDao.updateByExampleSelective(record, exampleSelect);
                    this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.MATCH.getValue().intValue(), mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), record.toString(), "\u66f4\u65b0\u914d\u5355", data.getSysUserId(), data.getSysUserName());
                }
                matchedBillAmountSum = matchedBillAmountSum.add(matchAmount);
                BigDecimal invoiceMatchAmountTmp = BigDecimal.ZERO;
                MsMatchBean matchListItem = this.matchMapper.toMsMatchBean(mtcSalesbillEntity, msPimInvoiceRow.getId(), matchAmount, data.getMatchType());
                if (!(data.getAbleConfirm().booleanValue() || Objects.isNull(mtcSalesbillInvoiceEntityList) || mtcSalesbillInvoiceEntityList.isEmpty())) {
                    List mtcSalesbillInvoiceEntityListUnconfirmed = mtcSalesbillInvoiceEntityList.stream().filter(obj -> obj.getStatus().equals(NewMatchStatusEnum.UNCONFIRMED.getValue())).collect(Collectors.toList());
                    matchListItem.setAbleConfirm(Objects.isNull(mtcSalesbillInvoiceEntityListUnconfirmed) || mtcSalesbillInvoiceEntityListUnconfirmed.isEmpty() ? data.getAbleConfirm() : Boolean.TRUE);
                } else {
                    matchListItem.setAbleConfirm(data.getAbleConfirm());
                }
                invoiceMatchList.add(matchListItem);
            }
            MtcSalesbillEntity mtcSalesbillEntityRecord = new MtcSalesbillEntity();
            mtcSalesbillEntityRecord.setSalesbillId(mtcSalesbillEntity.getSalesbillId());
            BigDecimal alreadyAmountWithTax = mtcSalesbillEntity.getAlreadyAmountWithTax().add(matchedBillAmountSum);
            if (data.getAbleConfirm().booleanValue()) {
                mtcSalesbillEntityRecord.setMatchStatus(MatchStatusEnum.MATCH_CONFIRM.getValue().toString());
            } else if (!this.validateTolerance(alreadyAmountWithTax, mtcSalesbillEntity.getAmountWithTax().subtract(mtcSalesbillEntity.getDiscountWithTaxTotal()), tolerance).booleanValue()) {
                mtcSalesbillEntityRecord.setMatchStatus(MatchStatusEnum.MATCH_ING.getValue().toString());
            } else {
                mtcSalesbillEntityRecord.setMatchStatus(MatchStatusEnum.MATCH_END.getValue().toString());
            }
            mtcSalesbillEntityRecord.setAlreadyAmountWithTax(alreadyAmountWithTax);
            sendMatchEndBillList.add(this.salesBillEntityMapper.reverseMap(mtcSalesbillEntityRecord));
            this.mtcSalesbillDao.updateByPrimaryKeySelective(mtcSalesbillEntityRecord);
            this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.MATCH.getValue().intValue(), mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), mtcSalesbillEntityRecord.toString(), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u548c\u5339\u914d\u91d1\u989d", data.getSysUserId(), data.getSysUserName());
            try {
                this.matchMonitorService.monitor(EventRecord.builder().setEventName("pur_b_billMatch").setDistinctId(data.getSysUserId().toString()).isLoginId(Boolean.TRUE).addProperty("matchType", (Number)data.getMatchType()).addProperty("matchTypeDesc", NewMatchTypeEnum.getNameByValue((int)data.getMatchType())).addProperty("matchUserName", data.getSysUserName()).addProperty("purchaserGroupId", (Number)mtcSalesbillEntity.getPurchaserGroupId()).addProperty("billNo", mtcSalesbillEntity.getSalesbillNo()).build());
            }
            catch (Exception e) {
                logger.error("sensorsAnalytics\u5f02\u5e38", (Throwable)e);
            }
        }
        this.dependService.doBatchUpdateMatchStatus(invoiceMatchList);
        this.transactionalEventService.callNewAsyncTxAfterCommit(() -> {
            String sendMsg = JsonUtils.writeObjectToJson((Object)sendMatchEndBillList);
            logger.info("\u5339\u914d\u5355\u636e\u4e0b\u53d1\u9500\u9879\uff0csendMsg:{}", (Object)sendMsg);
            this.rabbitmqService.sendByTopicExchange("send.match.bill.data", (Object)sendMsg);
        });
        return invoiceMatchList;
    }

    public Boolean validateTolerance(BigDecimal amount1, BigDecimal amount2, BigDecimal tolerance) {
        return amount1.subtract(amount2).abs().compareTo(tolerance) <= 0;
    }

    private List<MtcSalesbillItemEntity> getMtcBillItem(Long salesbillId) {
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        example.createCriteria().andSalesbillIdEqualTo(salesbillId).andStatusNotEqualTo(Integer.valueOf(9));
        return this.mtcSalesbillItemDao.selectByExample(example);
    }

    private List<MtcSalesbillEntity> getMtcSalesbillEntityList(List<Long> salesbillIds) {
        MtcSalesbillExample example = new MtcSalesbillExample();
        example.createCriteria().andSalesbillIdIn(salesbillIds).andStatusEqualTo(Integer.valueOf(1));
        return this.mtcSalesbillDao.selectByExample(example);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public Response cancelMatch(CancelMatchRequest data) {
        logger.info("cancelMatch\u53d6\u6d88\u914d\u5355\u5173\u7cfb\u5165\u53c2cancelMatch.CancelMatchRequest:{}", (Object)data);
        Response validateResponse = this.validateCancelMatchParamter(data);
        if (validateResponse.getCode().equals(Response.RESULT_FAIL)) {
            return validateResponse;
        }
        List billAndInvoices = this.getCancelMatchBillInvoices(data);
        if (CollectionUtils.isEmpty((Collection)billAndInvoices)) {
            return Response.fail((String)"\u914d\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
        }
        List<Object> billIds = Lists.newArrayList();
        if (CancelMatchTypeEnum.RESET_BY_INVOICEID.getValue().equals(data.getOperateType())) {
            billIds = billAndInvoices.stream().map(x -> x.getSalesbillId()).collect(Collectors.toList());
        }
        HashMap lockedMap = new HashMap();
        String lockBillAndInvoiceMsg = this.dependService.lockBillAndInvoice(data.getIds(), (List)billIds, Collections.EMPTY_LIST, lockedMap);
        if (StringUtils.isNotEmpty((CharSequence)lockBillAndInvoiceMsg)) {
            logger.warn("cancelMatch.lockBillAndInvoiceMsg:{}", (Object)lockBillAndInvoiceMsg);
            return Response.fail((String)lockBillAndInvoiceMsg);
        }
        try {
            List billInvoices = this.getCancelMatchBillInvoices(data);
            if (CollectionUtils.isEmpty((Collection)billInvoices)) {
                Response response = Response.fail((String)"\u914d\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
                return response;
            }
            List mtcSalesbillEntityList = this.getMtcSalesbillEntityList(billInvoices.stream().map(obj -> obj.getSalesbillId()).distinct().collect(Collectors.toList()));
            List msPimInvoiceRowList = this.dependService.getMsPimInvoiceRowList(billInvoices.stream().map(obj -> obj.getInvoiceId()).distinct().collect(Collectors.toList()));
            Response doCancelMatchResponse = this.doCancelMatch(data, billInvoices, mtcSalesbillEntityList, msPimInvoiceRowList);
            logger.info("cancelMatch\u53d6\u6d88\u914d\u5355\u5173\u7cfb\u91ca\u653e\u91d1\u989d\u53cd\u9988:{}", (Object)doCancelMatchResponse);
            if (!doCancelMatchResponse.getCode().equals(Response.RESULT_SUCESS)) {
                Response response = doCancelMatchResponse;
                return response;
            }
            boolean isHandItemCheck = this.HANDLE_MATCH_ITEM_CHECK.equals(ItemCheckSwitcherEnum.OPENED.value());
            if (isHandItemCheck) {
                Long companyId = ((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserId();
                Long groupId = ((MtcSalesbillEntity)mtcSalesbillEntityList.get(0)).getPurchaserGroupId();
                List matchDetailConditions = this.dependService.getMatchDetailCondition(companyId, groupId);
                Set invoiceSet = billInvoices.stream().map(e -> e.getInvoiceId()).collect(Collectors.toSet());
                Set saleBillIdSet = billInvoices.stream().map(e -> e.getSalesbillId()).collect(Collectors.toSet());
                this.billInvoiceGroupService.validateGroupItemByBillAndInvoice(invoiceSet, saleBillIdSet, false, matchDetailConditions, false);
            }
        }
        finally {
            this.dependService.unLockBillAndInvoice(lockedMap);
        }
        return Response.success(null);
    }

    private List<MtcSalesbillInvoiceEntity> getCancelMatchBillInvoices(CancelMatchRequest data) {
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        if (data.getOperateType().equals(CancelMatchTypeEnum.CANCEL_BY_RELATIONID.getValue())) {
            example.createCriteria().andIdIn(data.getIds()).andStatusNotEqualTo(NewMatchStatusEnum.CANCEL.getValue());
        }
        if (data.getOperateType().equals(CancelMatchTypeEnum.CANCEL_BY_BILLID.getValue())) {
            example.createCriteria().andSalesbillIdIn(data.getIds()).andStatusNotEqualTo(NewMatchStatusEnum.CANCEL.getValue());
        }
        if (data.getOperateType().equals(CancelMatchTypeEnum.CANCEL_BY_INVOICEID.getValue()) || data.getOperateType().equals(CancelMatchTypeEnum.RESET_BY_INVOICEID.getValue())) {
            example.createCriteria().andInvoiceIdIn(data.getIds()).andStatusNotEqualTo(NewMatchStatusEnum.CANCEL.getValue());
        }
        return this.mtcSalesbillInvoiceDao.selectByExample(example);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    private Response doCancelMatch(CancelMatchRequest data, List<MtcSalesbillInvoiceEntity> mtcSalesbillInvoiceEntityList, List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList) {
        logger.info("\u53d6\u6d88\u914d\u5355\u5165\u53c2,data:{},mtcSalesbillInvoiceEntityList:{},mtcSalesbillEntityList:{},msPimInvoiceRowList:{}", new Object[]{JsonUtils.writeObjectToJson((Object)data), JsonUtils.writeObjectToJson(mtcSalesbillInvoiceEntityList), JsonUtils.writeObjectToJson(mtcSalesbillEntityList), JsonUtils.writeObjectToJson(msPimInvoiceRowList)});
        if (CollectionUtils.isEmpty(mtcSalesbillInvoiceEntityList)) {
            logger.warn("cancelMatch\u53d6\u6d88\u914d\u5355\u5173\u7cfbcancelMatch.mtcSalesbillInvoiceEntityList:{}", (Object)"\u914d\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
            return Response.fail((String)"\u914d\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
        }
        if (!data.getOperateType().equals(CancelMatchTypeEnum.RESET_BY_INVOICEID.getValue())) {
            logger.info("doCancelMatch\u6267\u884c\u53d6\u6d88\u914d\u5355\u89c4\u5219\u6821\u9a8c");
            List billErrorVOList = this.validateService.validateMatchConditionCancelRules(mtcSalesbillInvoiceEntityList.get(0).getPurchaserId(), mtcSalesbillInvoiceEntityList.get(0).getPurchaserGroupId(), mtcSalesbillEntityList);
            if (CollectionUtils.isNotEmpty((Collection)billErrorVOList)) {
                logger.warn("cancelMatch\u53d6\u6d88\u914d\u5355\u5173\u7cfbcancelMatch.billErrorVOList:{}", (Object)"\u5355\u636e\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\uff01", (Object)billErrorVOList);
                return Response.fail((Integer)Response.RESULT_FAIL_INVOICE_LIST_CODE, (String)"\u5355\u636e\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\uff01", (Object)billErrorVOList);
            }
            List invoiceErrorVOList = this.validateService.validateInvoiceMatchConditionCancelRules(mtcSalesbillInvoiceEntityList.get(0).getPurchaserId(), mtcSalesbillInvoiceEntityList.get(0).getPurchaserGroupId(), msPimInvoiceRowList);
            if (CollectionUtils.isNotEmpty((Collection)invoiceErrorVOList)) {
                logger.warn("cancelMatch\u53d6\u6d88\u914d\u5355\u5173\u7cfbcancelMatch.invoiceErrorVOList:{}", (Object)"\u53d1\u7968\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\uff01", (Object)invoiceErrorVOList);
                return Response.fail((Integer)Response.RESULT_FAIL_INVOICE_LIST_CODE, (String)"\u53d1\u7968\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\uff01", (Object)invoiceErrorVOList);
            }
        }
        HashSet sendBillId = Sets.newHashSet();
        ArrayList<MtcSalesbillEntity> mtcSalesbillEntities = new ArrayList<MtcSalesbillEntity>();
        for (MtcSalesbillInvoiceEntity mtcSalesbillInvoiceEntity : mtcSalesbillInvoiceEntityList) {
            Integer newStatus;
            MsPimInvoiceRow msPimInvoiceRow = this.dependService.getMsPimInvoiceRowById(mtcSalesbillInvoiceEntity.getInvoiceId());
            MtcSalesbillEntity mtcSalesbillEntity = mtcSalesbillEntityList.stream().filter(e -> e.getSalesbillId().equals(mtcSalesbillInvoiceEntity.getSalesbillId())).findFirst().get();
            mtcSalesbillEntities.add(mtcSalesbillEntity);
            MtcSalesbillEntity record = new MtcSalesbillEntity();
            record.setSalesbillId(mtcSalesbillInvoiceEntity.getSalesbillId());
            BigDecimal alreadyAmountWithTax = mtcSalesbillEntity.getAlreadyAmountWithTax().subtract(mtcSalesbillInvoiceEntity.getMatchAmount());
            record.setAlreadyAmountWithTax(alreadyAmountWithTax);
            mtcSalesbillEntity.setAlreadyAmountWithTax(alreadyAmountWithTax);
            MtcSalesbillInvoiceExample mtcSalesbillInvoiceExample = new MtcSalesbillInvoiceExample();
            mtcSalesbillInvoiceExample.createCriteria().andSalesbillIdEqualTo(mtcSalesbillInvoiceEntity.getSalesbillId()).andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue()).andInvoiceIdNotIn(mtcSalesbillInvoiceEntityList.stream().map(r -> r.getInvoiceId()).collect(Collectors.toList()));
            List mtcSalesbillInvoiceEntities = this.mtcSalesbillInvoiceDao.selectByExample(mtcSalesbillInvoiceExample);
            Integer n = newStatus = CollectionUtils.isEmpty((Collection)mtcSalesbillInvoiceEntities) ? MatchStatusEnum.MATCH_ING.getValue() : MatchStatusEnum.MATCH_CONFIRM.getValue();
            if (alreadyAmountWithTax.compareTo(BigDecimal.ZERO) == 0 || alreadyAmountWithTax.abs().compareTo(new BigDecimal("0.001")) <= 0) {
                record.setAlreadyAmountWithTax(BigDecimal.ZERO);
                record.setMatchStatus(MatchStatusEnum.NO_MATCH.getValue().toString());
            } else if (mtcSalesbillInvoiceEntity.getMatchAmount().compareTo(BigDecimal.ZERO) != 0) {
                record.setMatchStatus(newStatus.toString());
            }
            record.setSalesbillNo(mtcSalesbillEntity.getSalesbillNo());
            record.setSendStatus(Integer.valueOf(0));
            logger.info("\u53d6\u6d88\u914d\u5355\u66f4\u65b0\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)record);
            this.mtcSalesbillDao.updateByPrimaryKeySelective(record);
            sendBillId.add(record.getSalesbillId());
            this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.CANCEL_MATCH.getValue().intValue(), mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), record.toString(), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u548c\u5339\u914d\u91d1\u989d", data.getSysUserId(), data.getSysUserName());
            MtcSalesbillInvoiceEntity billInvoiceEntity = new MtcSalesbillInvoiceEntity();
            if (msPimInvoiceRow.getStatus().equals(InvoiceStatusEnum.CANCELED.code()) || msPimInvoiceRow.getStatus().equals(InvoiceStatusEnum.BE_RED.code())) {
                billInvoiceEntity.setId(mtcSalesbillInvoiceEntity.getId());
                billInvoiceEntity.setMatchAmount(BigDecimal.ZERO);
                billInvoiceEntity.setUpdateTime(new Date());
                billInvoiceEntity.setUpdateUser(data.getSysUserId());
            } else {
                billInvoiceEntity.setId(mtcSalesbillInvoiceEntity.getId());
                if (!data.getOperateType().equals(CancelMatchTypeEnum.RESET_BY_INVOICEID.getValue())) {
                    billInvoiceEntity.setStatus(NewMatchStatusEnum.CANCEL.getValue());
                }
                billInvoiceEntity.setUpdateTime(new Date());
                billInvoiceEntity.setUpdateUser(data.getSysUserId());
            }
            this.mtcSalesbillInvoiceDao.updateByPrimaryKeySelective(billInvoiceEntity);
            this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.CANCEL_MATCH.getValue().intValue(), billInvoiceEntity.getSalesbillId(), "", billInvoiceEntity.toString(), "\u66f4\u65b0\u5339\u914d\u5173\u7cfb\u72b6\u6001\u548c\u5339\u914d\u91d1\u989d", data.getSysUserId(), data.getSysUserName());
        }
        Map getInvoiceUnconfirmedMap = this.getInvoiceUnconfirmedMap(mtcSalesbillInvoiceEntityList);
        List<Object> invoiceMatchList = new ArrayList();
        invoiceMatchList = mtcSalesbillInvoiceEntityList.stream().map(obj -> {
            MsMatchBean dto = new MsMatchBean();
            dto.setBussinessId(obj.getSalesbillId());
            dto.setBussinessNo(obj.getSalesbillNo());
            dto.setInvoiceId(obj.getInvoiceId());
            dto.setMatchAmount(obj.getMatchAmount().toString());
            dto.setMatchType(Integer.valueOf(NewMatchTypeEnum.CANCEL_MATCH.getValue()));
            Optional.ofNullable(mtcSalesbillEntities.stream().filter(r -> r.getSalesbillId().equals(obj.getSalesbillId())).collect(Collectors.toList())).ifPresent(u -> dto.setSalesbillType(CollectionUtils.isEmpty((Collection)u) ? "" : ((MtcSalesbillEntity)u.get(0)).getSalesbillType()));
            dto.setAbleConfirm((Boolean)getInvoiceUnconfirmedMap.get(obj.getInvoiceId()));
            return dto;
        }).collect(Collectors.toList());
        this.dependService.doBatchUpdateMatchStatus(invoiceMatchList);
        List<Object> finalInvoiceMatchList = invoiceMatchList;
        this.transactionalEventService.callNewAsyncTxAfterCommit(() -> {
            MtcSalesbillExample sendExample = new MtcSalesbillExample();
            sendExample.createCriteria().andSalesbillIdIn((List)Lists.newArrayList((Iterable)sendBillId));
            List salesbillEntities = this.mtcSalesbillDao.selectByExample(sendExample);
            String sendMsg = JsonUtils.writeObjectToJson((Object)this.salesBillEntityMapper.reverseMap(salesbillEntities));
            logger.info("\u53d6\u6d88\u5339\u914d\u5355\u636e\u4e0b\u53d1\u9500\u9879\uff0csendMsg:{}", (Object)sendMsg);
            this.rabbitmqService.sendByTopicExchange("send.match.bill.data", (Object)sendMsg);
            String sendMsgToJanus = JsonUtils.writeObjectToJson((Object)finalInvoiceMatchList);
            logger.info("\u53d6\u6d88\u5339\u914d\u4e0b\u53d1\u96c6\u6210\uff0csendMsgToJanus:{}", (Object)sendMsgToJanus);
            this.rabbitmqService.sendByTopicExchange("send.match.invoice.queue", (Object)sendMsgToJanus);
        });
        return Response.success(null);
    }

    private Map<Long, Boolean> getInvoiceUnconfirmedMap(List<MtcSalesbillInvoiceEntity> mtcSalesbillInvoiceEntityList) {
        List salesBillIds = mtcSalesbillInvoiceEntityList.stream().map(obj -> obj.getSalesbillId()).collect(Collectors.toList());
        Map<Long, List<MtcSalesbillInvoiceEntity>> groupBy = mtcSalesbillInvoiceEntityList.stream().collect(Collectors.groupingBy(MtcSalesbillInvoiceEntity::getInvoiceId));
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(groupBy.size());
        for (Long invoiceId : groupBy.keySet()) {
            List billIds = groupBy.get(invoiceId).stream().map(obj -> obj.getSalesbillId()).collect(Collectors.toList());
            MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
            example.createCriteria().andSalesbillIdNotIn(salesBillIds).andInvoiceIdEqualTo(invoiceId).andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue());
            List mtcSalesbillInvoiceEntityListNew = this.mtcSalesbillInvoiceDao.selectByExample(example);
            map.put(invoiceId, CollectionUtils.isEmpty((Collection)mtcSalesbillInvoiceEntityListNew) ? Boolean.FALSE : Boolean.TRUE);
        }
        return map;
    }

    private Response validateCancelMatchParamter(CancelMatchRequest data) {
        return CollectionUtils.isEmpty((Collection)data.getIds()) ? Response.fail((String)"\u53d6\u6d88\u5339\u914did\u4e0d\u80fd\u4e3a\u7a7a!") : Response.success(null);
    }

    public Response<SearchMatchResult> searchMatchByBill(SearchMatchRequest request) {
        logger.info("\u3010\u6839\u636e\u4e1a\u52a1\u5355\u67e5\u8be2\u5df2\u5339\u914d\u53d1\u7968\u3011\u5165\u53c2searchMatchByBill.SearchMatchRequest:{}", (Object)request);
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        MtcSalesbillInvoiceExample.Criteria criteria = example.createCriteria();
        String validateSearchMatchMsg = this.validateService.validateSearchMatch(request, example, criteria);
        if (!StringUtils.isBlank((CharSequence)validateSearchMatchMsg)) {
            logger.warn("searchMatchByBill.validateSearchMatchMsg:{}", (Object)validateSearchMatchMsg);
            return Response.fail((String)validateSearchMatchMsg);
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getIds())) {
            criteria.andSalesbillIdIn(request.getIds());
        }
        SearchMatchResult newSearchMatchByBillResult = new SearchMatchResult();
        newSearchMatchByBillResult.setMatchRelationList(this.mtcSalesbillInvoiceDao.selectByExample(example).stream().map(obj -> {
            Long invoiceId = obj.getInvoiceId();
            List detailRowList = this.dependService.getMsPimInvoiceDetailRowById(invoiceId);
            MatchRelationVO matchRelationVO = this.matchMapper.toMatchRelationVo(obj, detailRowList);
            return matchRelationVO;
        }).collect(Collectors.toList()));
        newSearchMatchByBillResult.setTotal(Long.valueOf(this.mtcSalesbillInvoiceDao.countByExample(example)));
        return Response.success((Object)newSearchMatchByBillResult);
    }

    public Response<SearchMatchResult> searchMatchByInvoice(SearchMatchRequest request) {
        logger.info("\u3010\u6839\u636e\u53d1\u7968\u67e5\u8be2\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u3011\u5165\u53c2searchMatchByInvoice.SearchMatchRequest:{}", (Object)request);
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        MtcSalesbillInvoiceExample.Criteria criteria = example.createCriteria();
        SearchMatchResult newSearchMatchByBillResult = new SearchMatchResult();
        String validateSearchMatchMsg = this.validateService.validateSearchMatch(request, example, criteria);
        if (!StringUtils.isBlank((CharSequence)validateSearchMatchMsg)) {
            logger.warn("searchMatchByInvoice.validateSearchMatchMsg:{}", (Object)validateSearchMatchMsg);
            return Response.fail((String)validateSearchMatchMsg);
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getIds())) {
            criteria.andInvoiceIdIn(request.getIds());
        }
        newSearchMatchByBillResult.setMatchRelationList(this.mtcSalesbillInvoiceDao.selectByExample(example).stream().map(obj -> {
            MatchRelationVO dto = new MatchRelationVO();
            CommonUtils.copyProperties((Object)obj, (Object)dto);
            MtcSalesbillEntity mtcSalesbillEntity = this.mtcSalesbillDao.selectByPrimaryKey(obj.getSalesbillId());
            dto.setBillAmountWithoutTax(mtcSalesbillEntity.getAmountWithoutTax());
            dto.setBillAmountWithTax(mtcSalesbillEntity.getAmountWithTax());
            dto.setBillTaxAmount(mtcSalesbillEntity.getTaxAmount());
            dto.setExt2(mtcSalesbillEntity.getExt2());
            dto.setExt3(mtcSalesbillEntity.getExt3());
            List<Object> billItemVOList = new ArrayList();
            MtcSalesbillItemExample mtcSalesbillItemExample = new MtcSalesbillItemExample();
            mtcSalesbillItemExample.createCriteria().andSalesbillIdEqualTo(obj.getSalesbillId()).andStatusNotEqualTo(Integer.valueOf(0));
            List mtcSalesbillItemEntityList = this.mtcSalesbillItemDao.selectByExample(mtcSalesbillItemExample);
            if (!Objects.isNull(mtcSalesbillItemEntityList)) {
                billItemVOList = mtcSalesbillItemEntityList.stream().map(mtcSalesbillItemEntity -> {
                    BillItemVO invoiceItemVO = new BillItemVO();
                    BeanUtils.copyProperties((Object)mtcSalesbillItemEntity, (Object)invoiceItemVO);
                    return invoiceItemVO;
                }).collect(Collectors.toList());
            }
            dto.setBillItemVOList(billItemVOList);
            return dto;
        }).collect(Collectors.toList()));
        newSearchMatchByBillResult.setTotal(Long.valueOf(this.mtcSalesbillInvoiceDao.countByExample(example)));
        return Response.success((Object)newSearchMatchByBillResult);
    }

    public Response<SearchNotMatchByInvoiceResult> searchNotMatchByInvoice(SearchNotMatchByInvoiceRequest request) {
        logger.info("\u67e5\u8be2\u53d1\u7968\u672a\u5339\u914d\u4fe1\u606f\u5165\u53c2,searchNotMatchByInvoice.SearchNotMatchByInvoiceRequest:{}", (Object)request);
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        SearchNotMatchByInvoiceResult newSearchNotMatchByInvoiceResult = new SearchNotMatchByInvoiceResult();
        String validateSearchNotMatchByInvoiceMsg = this.validateService.validateSearchNotMatchByInvoice(request, example, criteria);
        if (!StringUtils.isBlank((CharSequence)validateSearchNotMatchByInvoiceMsg)) {
            logger.warn("searchNotMatchByInvoice.validateSearchNotMatchByInvoiceMsg:{}", (Object)validateSearchNotMatchByInvoiceMsg);
            return Response.fail((String)validateSearchNotMatchByInvoiceMsg);
        }
        List msPimInvoiceRowList = this.dependService.getMsPimInvoiceRowList(request.getIds());
        if (msPimInvoiceRowList.isEmpty()) {
            logger.warn("searchNotMatchByInvoice.msPimInvoiceRowList:{}", (Object)"\u53d1\u7968ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
            return Response.fail((String)"\u53d1\u7968ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
        }
        Set sellerTaxNo = msPimInvoiceRowList.stream().map(r -> {
            if (r.getIssueFlag().equals(0)) {
                return r.getSellerTaxNo();
            }
            return r.getIssueTaxNo();
        }).collect(Collectors.toSet());
        Set purchaserId = msPimInvoiceRowList.stream().map(r -> r.getPurchaserCompanyId()).collect(Collectors.toSet());
        Set purchaserGroupId = msPimInvoiceRowList.stream().map(r -> r.getPurchaserGroupId()).collect(Collectors.toSet());
        if (sellerTaxNo.size() > 1) {
            return Response.fail((String)"\u9500\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!");
        }
        if (purchaserId.size() > 1 || purchaserGroupId.size() > 1) {
            return Response.fail((String)"\u8d2d\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!");
        }
        if (CollectionUtils.isEmpty((Collection)request.getKeyword())) {
            request.setKeyword(null);
        }
        criteria.andSellerTaxNoEqualTo((String)sellerTaxNo.iterator().next()).andPurchaserGroupIdEqualTo((Long)purchaserGroupId.iterator().next()).andPurchaserIdEqualTo((Long)purchaserId.iterator().next()).andSysOrgIdIn(request.getOrgIds());
        List salesbillEntities = new ArrayList();
        long count = 0L;
        if (CollectionUtils.isNotEmpty((Collection)request.getItemKeyword())) {
            salesbillEntities = this.mtcSalesbillDaoExt.selectByExampleJoinItem(example, request.getKeyword(), request.getItemKeyword());
            count = this.mtcSalesbillDaoExt.countByExampleJoinItem(example, request.getKeyword(), request.getItemKeyword());
        } else {
            salesbillEntities = this.mtcSalesbillDaoExt.selectByExample(example, request.getKeyword());
            count = this.mtcSalesbillDaoExt.countByExample(example, request.getKeyword());
        }
        newSearchNotMatchByInvoiceResult.setBillVOList(salesbillEntities.stream().map(obj -> {
            BillVO dto = new BillVO();
            CommonUtils.copyProperties((Object)obj, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        newSearchNotMatchByInvoiceResult.setTotal(Long.valueOf(count));
        return Response.success((Object)newSearchNotMatchByInvoiceResult);
    }

    public Response<RecommendBillsResult> recommendBills(RecommendBillsRequest request) {
        logger.info("\u5355\u636e\u63a8\u8350\u5165\u53c2recommendBills.RecommendBillsRequest:{}", (Object)request);
        if (Objects.isNull(request.getInvoiceId()) || request.getInvoiceId() == 0L) {
            return Response.fail((String)"\u53c2\u6570\u4e0d\u6b63\u786e!");
        }
        RecommendBillsResult recommendBillsResult = new RecommendBillsResult();
        MsPimInvoiceRow msPimInvoiceRow = this.dependService.getMsPimInvoiceRowById(request.getInvoiceId());
        if (!this.dependService.checkInvoiceRecommend(msPimInvoiceRow).booleanValue()) {
            recommendBillsResult.setTotal(MatchConstant.LONG_ZERO);
            return Response.success((Object)recommendBillsResult);
        }
        MtcSalesbillExample example = new MtcSalesbillExample();
        if (msPimInvoiceRow.getIssueFlag().equals(0)) {
            example.createCriteria().andSellerTaxNoEqualTo(msPimInvoiceRow.getSellerTaxNo()).andPurchaserIdEqualTo(msPimInvoiceRow.getPurchaserCompanyId()).andMatchStatusNotEqualTo(MatchStatusEnum.MATCH_END.getValue().toString()).andStatusNotEqualTo(Integer.valueOf(0));
        } else {
            example.createCriteria().andSellerTaxNoEqualTo(msPimInvoiceRow.getIssueTaxNo()).andPurchaserIdEqualTo(msPimInvoiceRow.getPurchaserCompanyId()).andMatchStatusNotEqualTo(MatchStatusEnum.MATCH_END.getValue().toString()).andStatusNotEqualTo(Integer.valueOf(0));
        }
        List mtcSalesbillEntityList = this.mtcSalesbillDaoExt.selectByExample(example, null);
        if (CollectionUtils.isEmpty((Collection)mtcSalesbillEntityList)) {
            recommendBillsResult.setTotal(MatchConstant.LONG_ZERO);
            return Response.success((Object)recommendBillsResult);
        }
        BigDecimal noMatchInvoiceAmount = new BigDecimal(msPimInvoiceRow.getAmountWithTax()).subtract(new BigDecimal(msPimInvoiceRow.getMatchAmount()));
        BigDecimal tolerance = this.dependService.getTolerance(msPimInvoiceRow.getPurchaserCompanyId(), msPimInvoiceRow.getPurchaserGroupId());
        if (CollectionUtils.isEmpty(mtcSalesbillEntityList = mtcSalesbillEntityList.stream().filter(mtcSalesbillEntity -> this.validateTolerance(noMatchInvoiceAmount, mtcSalesbillEntity.getAmountWithTax().subtract(mtcSalesbillEntity.getDiscountWithTaxTotal()).subtract(mtcSalesbillEntity.getAlreadyAmountWithTax()), tolerance)).collect(Collectors.toList()))) {
            recommendBillsResult.setTotal(MatchConstant.LONG_ZERO);
            return Response.success((Object)recommendBillsResult);
        }
        Map<Long, Integer> billWeight = mtcSalesbillEntityList.stream().collect(Collectors.toMap(item -> item.getSalesbillId(), item -> 0));
        Map<Long, StringBuilder> billWeightRemark = mtcSalesbillEntityList.stream().collect(Collectors.toMap(item -> item.getSalesbillId(), item -> new StringBuilder()));
        this.validateService.validateInvoiceCargoName(mtcSalesbillEntityList, (List)Lists.newArrayList((Object[])new MsPimInvoiceRow[]{msPimInvoiceRow}), billWeight, billWeightRemark, Boolean.valueOf(false));
        List billVOList = this.matchMapper.toRecommendBillList(mtcSalesbillEntityList, billWeight, billWeightRemark);
        recommendBillsResult.setBillVOList(billVOList);
        recommendBillsResult.setTotal(Long.valueOf(billVOList.size()));
        return Response.success((Object)recommendBillsResult);
    }

    public Response<RecommendInvoicesResult> recommendInvoices(RecommendInvoicesRequest request) {
        logger.info("\u53d1\u7968\u63a8\u8350\u5165\u53c2recommendInvoices.RecommendInvoicesRequest:{}", (Object)request);
        MtcSalesbillEntity mtcSalesbillEntity = this.mtcSalesbillDao.selectByPrimaryKey(request.getBillId());
        if (Objects.isNull(mtcSalesbillEntity)) {
            logger.warn("recommendInvoices.mtcSalesbillEntity:{}", (Object)"\u4e1a\u52a1\u5355ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
            return Response.fail((String)"\u4e1a\u52a1\u5355ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!");
        }
        RecommendInvoicesResult recommendInvoicesResult = new RecommendInvoicesResult();
        MsPimInvoiceGetPageResponse msPimInvoiceGetPageResponse = this.dependService.getMsPimInvoiceGetPageResponse(request.getOrgIds(), mtcSalesbillEntity);
        if (Objects.isNull(msPimInvoiceGetPageResponse) || !msPimInvoiceGetPageResponse.getCode().equals(Response.RESULT_SUCESS)) {
            return Response.fail((String)(Objects.isNull(msPimInvoiceGetPageResponse) ? "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" : "\u53d1\u7968\u670d\u52a1\u8c03\u7528\u9519\u8bef!" + msPimInvoiceGetPageResponse.getMessage()));
        }
        if (msPimInvoiceGetPageResponse.getResult().isEmpty()) {
            return Response.fail((String)"\u53d1\u7968ID\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u65e0\u6548!", (Object)recommendInvoicesResult);
        }
        BigDecimal noMatchBillAmount = mtcSalesbillEntity.getAmountWithTax().subtract(mtcSalesbillEntity.getDiscountWithTaxTotal()).subtract(mtcSalesbillEntity.getAlreadyAmountWithTax());
        BigDecimal tolerance = this.dependService.getTolerance(mtcSalesbillEntity.getPurchaserId(), mtcSalesbillEntity.getPurchaserGroupId());
        List msPimInvoiceRowList = msPimInvoiceGetPageResponse.getResult();
        msPimInvoiceRowList = msPimInvoiceRowList.stream().filter(msPimInvoiceRow -> this.validateTolerance(noMatchBillAmount, new BigDecimal(msPimInvoiceRow.getAmountWithTax()).subtract(new BigDecimal(msPimInvoiceRow.getMatchAmount())), tolerance)).collect(Collectors.toList());
        msPimInvoiceRowList = this.validateService.validateMatchConditionRulesForRecommend(mtcSalesbillEntity.getPurchaserId(), mtcSalesbillEntity.getPurchaserGroupId(), msPimInvoiceRowList);
        if (CollectionUtils.isEmpty((Collection)msPimInvoiceRowList)) {
            recommendInvoicesResult.setTotal(MatchConstant.LONG_ZERO);
            return Response.success((Object)recommendInvoicesResult);
        }
        Map<Long, Integer> invoiceWeight = msPimInvoiceRowList.stream().collect(Collectors.toMap(item -> item.getId(), item -> 0));
        Map<Long, StringBuilder> invoiceWeightRemark = msPimInvoiceRowList.stream().collect(Collectors.toMap(item -> item.getId(), item -> new StringBuilder()));
        this.validateService.validateInvoiceCargoName((List)Lists.newArrayList((Object[])new MtcSalesbillEntity[]{mtcSalesbillEntity}), msPimInvoiceRowList, invoiceWeight, invoiceWeightRemark, Boolean.valueOf(true));
        List invoiceVOList = this.matchMapper.toRecommendInvoiceList(msPimInvoiceRowList, invoiceWeight, invoiceWeightRemark);
        recommendInvoicesResult.setInvoiceVOList(invoiceVOList);
        recommendInvoicesResult.setTotal(Long.valueOf(invoiceVOList.size()));
        return Response.success((Object)recommendInvoicesResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public Response confirmStatus(ConfirmStatusRequest request) {
        logger.info("\u786e\u8ba4\u5339\u914d\u5165\u53c2confirmStatus.ConfirmStatusRequest:{}", (Object)request);
        if (CommonUtils.isEmpty((List)request.getIds())) {
            return Response.fail((String)"\u786e\u8ba4\u5339\u914did\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap lockedMap = new HashMap();
        String lockBillAndInvoiceMsg = this.dependService.lockBillAndInvoice(request.getIds(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, lockedMap);
        if (StringUtils.isNotEmpty((CharSequence)lockBillAndInvoiceMsg)) {
            logger.warn("\u786e\u8ba4\u5339\u914d\u5165\u53c2confirmStatus.lockBillAndInvoiceMsg:{}", (Object)lockBillAndInvoiceMsg);
            return Response.fail((String)lockBillAndInvoiceMsg);
        }
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("response", "");
            resultMap.put("invoiceMatchList", "");
            this.transactionServiceInvoker.callNewTx(() -> {
                this.doConfirmStatus(request, resultMap);
                this.transactionalEventService.callNewAsyncTxAfterCommit(() -> {
                    String sendMsg = (String)resultMap.get("invoiceMatchList");
                    if (!CommonUtils.isEmpty((String)sendMsg)) {
                        logger.info("\u5f3a\u5236\u5339\u914d\u6216\u5df2\u5339\u914d\u53d1\u7968\u4e0b\u53d1\u96c6\u6210\uff0csendMsg:{}", (Object)sendMsg);
                        this.rabbitmqService.sendByTopicExchange("send.match.invoice.queue", (Object)sendMsg);
                    }
                });
            });
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)resultMap.get("response")))) {
                Response response = Response.fail((String)((String)resultMap.get("response")));
                return response;
            }
        }
        finally {
            this.dependService.unLockBillAndInvoice(lockedMap);
        }
        return Response.success(null);
    }

    public void doConfirmStatus(ConfirmStatusRequest data, Map<String, String> resultMap) {
        List mtcSalesbillInvoiceEntityList;
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        if (data.getOperateType().equals(ConfirmStatusTypeEnum.CONFIRM_STATUS_BY_RELATIONID.getValue())) {
            example.createCriteria().andIdIn(data.getIds()).andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue());
        }
        if (data.getOperateType().equals(ConfirmStatusTypeEnum.CONFIRM_STATUS_BY_BILLID.getValue())) {
            example.createCriteria().andSalesbillIdIn(data.getIds()).andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue());
        }
        if (data.getOperateType().equals(ConfirmStatusTypeEnum.CONFIRM_STATUS_BY_INVOICEID.getValue())) {
            example.createCriteria().andInvoiceIdIn(data.getIds()).andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)(mtcSalesbillInvoiceEntityList = this.mtcSalesbillInvoiceDao.selectByExample(example)))) {
            logger.error("\u672a\u627e\u5230\u5173\u8054\u5173\u7cfb\uff0c\u65e0\u6cd5\u786e\u8ba4\u5339\u914d\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)data));
            throw new RuntimeException("\u672a\u627e\u5230\u5173\u8054\u5173\u7cfb\uff0c\u65e0\u6cd5\u786e\u8ba4\u5339\u914d");
        }
        example = new MtcSalesbillInvoiceExample();
        example.createCriteria().andSalesbillIdIn(mtcSalesbillInvoiceEntityList.stream().map(r -> r.getSalesbillId()).collect(Collectors.toList())).andStatusEqualTo(NewMatchStatusEnum.OK.getValue());
        List mtcSalesbillInvoiceEntities = this.mtcSalesbillInvoiceDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)mtcSalesbillInvoiceEntityList)) {
            resultMap.put("response", "\u914d\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u5f85\u786e\u8ba4\u72b6\u6001!");
            return;
        }
        ArrayList<MsMatchBean> invoiceMatchList = new ArrayList<MsMatchBean>();
        Map<Long, DoubleSummaryStatistics> collectGroupByBillId = mtcSalesbillInvoiceEntityList.stream().collect(Collectors.groupingBy(MtcSalesbillInvoiceEntity::getSalesbillId, Collectors.summarizingDouble(e -> e.getMatchAmount().doubleValue())));
        Map<Object, Object> collectMatchedGroupByBillId = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)mtcSalesbillInvoiceEntities)) {
            collectMatchedGroupByBillId = mtcSalesbillInvoiceEntities.stream().collect(Collectors.groupingBy(MtcSalesbillInvoiceEntity::getSalesbillId, Collectors.summarizingDouble(e -> e.getMatchAmount().doubleValue())));
        }
        for (MtcSalesbillInvoiceEntity mtcSalesbillInvoiceEntity : mtcSalesbillInvoiceEntityList) {
            MsPimInvoiceRow msPimInvoiceRow = this.dependService.getMsPimInvoiceRowById(mtcSalesbillInvoiceEntity.getInvoiceId());
            MtcSalesbillEntity mtcSalesbillEntity = this.mtcSalesbillDao.selectByPrimaryKey(mtcSalesbillInvoiceEntity.getSalesbillId());
            MtcSalesbillEntity record = new MtcSalesbillEntity();
            record.setSalesbillId(mtcSalesbillInvoiceEntity.getSalesbillId());
            BigDecimal alreadyMatchedAmountWithTax = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)mtcSalesbillInvoiceEntities)) {
                alreadyMatchedAmountWithTax = new BigDecimal(((DoubleSummaryStatistics)collectMatchedGroupByBillId.get(mtcSalesbillInvoiceEntity.getSalesbillId())).getSum());
            }
            BigDecimal tolerance = this.dependService.getTolerance(mtcSalesbillInvoiceEntity.getPurchaserId(), mtcSalesbillInvoiceEntity.getPurchaserGroupId());
            if (this.validateTolerance(new BigDecimal(collectGroupByBillId.get(mtcSalesbillInvoiceEntity.getSalesbillId()).getSum()), mtcSalesbillEntity.getAmountWithTax().subtract(alreadyMatchedAmountWithTax), tolerance).booleanValue()) {
                record.setMatchStatus(MatchStatusEnum.MATCH_END.getValue().toString());
            } else {
                MtcSalesbillInvoiceExample mtcSalesbillInvoiceExample = new MtcSalesbillInvoiceExample();
                mtcSalesbillInvoiceExample.createCriteria().andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue()).andSalesbillIdEqualTo(mtcSalesbillInvoiceEntity.getSalesbillId()).andIdNotEqualTo(mtcSalesbillInvoiceEntity.getId());
                List mtcSalesbillInvoiceEntityListTmp = this.mtcSalesbillInvoiceDao.selectByExample(mtcSalesbillInvoiceExample);
                if (Objects.isNull(mtcSalesbillInvoiceEntityListTmp) || mtcSalesbillInvoiceEntityListTmp.isEmpty()) {
                    record.setMatchStatus(MatchStatusEnum.MATCH_ING.getValue().toString());
                } else {
                    record.setMatchStatus(MatchStatusEnum.MATCH_CONFIRM.getValue().toString());
                }
            }
            this.mtcSalesbillDao.updateByPrimaryKeySelective(record);
            this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.CONFIRM_MATCH.getValue().intValue(), mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), record.toString(), "\u3010\u786e\u8ba4\u914d\u5355\u3011\u66f4\u65b0\u5355\u636e\u72b6\u6001", data.getSysUserId(), data.getSysUserName());
            mtcSalesbillInvoiceEntity.setUpdateTime(new Date());
            mtcSalesbillInvoiceEntity.setUpdateUser(data.getSysUserId());
            mtcSalesbillInvoiceEntity.setStatus(NewMatchStatusEnum.OK.getValue());
            this.mtcSalesbillInvoiceDao.updateByPrimaryKeySelective(mtcSalesbillInvoiceEntity);
            this.matchOperateLogService.insertOperateLog(MatchLogTypeEnum.CONFIRM_MATCH.getValue().intValue(), mtcSalesbillInvoiceEntity.getSalesbillId(), mtcSalesbillInvoiceEntity.getSalesbillNo(), mtcSalesbillInvoiceEntity.toString(), "\u3010\u786e\u8ba4\u914d\u5355\u3011\u66f4\u65b0\u5339\u914d\u5173\u7cfb\u72b6\u6001", data.getSysUserId(), data.getSysUserName());
            MsMatchBean msMatchBean = new MsMatchBean();
            MtcSalesbillInvoiceExample invoiceExample = new MtcSalesbillInvoiceExample();
            invoiceExample.createCriteria().andStatusEqualTo(NewMatchStatusEnum.UNCONFIRMED.getValue()).andSalesbillIdNotEqualTo(mtcSalesbillInvoiceEntity.getSalesbillId()).andInvoiceIdEqualTo(mtcSalesbillInvoiceEntity.getInvoiceId());
            if (0L < this.mtcSalesbillInvoiceDao.countByExample(invoiceExample)) {
                msMatchBean.setAbleConfirm(Boolean.TRUE);
            } else {
                msMatchBean.setAbleConfirm(Boolean.FALSE);
            }
            msMatchBean.setBussinessId(mtcSalesbillInvoiceEntity.getSalesbillId());
            msMatchBean.setBussinessNo(mtcSalesbillInvoiceEntity.getSalesbillNo());
            msMatchBean.setInvoiceId(mtcSalesbillInvoiceEntity.getInvoiceId());
            msMatchBean.setMatchAmount(BigDecimal.ZERO.toString());
            msMatchBean.setMatchType(Integer.valueOf(NewMatchTypeEnum.HAND_MATCH.getValue()));
            msMatchBean.setSalesbillType(mtcSalesbillEntity.getSalesbillType());
            msMatchBean.setCooperateFlag(Boolean.valueOf(mtcSalesbillEntity.getCooperateFlag() == 1));
            invoiceMatchList.add(msMatchBean);
        }
        this.dependService.doBatchUpdateMatchStatus(invoiceMatchList);
        resultMap.put("invoiceMatchList", JsonUtils.writeObjectToJson(invoiceMatchList));
    }

    public Response<GetInvoiceDetailResult> getInvoiceDetail(Long invoiceId) {
        logger.info("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5165\u53c2\u53d1\u7968id:{}", (Object)invoiceId);
        List msPimInvoiceDetailRowById = this.dependService.getMsPimInvoiceDetailRowById(invoiceId);
        GetInvoiceDetailResult getInvoiceDetailResult = new GetInvoiceDetailResult();
        ArrayList invoiceDetailRowDTOList = new ArrayList();
        msPimInvoiceDetailRowById.stream().forEach(detail -> {
            InvoiceDetailRowDTO dto = new InvoiceDetailRowDTO();
            BeanUtils.copyProperties((Object)detail, (Object)dto);
            invoiceDetailRowDTOList.add(dto);
        });
        getInvoiceDetailResult.setTotal(Long.valueOf(msPimInvoiceDetailRowById.size()));
        getInvoiceDetailResult.setInvoiceDetailRowDTOList(invoiceDetailRowDTOList);
        return Response.success((Object)getInvoiceDetailResult);
    }

    public Response<SearchMatchResult> searchMatchByBillId(SearchMatchRequest request) {
        logger.info("\u3010\u6839\u636e\u4e1a\u52a1\u5355\u67e5\u8be2\u5df2\u5339\u914d\u53d1\u7968\u3011\u5165\u53c2searchMatchByBill.SearchMatchRequest:{}", (Object)request);
        request.setPageNo(null);
        request.setPageSize(null);
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        MtcSalesbillInvoiceExample.Criteria criteria = example.createCriteria();
        String validateSearchMatchMsg = this.validateService.validateSearchMatch(request, example, criteria);
        if (!StringUtils.isBlank((CharSequence)validateSearchMatchMsg)) {
            logger.warn("searchMatchByBill.validateSearchMatchMsg:{}", (Object)validateSearchMatchMsg);
            return Response.fail((String)validateSearchMatchMsg);
        }
        if (CollectionUtils.isEmpty((Collection)request.getIds())) {
            return Response.fail((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        criteria.andSalesbillIdIn(request.getIds());
        List invoiceEntities = this.mtcSalesbillInvoiceDao.selectByExample(example);
        List matchRelationVO = this.matchMapper.toMatchRelationVo(invoiceEntities, invoiceId -> this.dependService.getMsPimInvoiceDetailRowByIds(invoiceId, request.getItemMatchStatus(), request.getDetailPageNum(), request.getDetailPageSize()));
        SearchMatchResult newSearchMatchByBillResult = new SearchMatchResult();
        newSearchMatchByBillResult.setMatchRelationList(matchRelationVO);
        newSearchMatchByBillResult.setTotal(Long.valueOf(this.mtcSalesbillInvoiceDao.countByExample(example)));
        return Response.success((Object)newSearchMatchByBillResult);
    }

    public Response<SearchMatchResult> searchMatchByInvoiceId(SearchMatchRequest request) {
        logger.info("\u5f85\u786e\u8ba4\u67e5\u8be2\u5df2\u5339\u914d\u4e1a\u52a1\u5355\uff0c\u5165\u53c2searchMatchByInvoice.SearchMatchRequest:{}", (Object)request);
        request.setPageNo(null);
        request.setPageSize(null);
        MtcSalesbillInvoiceExample example = new MtcSalesbillInvoiceExample();
        MtcSalesbillInvoiceExample.Criteria criteria = example.createCriteria();
        SearchMatchResult newSearchMatchByBillResult = new SearchMatchResult();
        String validateSearchMatchMsg = this.validateService.validateSearchMatch(request, example, criteria);
        if (!StringUtils.isBlank((CharSequence)validateSearchMatchMsg)) {
            logger.warn("searchMatchByInvoice.validateSearchMatchMsg:{}", (Object)validateSearchMatchMsg);
            return Response.fail((String)validateSearchMatchMsg);
        }
        if (CollectionUtils.isEmpty((Collection)request.getIds())) {
            return Response.fail((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        criteria.andInvoiceIdIn(request.getIds());
        List invoiceEntities = this.mtcSalesbillInvoiceDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)invoiceEntities)) {
            newSearchMatchByBillResult.setMatchRelationList((List)Lists.newArrayList());
            newSearchMatchByBillResult.setTotal(Long.valueOf(0L));
            return Response.success((Object)newSearchMatchByBillResult);
        }
        Map<Long, MtcSalesbillInvoiceEntity> invoiceBillIdKeyMap = invoiceEntities.stream().collect(Collectors.toMap(MtcSalesbillInvoiceEntity::getSalesbillId, m -> m));
        MtcSalesbillExample salesbillExample = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria billCriteria = salesbillExample.createCriteria();
        billCriteria.andSalesbillIdIn((List)Lists.newArrayList(invoiceBillIdKeyMap.keySet()));
        List billEntities = this.mtcSalesbillDao.selectByExample(salesbillExample);
        Integer matchTotal = this.salesbillItemService.countByExample((Long)request.getIds().get(0));
        List billItemEntities = this.salesbillItemService.getBillDetailRowByIds((List)Lists.newArrayList(invoiceBillIdKeyMap.keySet()), request.getItemMatchStatus(), request.getDetailPageNum(), request.getDetailPageSize());
        Map<Long, List<MtcSalesbillItemEntity>> billItemBillIdKeyMap = billItemEntities.stream().collect(Collectors.groupingBy(MtcSalesbillItemEntity::getSalesbillId));
        List result = this.matchMapper.toMatchRelationVo(billEntities, invoiceBillIdKeyMap, billItemBillIdKeyMap, billId -> this.salesbillItemService.countByExample(billId), billId -> this.salesbillItemService.countByExample(billId, "1"));
        newSearchMatchByBillResult.setMatchRelationList(result);
        newSearchMatchByBillResult.setTotal(Long.valueOf(this.mtcSalesbillInvoiceDao.countByExample(example)));
        return Response.success((Object)newSearchMatchByBillResult);
    }
}

