/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.service.OutInvoiceMatchService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutInvoiceMatchServiceImpl
implements OutInvoiceMatchService {
    private static final Logger logger = LoggerFactory.getLogger(OutInvoiceMatchServiceImpl.class);
    @Autowired
    MtcSalesbillDao mtcSalesbillDao;

    public MtcSalesbillEntity getSalesbillByNoAndPurchaserId(String salesBillNo, Long purchaserId) {
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoEqualTo(salesBillNo);
        criteria.andStatusEqualTo(Integer.valueOf(1));
        if (null != purchaserId) {
            criteria.andPurchaserIdEqualTo(purchaserId);
        }
        return this.mtcSalesbillDao.selectOneByExample(example);
    }

    public int updateSalesBillAmountAndMatchStatus(MtcSalesbillEntity mtcSalesbillEntity, String matchType, BigDecimal sumAmountWithTax, BigDecimal sumAmountWithoutTax, BigDecimal sumTaxAmount, boolean isMatchSuccess, Long sysUserId) {
        if ("1".equals(matchType)) {
            mtcSalesbillEntity.setAlreadyAmountWithTax(mtcSalesbillEntity.getAlreadyAmountWithTax().add(sumAmountWithTax));
            mtcSalesbillEntity.setAlreadyAmountWithoutTax(mtcSalesbillEntity.getAlreadyAmountWithoutTax().add(sumAmountWithoutTax));
            mtcSalesbillEntity.setAlreadyTaxAmount(mtcSalesbillEntity.getAlreadyTaxAmount().add(sumTaxAmount));
        } else if (0 != mtcSalesbillEntity.getAlreadyAmountWithTax().compareTo(BigDecimal.ZERO)) {
            mtcSalesbillEntity.setAlreadyAmountWithTax(mtcSalesbillEntity.getAlreadyAmountWithTax().subtract(sumAmountWithTax));
            mtcSalesbillEntity.setAlreadyAmountWithoutTax(mtcSalesbillEntity.getAlreadyAmountWithoutTax().subtract(sumAmountWithoutTax));
            mtcSalesbillEntity.setAlreadyTaxAmount(mtcSalesbillEntity.getAlreadyTaxAmount().subtract(sumTaxAmount));
        }
        if (isMatchSuccess) {
            mtcSalesbillEntity.setMatchStatus("2");
            mtcSalesbillEntity.setMatchRemark("\u5df2\u5339\u914d\u5b8c\u6210");
        } else {
            mtcSalesbillEntity.setMatchStatus("0");
            mtcSalesbillEntity.setMatchRemark("\u672a\u5339\u914d\u5b8c\u6210");
            mtcSalesbillEntity.setSendStatus(Integer.valueOf(0));
        }
        mtcSalesbillEntity.setUpdateUser(sysUserId);
        return this.mtcSalesbillDao.updateByPrimaryKeySelective(mtcSalesbillEntity);
    }
}

