/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillItemListRequest;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillItemListResponse;
import com.xforceplus.phoenix.match.client.model.MsPage;
import com.xforceplus.phoenix.match.client.model.MsSalesbillItemResult;
import com.xforceplus.phoenix.match.common.enums.StatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.SalesBillEntityMapper;
import com.xforceplus.phoenix.match.common.utils.CommonTools;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemExample;
import com.xforceplus.phoenix.match.service.SalesbillItemService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SalesbillItemServiceImpl
implements SalesbillItemService {
    @Autowired
    private MtcSalesbillItemDao salesbillItemDao;
    @Autowired
    private SalesBillEntityMapper salesBillEntityMapper;

    public MsGetSalesbillItemListResponse getSalesbillItemList(MsGetSalesbillItemListRequest request) {
        MsGetSalesbillItemListResponse response = new MsGetSalesbillItemListResponse();
        String check = CommonTools.checkPage((MsPage)request);
        if (check != null) {
            response.setCode(Integer.valueOf(0));
            response.setMessage(check);
            return response;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSortField()) && Arrays.stream(MtcSalesbillItemEntity.class.getDeclaredFields()).noneMatch(field -> field.getName().equals(request.getSortField()))) {
            response.setCode(Integer.valueOf(0));
            response.setMessage("\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728");
            return response;
        }
        if (CollectionUtils.isEmpty((Collection)request.getSalesbillIds()) && StringUtils.isBlank((CharSequence)request.getSalesbillNo())) {
            response.setCode(Integer.valueOf(0));
            response.setMessage("\u4e1a\u52a1\u5355id\u6216\u8005\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        MsSalesbillItemResult result = new MsSalesbillItemResult();
        List billItemList = this.getBillItemList(request);
        result.setList(this.salesBillEntityMapper.mapList(billItemList));
        result.setMatchErrTotal(this.countByExample((Long)request.getSalesbillIds().get(0), "1"));
        result.setTotal(Long.valueOf(this.salesbillItemDao.countByExample(this.getMtcSalesbillItemExample(request))));
        response.setCode(Integer.valueOf(1));
        response.setResult(result);
        return response;
    }

    private List<MtcSalesbillItemEntity> getBillItemList(MsGetSalesbillItemListRequest request) {
        MtcSalesbillItemExample example = this.getMtcSalesbillItemExample(request);
        if (Objects.nonNull(request.getPageSize()) && Objects.nonNull(request.getPageSize())) {
            example.setLimit(request.getPageSize());
            example.setOffset(Integer.valueOf((request.getPageNo() - 1) * request.getPageSize()));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSortField())) {
            example.setOrderByClause(CommonTools.cameName((String)request.getSortField()) + " " + request.getSortOrder());
        }
        return this.salesbillItemDao.selectByExample(example);
    }

    private MtcSalesbillItemExample getMtcSalesbillItemExample(MsGetSalesbillItemListRequest request) {
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        MtcSalesbillItemExample.Criteria criteria = example.createCriteria();
        criteria.andStatusNotEqualTo(StatusEnum.DELETED.code());
        if (CollectionUtils.isNotEmpty((Collection)request.getSalesbillIds())) {
            if (request.getSalesbillIds().size() == 1) {
                criteria.andSalesbillIdEqualTo((Long)request.getSalesbillIds().get(0));
            } else {
                criteria.andSalesbillIdIn(request.getSalesbillIds());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getItemMatchStatus())) {
            if ("0".equals(request.getItemMatchStatus())) {
                criteria.andItemMatchStatusIn(Arrays.asList("0", "1"));
            } else if ("1".equals(request.getItemMatchStatus())) {
                criteria.andItemMatchStatusNotIn(Arrays.asList("0", "1"));
            }
        }
        return example;
    }

    public List<MtcSalesbillItemEntity> getBillDetailRowByIds(List<Long> billIds, String itemMatchStatus, Integer page, Integer size) {
        ArrayList list = Lists.newArrayList();
        for (Long id : billIds) {
            MsGetSalesbillItemListRequest request = new MsGetSalesbillItemListRequest();
            request.setSalesbillIds((List)Lists.newArrayList((Object[])new Long[]{id}));
            request.setItemMatchStatus(itemMatchStatus);
            request.setPageNo(page);
            request.setPageSize(size);
            List billItemList = this.getBillItemList(request);
            list.addAll(billItemList);
        }
        return list;
    }

    public Integer countByExample(Long billId, String itemMatchStatus) {
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        MtcSalesbillItemExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillIdEqualTo(billId);
        if (StringUtils.isNotBlank((CharSequence)itemMatchStatus) && StringUtils.isNotBlank((CharSequence)itemMatchStatus)) {
            if ("0".equals(itemMatchStatus)) {
                criteria.andItemMatchStatusIn(Arrays.asList("0", "1"));
            } else if ("1".equals(itemMatchStatus)) {
                criteria.andItemMatchStatusNotIn(Arrays.asList("0", "1"));
            }
        }
        long count = this.salesbillItemDao.countByExample(example);
        return (int)count;
    }

    public Integer countByExample(Long billId) {
        return this.countByExample(billId, null);
    }
}

