/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import cn.hutool.json.JSONUtil;
import com.google.api.client.util.Lists;
import com.google.common.collect.ImmutableMap;
import com.xforceplus.ant.coop.client.model.MsInvoiceBlockadeRequest;
import com.xforceplus.ant.coop.client.model.MsInvoiceBlockadeResponse;
import com.xforceplus.phoenix.match.bean.PushMatchInfoBean;
import com.xforceplus.phoenix.match.client.InvoiceBlockadeClient;
import com.xforceplus.phoenix.match.client.model.MatchCriteria;
import com.xforceplus.phoenix.match.client.model.MsCountSalesbillRequest;
import com.xforceplus.phoenix.match.client.model.MsExportMatchRequest;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillChargeUpStatusRequest;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillListRequest;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillListResponse;
import com.xforceplus.phoenix.match.client.model.MsGetSalesbillRequest;
import com.xforceplus.phoenix.match.client.model.MsOperateSalesbillRequest;
import com.xforceplus.phoenix.match.client.model.MsPage;
import com.xforceplus.phoenix.match.client.model.MsResendSalesBillRequest;
import com.xforceplus.phoenix.match.client.model.MsResponse;
import com.xforceplus.phoenix.match.client.model.MsSalesbillResult;
import com.xforceplus.phoenix.match.client.model.MsUpdateSalesbillChargeUpStatusRequest;
import com.xforceplus.phoenix.match.client.model.MsUpdateSalesbillItemRequest;
import com.xforceplus.phoenix.match.common.enums.CooperateFlagEnum;
import com.xforceplus.phoenix.match.common.enums.MatchExportEnum;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.NewMatchMapper;
import com.xforceplus.phoenix.match.common.utils.CommonTools;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.daoext.MtcSalesbillDaoExt;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.MatchOperateLogService;
import com.xforceplus.phoenix.match.service.SalesbillService;
import com.xforceplus.phoenix.match.service.impl.CommonServiceImpl;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import com.xforceplus.phoenix.tools.enums.ChargeUpStatusEnum;
import com.xforceplus.phoenix.tools.transaction.TransactionalEventService;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplatframework.model.MSResponse;
import com.xforceplus.xplatframework.model.Response;
import io.vavr.Lazy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalesbillServiceImpl
implements SalesbillService {
    private static final Logger log = LoggerFactory.getLogger(SalesbillServiceImpl.class);
    @Autowired
    private MtcSalesbillDao salesbillDao;
    @Autowired
    private MtcSalesbillDaoExt salesbillDaoExt;
    @Autowired
    private MatchOperateLogService matchOperateLogService;
    @Autowired
    private DependService dependService;
    @Value(value="${match.export.num:1000}")
    Integer matchExportNum;
    @Autowired
    SqsService sqsService;
    @Autowired
    private CommonServiceImpl commonService;
    @Autowired
    private InvoiceBlockadeClient blockadeClient;
    @Autowired
    private TransactionalEventService transactionalEventService;
    @Autowired
    private NewMatchMapper newMatchMapper;
    private static final Lazy<Map<String, Map<String, BiConsumer<List<String>, MtcSalesbillExample.Criteria>>>> mtcSalesbillExampleMap = Lazy.of(() -> {
        HashMap<String, ImmutableMap> map = new HashMap<String, ImmutableMap>();
        map.put("salesbillNo", ImmutableMap.builder().put((Object)"in", (list, criteria) -> criteria.andSalesbillNoIn(list)).build());
        map.put("purchaserGroupId", ImmutableMap.builder().put((Object)"eq", (list, criteria) -> criteria.andPurchaserGroupIdEqualTo(Long.valueOf(Long.parseLong((String)list.get(0))))).build());
        map.put("sysOrgId", ImmutableMap.builder().put((Object)"in", (list, criteria) -> criteria.andSysOrgIdIn(list.stream().map(Long::parseLong).collect(Collectors.toList()))).build());
        return map;
    });

    public MsResponse countSalesbill(MsCountSalesbillRequest request) {
        MsResponse response = new MsResponse();
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andPurchaserGroupIdEqualTo(request.getGroupId());
        criteria.andSysOrgIdIn(request.getOrgIds());
        if (StringUtils.isNotBlank((CharSequence)request.getMatchStatus())) {
            criteria.andMatchStatusEqualTo(request.getMatchStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSellerName())) {
            criteria.andSellerNameLike("%" + request.getSellerName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPurchaserName())) {
            criteria.andPurchaserNameEqualTo(request.getPurchaserName());
        }
        if (request.getCooperateFlag() != null) {
            criteria.andCooperateFlagEqualTo(request.getCooperateFlag());
        }
        if (CommonUtils.isEmpty((List)request.getKeyword())) {
            request.setKeyword(null);
        }
        Long salesbillCount = CollectionUtils.isEmpty((Collection)request.getItemKeyword()) ? this.salesbillDaoExt.countByExample(example, request.getKeyword()) : this.salesbillDaoExt.countByExampleJoinItem(example, request.getKeyword(), request.getItemKeyword());
        response.code(Integer.valueOf(1)).message("\u6210\u529f").result((Object)salesbillCount);
        return response;
    }

    public MsGetSalesbillListResponse getSalesbillList(MsGetSalesbillListRequest request) {
        long count;
        List salesbillEntities;
        MsGetSalesbillListResponse response = new MsGetSalesbillListResponse();
        String check = CommonTools.checkPage((MsPage)request);
        if (check != null) {
            return response.code(Integer.valueOf(0)).message(check);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSortField()) && Arrays.stream(MtcSalesbillEntity.class.getDeclaredFields()).noneMatch(field -> field.getName().equals(request.getSortField()))) {
            return response.code(Integer.valueOf(0)).message("\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andPurchaserGroupIdEqualTo(request.getGroupId()).andSysOrgIdIn(request.getOrgIds());
        if (StringUtils.isNotBlank((CharSequence)request.getMatchStatus())) {
            criteria.andMatchStatusEqualTo(request.getMatchStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getChargeUpNo())) {
            criteria.andChargeUpNoEqualTo(request.getChargeUpNo());
        }
        if (request.getChargeUpStatus() != null) {
            criteria.andChargeUpStatusEqualTo(request.getChargeUpStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSellerName())) {
            criteria.andSellerNameLike("%" + request.getSellerName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPurchaserName())) {
            criteria.andPurchaserNameEqualTo(request.getPurchaserName());
        }
        if (request.getCooperateFlag() != null) {
            criteria.andCooperateFlagEqualTo(request.getCooperateFlag());
        }
        if (CollectionUtils.isEmpty((Collection)request.getKeyword())) {
            request.setKeyword(null);
        }
        example.setLimit(request.getPageSize());
        example.setOffset(Integer.valueOf((request.getPageNo() - 1) * request.getPageSize()));
        if (StringUtils.isNotBlank((CharSequence)request.getSortField())) {
            example.setOrderByClause(CommonTools.cameName((String)request.getSortField()) + " " + request.getSortOrder());
        }
        MsSalesbillResult result = new MsSalesbillResult();
        if (CollectionUtils.isNotEmpty((Collection)request.getItemKeyword())) {
            salesbillEntities = this.salesbillDaoExt.selectByExampleJoinItem(example, request.getKeyword(), request.getItemKeyword());
            count = this.salesbillDaoExt.countByExampleJoinItem(example, request.getKeyword(), request.getItemKeyword());
        } else {
            salesbillEntities = this.salesbillDaoExt.selectByExample(example, request.getKeyword());
            count = this.salesbillDaoExt.countByExample(example, request.getKeyword());
        }
        List msMtcSalesbillDTOS = this.newMatchMapper.toMsMtcSalesbillDTOs(salesbillEntities);
        result.setList(msMtcSalesbillDTOS);
        result.setTotal(Long.valueOf(count));
        response.setCode(Response.OK);
        response.setResult(result);
        return response;
    }

    public MsResponse operateSalesbill(MsOperateSalesbillRequest request) {
        MsResponse response = new MsResponse();
        MtcSalesbillEntity entity = new MtcSalesbillEntity();
        CommonTools.copyProperties((Object)request.getInfo(), (Object)entity);
        this.salesbillDao.insertSelective(entity);
        if (entity.getSalesbillId() == null || entity.getSalesbillId() == 0L) {
            this.salesbillDao.insertSelective(entity);
        } else {
            MtcSalesbillExample example = new MtcSalesbillExample();
            MtcSalesbillExample.Criteria criteria = example.createCriteria();
            this.salesbillDao.updateByExample(entity, example);
        }
        response.setCode(Response.OK);
        response.setResult((Object)entity.getSellerId());
        return response;
    }

    public List<MtcSalesbillEntity> getMatchSalesbillList(String salesbillNo, String matchStatus, int sendStatus) {
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andStatusEqualTo(Integer.valueOf(1));
        criteria.andMatchStatusEqualTo(matchStatus);
        criteria.andSendStatusEqualTo(Integer.valueOf(sendStatus));
        if (!CommonTools.isEmpty((String)salesbillNo)) {
            criteria.andSalesbillNoEqualTo(salesbillNo);
        }
        example.setOrderByClause("create_time desc");
        example.setOffset(Integer.valueOf(0));
        example.setLimit(Integer.valueOf(100));
        return this.salesbillDao.selectByExample(example);
    }

    @Transactional
    public MsResponse updateSalesbillChargeUpStatus(MsUpdateSalesbillChargeUpStatusRequest request) {
        MsResponse msResponse = new MsResponse();
        MtcSalesbillExample example = new MtcSalesbillExample();
        example.createCriteria().andSalesbillNoEqualTo(request.getSalesBillNo()).andStatusEqualTo(Integer.valueOf(1)).andPurchaserGroupIdEqualTo(request.getGroupId());
        try {
            MtcSalesbillEntity mtcSalesbillEntity = this.salesbillDao.selectOneByExample(example);
            if (mtcSalesbillEntity == null) {
                return msResponse.code(Integer.valueOf(0)).message("\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u4e1a\u52a1\u5355");
            }
            MtcSalesbillEntity entity = new MtcSalesbillEntity();
            entity.setSalesbillId(mtcSalesbillEntity.getSalesbillId());
            entity.setChargeUpStatus(request.getChargeUpStatus());
            entity.setChargeUpNo(request.getChargeUpNo());
            entity.setChargeUpRemark(request.getChargeUpRemark());
            if (this.salesbillDao.updateByPrimaryKeySelective(entity) > 0) {
                msResponse.code(Integer.valueOf(1)).message("\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u6210\u529f").result((Object)mtcSalesbillEntity.getChargeUpStatus());
                this.matchOperateLogService.insertOperateLog(3, mtcSalesbillEntity.getSalesbillId(), mtcSalesbillEntity.getSalesbillNo(), "\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u6210\u529f", "\u6210\u529f", Long.valueOf(0L), "\u7cfb\u7edf");
                this.transactionalEventService.callNewAsyncTxAfterCommit(() -> {
                    if (ChargeUpStatusEnum.CHARGE.value().equals(request.getChargeUpStatus()) && CooperateFlagEnum.COOPERATE.getCode().equals(mtcSalesbillEntity.getCooperateFlag())) {
                        this.blockadeInvoiceBySalesbillNo(mtcSalesbillEntity.getPurchaserGroupId(), mtcSalesbillEntity.getSalesbillNo());
                    }
                });
            } else {
                msResponse.code(Integer.valueOf(0)).message("\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u5931\u8d25");
                this.matchOperateLogService.insertOperateLog(3, Long.valueOf(0L), request.getSalesBillNo(), "\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u5931\u8d25\uff0cgroupId=" + request.getGroupId(), "\u5931\u8d25", Long.valueOf(0L), "\u7cfb\u7edf");
            }
        }
        catch (Exception e) {
            msResponse.code(Integer.valueOf(0)).message("\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u5f02\u5e38");
            this.matchOperateLogService.insertOperateLog(3, Long.valueOf(0L), request.getSalesBillNo(), "\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u5f02\u5e38\uff0cgroupId=" + request.getGroupId(), "\u5f02\u5e38", Long.valueOf(0L), "\u7cfb\u7edf");
        }
        return msResponse;
    }

    public void blockadeInvoiceBySalesbillNo(Long groupId, String salesbillNo) {
        MsInvoiceBlockadeRequest blockadeRequest = new MsInvoiceBlockadeRequest();
        blockadeRequest.setOpTenantId(groupId);
        blockadeRequest.setSettlementNo(salesbillNo);
        blockadeRequest.setStatus(Integer.valueOf(2));
        blockadeRequest.setOpUserName("\u8fdb\u9879\u5e73\u53f0");
        log.info("\u8c03\u7528\u534f\u540c\u4ea7\u7ebf\u89e6\u53d1\u9501\u7968\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)blockadeRequest));
        MsInvoiceBlockadeResponse msInvoiceBlockadeResponse = this.blockadeClient.invoiceBlockade(blockadeRequest);
        log.info("\u8c03\u7528\u534f\u540c\u4ea7\u7ebf\u89e6\u53d1\u9501\u7968\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)msInvoiceBlockadeResponse));
    }

    public MsResponse getSalesbillChargeUpStatus(MsGetSalesbillChargeUpStatusRequest request) {
        MsResponse msResponse = new MsResponse();
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoEqualTo(request.getSalesBillNo());
        criteria.andStatusEqualTo(Integer.valueOf(1));
        if (null != request.getPurchaserCompanyId()) {
            criteria.andPurchaserIdEqualTo(request.getPurchaserCompanyId());
        }
        try {
            MtcSalesbillEntity entity = this.salesbillDao.selectOneByExample(example);
            if (null != entity) {
                msResponse.code(Integer.valueOf(1)).message("\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u6210\u529f").result((Object)entity.getChargeUpStatus());
                this.matchOperateLogService.insertOperateLog(3, entity.getSalesbillId(), entity.getSalesbillNo(), "\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u6210\u529f", "\u6210\u529f", Long.valueOf(0L), "\u7cfb\u7edf");
            } else {
                msResponse.code(Integer.valueOf(0)).message("\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u5931\u8d25");
                this.matchOperateLogService.insertOperateLog(3, Long.valueOf(0L), request.getSalesBillNo(), "\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u5931\u8d25\uff0ccompanyId=" + request.getPurchaserCompanyId(), "\u5931\u8d25", Long.valueOf(0L), "\u7cfb\u7edf");
            }
        }
        catch (Exception e) {
            msResponse.code(Integer.valueOf(0)).message("\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u5f02\u5e38");
            this.matchOperateLogService.insertOperateLog(3, Long.valueOf(0L), request.getSalesBillNo(), "\u83b7\u53d6\u8bb0\u8d26\u72b6\u6001\u5f02\u5e38\uff0ccompanyId=" + request.getPurchaserCompanyId(), "\u5f02\u5e38", Long.valueOf(0L), "\u7cfb\u7edf");
        }
        return msResponse;
    }

    public MsResponse updateSalesbillItem(MsUpdateSalesbillItemRequest request) {
        MsResponse msResponse = new MsResponse();
        MtcSalesbillExample example = new MtcSalesbillExample();
        example.createCriteria().andSalesbillNoEqualTo(request.getSalesbillNo()).andStatusEqualTo(Integer.valueOf(1)).andPurchaserGroupIdEqualTo(request.getPurchaserGroupId());
        MtcSalesbillEntity mtcSalesbillEntity = new MtcSalesbillEntity();
        CommonTools.copyProperties((Object)request, (Object)mtcSalesbillEntity);
        try {
            if (this.salesbillDao.updateByExampleSelective(mtcSalesbillEntity, example) > 0) {
                msResponse.code(Integer.valueOf(1)).message("\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (Exception e) {
            msResponse.code(Integer.valueOf(0)).message("\u66f4\u65b0\u4e1a\u52a1\u5355\u5f02\u5e38");
            this.matchOperateLogService.insertOperateLog(3, Long.valueOf(0L), request.getSalesbillNo(), "\u66f4\u65b0\u4e1a\u52a1\u5355\u5f02\u5e38\uff0cgroupId=" + request.getPurchaserGroupId(), "\u5f02\u5e38", Long.valueOf(0L), "\u7cfb\u7edf");
        }
        return msResponse;
    }

    public MsResponse getSalesbillByGroupId(MsGetSalesbillRequest request) {
        MsResponse response = new MsResponse();
        if (CommonTools.isEmpty((String)request.getSalesBillNo())) {
            return response.code(Response.Fail).message("\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        criteria.andSalesbillNoEqualTo(request.getSalesBillNo());
        criteria.andStatusEqualTo(Integer.valueOf(1));
        criteria.andPurchaserGroupIdEqualTo(request.getPurchaserGroupId());
        MtcSalesbillEntity entity = this.salesbillDao.selectOneByExample(example);
        if (entity == null) {
            return response.code(Response.Fail).message("\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u4e1a\u52a1\u5355.");
        }
        return response.code(Response.OK).message("\u6210\u529f").result((Object)entity);
    }

    public MsResponse exportMatch(MsExportMatchRequest request) {
        MsResponse response = new MsResponse();
        List mtcSalesbillEntityList = new ArrayList();
        List msPimInvoiceRowList = new ArrayList();
        List relation = new ArrayList();
        Integer tabStatus = request.getTabStatus();
        if (MatchExportEnum.BILL_NOT_MATCH.code() <= tabStatus && MatchExportEnum.BILL_END_MATCH.code() >= tabStatus) {
            List relationInvoiceIds;
            mtcSalesbillEntityList = CollectionUtils.isNotEmpty((Collection)request.getSalesbillIds()) ? this.dependService.getExportBillById(request.getSalesbillIds()) : this.dependService.getExportBillByCondition(request);
            if (mtcSalesbillEntityList.size() > this.matchExportNum) {
                return response.code(MSResponse.Fail).message("\u5bfc\u51fa\u6761\u6570\u4e0d\u80fd\u8d85\u8fc7" + this.matchExportNum + "\u6761\uff01");
            }
            if (!MatchExportEnum.BILL_NOT_MATCH.code().equals(tabStatus) && CollectionUtils.isNotEmpty(relationInvoiceIds = (relation = this.dependService.getRelation(null, mtcSalesbillEntityList.stream().map(MtcSalesbillEntity::getSalesbillId).collect(Collectors.toList()))).stream().map(MtcSalesbillInvoiceEntity::getInvoiceId).distinct().collect(Collectors.toList()))) {
                msPimInvoiceRowList = this.dependService.getExportInvoice(null, relationInvoiceIds);
            }
        } else if (MatchExportEnum.INVOICE_NOT_MATCH.code() <= tabStatus && MatchExportEnum.INVOICE_END_MATCH.code() >= tabStatus) {
            List relationBillIds;
            msPimInvoiceRowList = this.dependService.getExportInvoice(request, request.getInvoiceIds());
            if (msPimInvoiceRowList.size() > this.matchExportNum) {
                return response.code(MSResponse.Fail).message("\u5bfc\u51fa\u6761\u6570\u4e0d\u80fd\u8d85\u8fc7" + this.matchExportNum + "\u6761\uff01");
            }
            if (!MatchExportEnum.INVOICE_NOT_MATCH.code().equals(tabStatus) && CollectionUtils.isNotEmpty(relationBillIds = (relation = this.dependService.getRelation(msPimInvoiceRowList.stream().map(MsPimInvoiceRow::getId).collect(Collectors.toList()), null)).stream().map(MtcSalesbillInvoiceEntity::getSalesbillId).collect(Collectors.toList()))) {
                mtcSalesbillEntityList = this.dependService.getExportBillById(relationBillIds);
            }
        }
        this.dependService.exportMatchExcel(mtcSalesbillEntityList, msPimInvoiceRowList, relation, request);
        return response.code(MSResponse.OK).message("\u5bfc\u51fa\u9700\u8981\u7b49\u5f85\uff0c\u8bf7\u5230\u3010\u4e0b\u8f7d\u4e2d\u5fc3\u3011\u8fdb\u884c\u4e0b\u8f7d");
    }

    public MsResponse resendSalesBill(MsResendSalesBillRequest request) {
        MsResponse response = new MsResponse();
        if (CollectionUtils.isEmpty((Collection)request.getSalesbillIds())) {
            return response.code(Response.Fail).message("\u8bf7\u4f20\u5165\u5355\u636eid");
        }
        if (CollectionUtils.isEmpty((Collection)request.getOrgIds())) {
            return response.code(Response.Fail).message("\u6682\u65e0\u6743\u9650");
        }
        MtcSalesbillExample salesbillExample = new MtcSalesbillExample();
        salesbillExample.or().andSalesbillIdIn(request.getSalesbillIds()).andStatusEqualTo(Integer.valueOf(1)).andMatchStatusEqualTo(MatchStatusEnum.MATCH_END.getValue().toString()).andChargeUpStatusEqualTo(Integer.valueOf(2)).andSendStatusEqualTo(Integer.valueOf(1));
        List mtcSalesbillEntityList = this.salesbillDao.selectByExample(salesbillExample);
        if (CommonUtils.isEmpty((List)mtcSalesbillEntityList)) {
            return response.code(Response.Fail).message("\u6839\u636e\u5df2\u5b8c\u6210\u914d\u5355\u7684\u72b6\u6001\u5c1a\u672a\u67e5\u8be2\u5230\u8be5\u5355\u636e");
        }
        Map pushMatchInvoiceBeanMap = this.commonService.queryBillMatchedInvoice(mtcSalesbillEntityList.stream().map(r -> r.getSalesbillId()).collect(Collectors.toList()));
        PushMatchInfoBean pushMatchInfoBean = null;
        for (int i = 0; i < mtcSalesbillEntityList.size(); ++i) {
            MtcSalesbillEntity mtcSalesbillEntity = (MtcSalesbillEntity)mtcSalesbillEntityList.get(i);
            String salesbillNo = mtcSalesbillEntity.getSalesbillNo();
            Long salesbillId = mtcSalesbillEntity.getSalesbillId();
            List sourceBillNoList = this.commonService.querySourceBillNo(salesbillNo, salesbillId);
            pushMatchInfoBean = new PushMatchInfoBean();
            pushMatchInfoBean.setSalesbillNo(salesbillNo);
            pushMatchInfoBean.setSalesbillType(mtcSalesbillEntity.getSalesbillType());
            pushMatchInfoBean.setSourceSalesbillNo(sourceBillNoList);
            pushMatchInfoBean.setInvoiceList((List)pushMatchInvoiceBeanMap.getOrDefault(mtcSalesbillEntity.getSalesbillId(), new ArrayList()));
            String sendMsg = JsonUtils.writeObjectToJson((Object)pushMatchInfoBean);
            this.commonService.billRendCooperation(sendMsg, mtcSalesbillEntity.getCustomerNo(), salesbillNo, "resendSalesBill", salesbillId, mtcSalesbillEntity.getPurchaserGroupId(), mtcSalesbillEntity.getSellerGroupId());
        }
        return response.code(Response.OK).message("\u5df2\u7ecf\u91cd\u65b0\u4e0b\u53d1");
    }

    public List<MtcSalesbillEntity> getSalesBillEntities(List<MatchCriteria> list) {
        MtcSalesbillExample example = new MtcSalesbillExample();
        MtcSalesbillExample.Criteria criteria = example.createCriteria();
        try {
            list.stream().filter(r -> CollectionUtils.isNotEmpty((Collection)r.getValue())).forEach(r -> Optional.ofNullable(((Map)mtcSalesbillExampleMap.get()).get(r.getKey())).map(conditionMap -> (BiConsumer)conditionMap.get(r.getCondition())).ifPresent(condition -> condition.accept(r.getValue(), criteria)));
        }
        catch (Exception e) {
            log.error("assembleCriteria error {}, {}", (Object)e.getMessage(), (Object)e);
            return Lists.newArrayList();
        }
        return this.salesbillDao.selectByExample(example);
    }
}

