/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.service.impl;

import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.match.bean.CargoNameAndShortBean;
import com.xforceplus.phoenix.match.client.model.MsPage;
import com.xforceplus.phoenix.match.client.model.match.BillCorrectVO;
import com.xforceplus.phoenix.match.client.model.match.BillErrorVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceBillCheckListVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceCorrectVO;
import com.xforceplus.phoenix.match.client.model.match.InvoiceErrorVO;
import com.xforceplus.phoenix.match.client.request.MatchRequest;
import com.xforceplus.phoenix.match.client.request.SearchMatchRequest;
import com.xforceplus.phoenix.match.client.request.SearchNotMatchByInvoiceRequest;
import com.xforceplus.phoenix.match.common.enums.MatchStatusEnum;
import com.xforceplus.phoenix.match.common.enums.StatusEnum;
import com.xforceplus.phoenix.match.common.mapstruct.MatchMapper;
import com.xforceplus.phoenix.match.common.mapstruct.NewMatchMapper;
import com.xforceplus.phoenix.match.common.utils.CommonTools;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillItemDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillInvoiceExample;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemEntity;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillItemExample;
import com.xforceplus.phoenix.match.service.DependService;
import com.xforceplus.phoenix.match.service.ValidateService;
import com.xforceplus.phoenix.match.service.impl.CommonServiceImpl;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceDetailRow;
import com.xforceplus.phoenix.pim.client.model.MsPimInvoiceRow;
import com.xforceplus.phoenix.tools.util.InvoiceUtil;
import com.xforceplus.phoenix.tools.util.NullableUtil;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.purconfig.client.model.config.ConfigItemCodeEnum;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionBillBean;
import com.xforceplus.purconfig.client.model.config.item.MatchConditionInvoiceBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ValidateServiceImpl
implements ValidateService {
    private static final Logger logger = LoggerFactory.getLogger(ValidateServiceImpl.class);
    @Autowired
    DependService dependService;
    @Autowired
    MtcSalesbillItemDao mtcSalesbillItemDao;
    @Autowired
    CommonServiceImpl commonService;
    @Autowired
    MatchMapper matchMapper;
    @Autowired
    NewMatchMapper newMatchMapper;
    @Value(value="${bangbang.groupId:1227123362393432064}")
    Long groupId;
    private static Map<MatchConditionBean.ConditionEnum, Function<MsPimInvoiceRow, String>> matchRuleMap = ValidateServiceImpl.createMatchRuleMap();
    private static Map<MatchConditionInvoiceBean.ConditionEnum, Function<MsPimInvoiceRow, String>> invoiceCancelMatchRuleMap = ValidateServiceImpl.cancelMatchRuleMap();
    private static Map<MatchConditionBillBean.ConditionEnum, Function<MtcSalesbillEntity, String>> matchCancelRuleMap = ValidateServiceImpl.createMatchCancelRuleMap();

    private static Map<MatchConditionBean.ConditionEnum, Function<MsPimInvoiceRow, String>> createMatchRuleMap() {
        HashMap<MatchConditionBean.ConditionEnum, Function<MsPimInvoiceRow, String>> map = new HashMap<MatchConditionBean.ConditionEnum, Function<MsPimInvoiceRow, String>>();
        map.put(MatchConditionBean.ConditionEnum.C01, row -> row.getVeriStatus() != 3 ? "\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\u3010\u672a\u9a8c\u771f\u6210\u529f\u3011\uff01" : "");
        map.put(MatchConditionBean.ConditionEnum.C02, row -> row.getRecogStatus() == 0 ? "\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\u3010\u5f71\u50cf\u672a\u83b7\u53d6\u3011\uff01" : "");
        map.put(MatchConditionBean.ConditionEnum.C03, row -> row.getChargeUpStatus() == 0 ? "\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\u3010\u672a\u8bb0\u8d26\u3011\uff01" : "");
        map.put(MatchConditionBean.ConditionEnum.C04, row -> row.getPaymentStatus() != 2 ? "\u53d1\u7968\u4e0d\u6ee1\u8db3\u914d\u5355\u8981\u6c42\u3010\u672a\u5168\u90e8\u4ed8\u6b3e(\u5df2\u4ed8\u6b3e)\u3011\uff01" : "");
        return map;
    }

    private static Map<MatchConditionInvoiceBean.ConditionEnum, Function<MsPimInvoiceRow, String>> cancelMatchRuleMap() {
        HashMap<MatchConditionInvoiceBean.ConditionEnum, Function<MsPimInvoiceRow, String>> map = new HashMap<MatchConditionInvoiceBean.ConditionEnum, Function<MsPimInvoiceRow, String>>();
        map.put(MatchConditionInvoiceBean.ConditionEnum.C01, row -> row.getChargeUpStatus() == 1 ? "\u53d1\u7968\u4e0d\u53ef\u53d6\u6d88\u914d\u5355\u3010\u5df2\u8bb0\u8d26\u3011\uff01" : "");
        map.put(MatchConditionInvoiceBean.ConditionEnum.C02, row -> row.getPaymentStatus() != 0 ? "\u53d1\u7968\u4e0d\u53ef\u53d6\u6d88\u914d\u5355\u3010\u5df2\u4ed8\u6b3e\u3011\uff01" : "");
        return map;
    }

    public List<InvoiceErrorVO> validateMatchConditionRules(Long companyId, Long groupId, List<MsPimInvoiceRow> invoiceRows) {
        ArrayList<InvoiceErrorVO> invoiceErrorVOList = new ArrayList<InvoiceErrorVO>(invoiceRows.size());
        List matchList = this.dependService.getMatchConfigCondition(companyId, ConfigItemCodeEnum.MATCH_CONDITION, groupId);
        invoiceRows.forEach(row -> matchList.forEach(info -> {
            String errorMessage = (String)((Function)matchRuleMap.get(info.getCondition())).apply(row);
            if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                logger.warn(errorMessage + "invoiceNo:{},invoiceCode:{}", (Object)row.getInvoiceNo(), (Object)row.getInvoiceCode());
                InvoiceErrorVO invoiceErrorVO = new InvoiceErrorVO();
                BeanUtils.copyProperties((Object)row, (Object)invoiceErrorVO);
                invoiceErrorVO.setErrorMsg(errorMessage);
                invoiceErrorVOList.add(invoiceErrorVO);
            }
        }));
        return invoiceErrorVOList;
    }

    public List<InvoiceErrorVO> validateInvoiceMatchConditionCancelRules(Long companyId, Long groupId, List<MsPimInvoiceRow> invoiceRows) {
        ArrayList<InvoiceErrorVO> invoiceErrorVOList = new ArrayList<InvoiceErrorVO>(invoiceRows.size());
        List matchList = this.dependService.getCancelMatchInvoiceCondition(companyId, ConfigItemCodeEnum.MATCH_CONDITION_INVOICE, groupId);
        logger.info("validateInvoiceMatchConditionCancelRules:{}", (Object)JsonUtils.writeObjectToJson((Object)matchList));
        invoiceRows.forEach(row -> matchList.forEach(info -> {
            String errorMessage = (String)((Function)invoiceCancelMatchRuleMap.get(info.getCondition())).apply(row);
            if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                logger.warn(errorMessage + "invoiceNo:{},invoiceCode:{}", (Object)row.getInvoiceNo(), (Object)row.getInvoiceCode());
                InvoiceErrorVO invoiceErrorVO = new InvoiceErrorVO();
                BeanUtils.copyProperties((Object)row, (Object)invoiceErrorVO);
                invoiceErrorVO.setErrorMsg(errorMessage);
                invoiceErrorVOList.add(invoiceErrorVO);
            }
        }));
        return invoiceErrorVOList;
    }

    private static Map<MatchConditionBillBean.ConditionEnum, Function<MtcSalesbillEntity, String>> createMatchCancelRuleMap() {
        HashMap<MatchConditionBillBean.ConditionEnum, Function<MtcSalesbillEntity, String>> map = new HashMap<MatchConditionBillBean.ConditionEnum, Function<MtcSalesbillEntity, String>>();
        map.put(MatchConditionBillBean.ConditionEnum.C01, entity -> entity.getChargeUpStatus() == 1 ? "\u5355\u636e\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\u3010\u5df2\u8bb0\u8d26\u3011\uff01" : "");
        map.put(MatchConditionBillBean.ConditionEnum.C02, entity -> entity.getPaymentStatus() > 0 ? "\u5355\u636e\u4e0d\u53ef\u53d6\u6d88\u6761\u4ef6\u3010\u5df2\u4ed8\u6b3e\u3011\uff01" : "");
        return map;
    }

    public List<BillErrorVO> validateMatchConditionCancelRules(Long purchaserCompanyId, Long purchaserGroupId, List<MtcSalesbillEntity> mtcSalesbillEntityList) {
        ArrayList<BillErrorVO> errorVOList = new ArrayList<BillErrorVO>(mtcSalesbillEntityList.size());
        List matchList = this.dependService.getMatchBillCondition(purchaserCompanyId, ConfigItemCodeEnum.MATCH_CONDITION_BILL, purchaserGroupId);
        mtcSalesbillEntityList.forEach(entity -> matchList.forEach(info -> {
            String errorMessage = (String)((Function)matchCancelRuleMap.get(info.getCondition())).apply(entity);
            if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                logger.warn(errorMessage + "salesbillId:{},salesbillNo:{}", (Object)entity.getSalesbillId(), (Object)entity.getSalesbillNo());
                BillErrorVO billErrorVO = new BillErrorVO();
                BeanUtils.copyProperties((Object)entity, (Object)billErrorVO);
                billErrorVO.setErrorMsg(errorMessage);
                billErrorVO.setSalesbillId(entity.getSalesbillId().toString());
                errorVOList.add(billErrorVO);
            }
        }));
        return errorVOList;
    }

    public String validateSearchNotMatchByInvoice(SearchNotMatchByInvoiceRequest request, MtcSalesbillExample example, MtcSalesbillExample.Criteria criteria) {
        if (CollectionUtils.isEmpty((Collection)request.getIds())) {
            return "\u53d1\u7968ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        String check = CommonTools.checkPage((MsPage)request);
        if (check != null) {
            return check;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSortField()) && !Arrays.stream(MtcSalesbillInvoiceEntity.class.getDeclaredFields()).anyMatch(field -> field.getName().equals(request.getSortField()))) {
            return "\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728";
        }
        List<String> values = Arrays.asList(MatchStatusEnum.NO_MATCH.getValue().toString(), MatchStatusEnum.MATCH_ING.getValue().toString());
        criteria.andMatchStatusIn(values);
        if (StringUtils.isNotBlank((CharSequence)request.getSalesbillNo())) {
            criteria.andSalesbillNoLike(request.getSalesbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSellerName())) {
            criteria.andSellerNameLike(request.getSellerName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName());
        }
        example.setLimit(request.getPageSize());
        example.setOffset(Integer.valueOf((request.getPageNo() - 1) * request.getPageSize()));
        if (StringUtils.isNotBlank((CharSequence)request.getSortField())) {
            example.setOrderByClause(CommonTools.cameName((String)request.getSortField()) + " " + request.getSortOrder());
        }
        return "";
    }

    public String validateSearchMatch(SearchMatchRequest request, MtcSalesbillInvoiceExample example, MtcSalesbillInvoiceExample.Criteria criteria) {
        if (StringUtils.isNotBlank((CharSequence)request.getSortField()) && !Arrays.stream(MtcSalesbillInvoiceEntity.class.getDeclaredFields()).anyMatch(field -> field.getName().equals(request.getSortField()))) {
            return "\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728";
        }
        if (StringUtils.isNotBlank((CharSequence)request.getInvoiceCode())) {
            criteria.andInvoiceCodeEqualTo(request.getInvoiceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesbillNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getInvoiceCode())) {
            criteria.andInvoiceCodeEqualTo(request.getInvoiceCode());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getInvoiceNo())) {
            criteria.andInvoiceNoEqualTo(request.getInvoiceNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getSellerOrigin())) {
            criteria.andInvoiceSellerOriginIn(request.getSellerOrigin());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getRecogResponseTimeStart())) {
            Date invoiceScanTimeStart = new Date(Long.parseLong(request.getRecogResponseTimeStart()));
            if (Objects.isNull(invoiceScanTimeStart)) {
                return "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef";
            }
            criteria.andInvoiceScanTimeGreaterThanOrEqualTo(invoiceScanTimeStart);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getRecogResponseTimeEnd())) {
            Date invoiceScanTimeEnd = new Date(Long.parseLong(request.getRecogResponseTimeEnd()));
            if (Objects.isNull(invoiceScanTimeEnd)) {
                return "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef";
            }
            criteria.andInvoiceScanTimeLessThanOrEqualTo(invoiceScanTimeEnd);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSellerName())) {
            criteria.andSellerNameLike(request.getSellerName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPurchaserName())) {
            criteria.andPurchaserNameLike(request.getPurchaserName());
        }
        if (Objects.nonNull(request.getStatus())) {
            criteria.andStatusEqualTo(request.getStatus());
        }
        if (Objects.nonNull(request.getPageSize()) && Objects.nonNull(request.getPageNo())) {
            String check = CommonTools.checkPage((MsPage)request);
            if (check != null) {
                return check;
            }
            example.setLimit(request.getPageSize());
            example.setOffset(Integer.valueOf((request.getPageNo() - 1) * request.getPageSize()));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSortField())) {
            example.setOrderByClause(CommonTools.cameName((String)request.getSortField()) + " " + request.getSortOrder());
        }
        return "";
    }

    public String validateSellerAndPurchaser(List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList, Map<String, BigDecimal> unMatchedAmountSumMap) {
        String sellerTaxNo = mtcSalesbillEntityList.get(0).getSellerTaxNo();
        Long purchaserId = mtcSalesbillEntityList.get(0).getPurchaserId();
        Long purchaserGroupId = mtcSalesbillEntityList.get(0).getPurchaserGroupId();
        BigDecimal unMatchedBillAmountSum = BigDecimal.ZERO;
        BigDecimal unMatchedInvoiceAmountSum = BigDecimal.ZERO;
        for (MsPimInvoiceRow msPimInvoiceRow : msPimInvoiceRowList) {
            if (!msPimInvoiceRow.getIssueFlag().equals(1) && !sellerTaxNo.equals(msPimInvoiceRow.getSellerTaxNo())) {
                return "\u9500\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!";
            }
            if (msPimInvoiceRow.getIssueFlag().equals(1) && !sellerTaxNo.equals(msPimInvoiceRow.getIssueTaxNo())) {
                return "\u9500\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!";
            }
            if (!msPimInvoiceRow.getPurchaserCompanyId().equals(purchaserId)) {
                return "\u8d2d\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!";
            }
            BigDecimal unMatchedInvoiceAmount = new BigDecimal(msPimInvoiceRow.getAmountWithTax()).subtract(new BigDecimal(msPimInvoiceRow.getMatchAmount()));
            if (unMatchedInvoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
                return "\u53d1\u7968\u672a\u5339\u914d\u91d1\u989d\u7b49\u4e8e0!";
            }
            unMatchedInvoiceAmountSum = unMatchedInvoiceAmountSum.add(unMatchedInvoiceAmount);
        }
        if (unMatchedInvoiceAmountSum.compareTo(BigDecimal.ZERO) == 0) {
            return "\u53d1\u7968\u672a\u5339\u914d\u91d1\u989d\u5408\u8ba1\u7b49\u4e8e0!";
        }
        unMatchedAmountSumMap.put("UN_MATCHED_INVOICE_AMOUNT_SUM", unMatchedInvoiceAmountSum);
        for (MtcSalesbillEntity mtcSalesbillEntity : mtcSalesbillEntityList) {
            if (!mtcSalesbillEntity.getSellerTaxNo().equals(sellerTaxNo)) {
                return "\u9500\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!";
            }
            if (!mtcSalesbillEntity.getPurchaserId().equals(purchaserId)) {
                return "\u8d2d\u65b9\u516c\u53f8\u4e0d\u4e00\u81f4!";
            }
            if (mtcSalesbillEntity.getMatchStatus().equals(MatchStatusEnum.MATCH_END.getValue().toString())) {
                return "\u4e1a\u52a1\u5355\u5df2\u5339\u914d\u5b8c\u6210\uff01";
            }
            BigDecimal unMatchedBillAmount = mtcSalesbillEntity.getAmountWithTax().subtract(mtcSalesbillEntity.getDiscountWithTaxTotal()).subtract(mtcSalesbillEntity.getAlreadyAmountWithTax());
            if (unMatchedBillAmount.compareTo(BigDecimal.ZERO) == 0) {
                return "\u4e1a\u52a1\u5355\u672a\u5339\u914d\u91d1\u989d\u7b49\u4e8e0!";
            }
            unMatchedBillAmountSum = unMatchedBillAmountSum.add(unMatchedBillAmount);
        }
        if (unMatchedBillAmountSum.compareTo(BigDecimal.ZERO) == 0) {
            return "\u4e1a\u52a1\u5355\u672a\u5339\u914d\u91d1\u989d\u5408\u8ba1\u7b49\u4e8e0!";
        }
        unMatchedAmountSumMap.put("UN_MATCHED_BILL_AMOUNT_SUM", unMatchedBillAmountSum);
        return "";
    }

    public void validateInvoiceCargoName(List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList, Map<Long, Integer> weight, Map<Long, StringBuilder> weightRemark, Boolean flag) {
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        List<Integer> status = Arrays.asList(StatusEnum.OK.code(), StatusEnum.MADE.code(), StatusEnum.OPEN_INVOICE.code());
        example.createCriteria().andSalesbillIdIn(mtcSalesbillEntityList.stream().map(obj -> obj.getSalesbillId()).collect(Collectors.toList())).andStatusIn(status);
        List mtcSalesbillItemEntityList = this.mtcSalesbillItemDao.selectByExample(example);
        ArrayList<MsPimInvoiceDetailRow> msPimInvoiceDetailRowUnMatchList = null;
        Map<Long, List<MtcSalesbillItemEntity>> salesbillItemsGroupById = mtcSalesbillItemEntityList.stream().collect(Collectors.groupingBy(MtcSalesbillItemEntity::getSalesbillId));
        for (MsPimInvoiceRow msPimInvoiceRow : msPimInvoiceRowList) {
            Long invoiceId = msPimInvoiceRow.getId();
            List msPimInvoiceDetailRowList = this.dependService.getMsPimInvoiceDetailRowById(invoiceId);
            if (CollectionUtils.isEmpty((Collection)msPimInvoiceDetailRowList)) {
                logger.warn("\u83b7\u53d6\u53d1\u7968\u8d27\u7269\u4fe1\u606f\u4e3a\u7a7a\u6216\u53d1\u7968\u4e0d\u5b58\u5728\u54c1\u540d!invoiceId:{}", (Object)invoiceId);
                continue;
            }
            for (Map.Entry<Long, List<MtcSalesbillItemEntity>> entrySet : salesbillItemsGroupById.entrySet()) {
                Long weightId = flag != false ? invoiceId : entrySet.getKey();
                List<MtcSalesbillItemEntity> mtcSalesbillItemEntityById = entrySet.getValue();
                if (this.checkInvoiceAndSalesbillQuantity(msPimInvoiceDetailRowList, entrySet.getValue()).booleanValue()) {
                    this.setWeightAndRemark(weight, weightRemark, weightId, "\u6570\u91cf\u4e00\u81f4,");
                }
                Integer cargoNameFalseCount = 0;
                Integer ext1FalseCount = 0;
                msPimInvoiceDetailRowUnMatchList = new ArrayList<MsPimInvoiceDetailRow>();
                for (MsPimInvoiceDetailRow pimInvoiceDetail : msPimInvoiceDetailRowList) {
                    Integer n;
                    if (StringUtils.isEmpty((CharSequence)pimInvoiceDetail.getCargoName())) continue;
                    Boolean isMatch = Boolean.FALSE;
                    Boolean isShortMatch = Boolean.FALSE;
                    for (int j = 0; j < mtcSalesbillItemEntityById.size(); ++j) {
                        if (!this.commonService.getPureCargoName(InvoiceUtil.getCargoName((String)pimInvoiceDetail.getCargoName().trim())).equals(this.commonService.getPureCargoName(mtcSalesbillItemEntityById.get(j).getItemName().trim()))) continue;
                        logger.info("\u3010\u53d1\u7968\u54c1\u540d\u4e0e\u5355\u636e\u54c1\u540d\u5df2\u5339\u914d\u3011\u5355\u636eid:\u3010{}\u3011\u5355\u636e\u53f7\u7801:\u3010{}\u3011\u53d1\u7968ID:\u3010{}\u3011\u53d1\u7968\u53f7\u7801:\u3010{}\u3011", new Object[]{mtcSalesbillItemEntityById.get(j).getSalesbillId(), mtcSalesbillItemEntityById.get(j).getSalesbillNo(), invoiceId, msPimInvoiceRow.getInvoiceNo()});
                        isMatch = Boolean.TRUE;
                        if (!this.getShortFromInvoice(pimInvoiceDetail.getCargoName().trim()).equals(mtcSalesbillItemEntityById.get(j).getExt1())) continue;
                        isShortMatch = Boolean.TRUE;
                        break;
                    }
                    if (!isMatch.booleanValue()) {
                        msPimInvoiceDetailRowUnMatchList.add(pimInvoiceDetail);
                        Integer n2 = cargoNameFalseCount;
                        n = cargoNameFalseCount = Integer.valueOf(cargoNameFalseCount + 1);
                        n2 = ext1FalseCount;
                        n = ext1FalseCount = Integer.valueOf(ext1FalseCount + 1);
                    }
                    if (isShortMatch.booleanValue()) continue;
                    Integer n3 = ext1FalseCount;
                    n = ext1FalseCount = Integer.valueOf(ext1FalseCount + 1);
                }
                if (0 == cargoNameFalseCount) {
                    this.setWeightAndRemark(weight, weightRemark, weightId, "\u5546\u54c1\u540d\u79f0\u4e00\u81f4,");
                    if (0 == ext1FalseCount) {
                        this.setWeightAndRemark(weight, weightRemark, weightId, "\u7a0e\u7f16\u7b80\u79f0\u4e00\u81f4");
                    }
                }
                if (!CollectionUtils.isNotEmpty(msPimInvoiceDetailRowUnMatchList)) continue;
                this.validateBangbangName(mtcSalesbillEntityList, mtcSalesbillItemEntityById, msPimInvoiceDetailRowUnMatchList, weight, weightRemark, flag);
            }
        }
    }

    public InvoiceBillCheckListVO validateInvoiceCargoNameForMatch(List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MsPimInvoiceRow> msPimInvoiceRowList) {
        MtcSalesbillItemExample example = new MtcSalesbillItemExample();
        List<Integer> status = Arrays.asList(StatusEnum.OK.code(), StatusEnum.MADE.code(), StatusEnum.OPEN_INVOICE.code());
        example.createCriteria().andSalesbillIdIn(mtcSalesbillEntityList.stream().map(obj -> obj.getSalesbillId()).collect(Collectors.toList())).andStatusIn(status);
        List mtcSalesbillItemEntityList = this.mtcSalesbillItemDao.selectByExample(example);
        ArrayList msPimInvoiceDetailRowList = Lists.newArrayList();
        ArrayList<Object> msPimInvoiceDetailRowUnMatchList = null;
        Boolean anotherNameCheck = this.dependService.getGoodsNameValidate(mtcSalesbillEntityList.get(0).getPurchaserId(), mtcSalesbillEntityList.get(0).getPurchaserGroupId());
        logger.info("\u6821\u9a8c\u53d1\u7968\u660e\u7ec6\u54c1\u540d,\u662f\u5426\u5f00\u542f\u6821\u9a8c:{}", (Object)anotherNameCheck);
        ArrayList invoiceCorrectVOList = Lists.newArrayList();
        ArrayList invoiceErrorVOList = Lists.newArrayList();
        ArrayList billCorrectVOList = Lists.newArrayList();
        ArrayList billErroVOList = Lists.newArrayList();
        for (MsPimInvoiceRow msPimInvoiceRow : msPimInvoiceRowList) {
            Long invoiceId = msPimInvoiceRow.getId();
            List msPimInvoiceDetailRowList1 = this.dependService.getMsPimInvoiceDetailRowById(invoiceId);
            if (CollectionUtils.isEmpty((Collection)msPimInvoiceDetailRowList1)) {
                logger.warn("\u83b7\u53d6\u53d1\u7968\u8d27\u7269\u4fe1\u606f\u4e3a\u7a7a\u6216\u53d1\u7968\u4e0d\u5b58\u5728\u54c1\u540d!=>invoiceId:{}", (Object)invoiceId);
                continue;
            }
            msPimInvoiceDetailRowList.addAll(msPimInvoiceDetailRowList1);
            msPimInvoiceDetailRowUnMatchList = new ArrayList<Object>();
            ArrayList invoiceCorrectItems = Lists.newArrayList();
            ArrayList invoiceErrorItems = Lists.newArrayList();
            for (Object pimInvoiceDetail : msPimInvoiceDetailRowList1) {
                if (StringUtils.isEmpty((CharSequence)pimInvoiceDetail.getCargoName()) || !anotherNameCheck.booleanValue()) continue;
                Boolean isMatch = mtcSalesbillItemEntityList.stream().anyMatch(arg_0 -> this.lambda$validateInvoiceCargoNameForMatch$18((MsPimInvoiceDetailRow)pimInvoiceDetail, arg_0));
                if (!isMatch.booleanValue()) {
                    logger.info("\u53d1\u7968\u54c1\u540d\u4e0e\u5355\u636e\u54c1\u540d\u4e0d\u5339\u914d\uff0c\u53d1\u7968\u54c1\u540d:{}\uff0c\u53d1\u7968id:{}", (Object)pimInvoiceDetail.getCargoName(), (Object)pimInvoiceDetail.getInvoiceId());
                    invoiceErrorItems.add(this.newMatchMapper.toInvoiceItemVO((MsPimInvoiceDetailRow)pimInvoiceDetail));
                    msPimInvoiceDetailRowUnMatchList.add(pimInvoiceDetail);
                    continue;
                }
                logger.info("\u53d1\u7968\u54c1\u540d\u4e0e\u5355\u636e\u54c1\u540d\u76f8\u5339\u914d\uff0c\u53d1\u7968\u54c1\u540d:{}\uff0c\u53d1\u7968id:{}", (Object)pimInvoiceDetail.getCargoName(), (Object)pimInvoiceDetail.getInvoiceId());
                invoiceCorrectItems.add(this.newMatchMapper.toInvoiceItemVO((MsPimInvoiceDetailRow)pimInvoiceDetail));
            }
            if (CollectionUtils.isNotEmpty((Collection)invoiceCorrectItems)) {
                InvoiceCorrectVO invoiceCorrectVO = this.newMatchMapper.toInvoiceCorrectVO(msPimInvoiceRow);
                invoiceCorrectVO.setInvoiceCorrectItems((List)invoiceCorrectItems);
                invoiceCorrectVOList.add(invoiceCorrectVO);
            }
            if (!CollectionUtils.isNotEmpty((Collection)invoiceErrorItems) || !this.validateBangbangNameForMatch(mtcSalesbillEntityList, mtcSalesbillItemEntityList, msPimInvoiceDetailRowUnMatchList, msPimInvoiceRow.getPurchaserGroupId())) continue;
            InvoiceErrorVO invoiceErrorVO = this.newMatchMapper.toInvoiceErrorVO(msPimInvoiceRow);
            invoiceErrorVO.setInvoiceErrorItems((List)invoiceErrorItems);
            invoiceErrorVOList.add(invoiceErrorVO);
        }
        for (MtcSalesbillEntity mtcSalesbillEntity : mtcSalesbillEntityList) {
            Long salesbillId = mtcSalesbillEntity.getSalesbillId();
            MtcSalesbillItemExample example1 = new MtcSalesbillItemExample();
            example1.createCriteria().andSalesbillIdEqualTo(salesbillId).andStatusIn(Arrays.asList(StatusEnum.OK.code(), StatusEnum.MADE.code(), StatusEnum.OPEN_INVOICE.code()));
            List mtcSalesbillItemEntityList1 = this.mtcSalesbillItemDao.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)mtcSalesbillItemEntityList1)) {
                logger.warn("\u83b7\u53d6\u5355\u636e\u8d27\u7269\u4fe1\u606f\u4e3a\u7a7a\u6216\u5355\u636e\u4e0d\u5b58\u5728\u54c1\u540d!=>billId:{}", (Object)salesbillId);
                continue;
            }
            ArrayList billCorrectItems = Lists.newArrayList();
            ArrayList billErrorItems = Lists.newArrayList();
            for (MtcSalesbillItemEntity salesbillItemEntity : mtcSalesbillItemEntityList1) {
                if (StringUtils.isEmpty((CharSequence)salesbillItemEntity.getItemName()) || !anotherNameCheck.booleanValue()) continue;
                Boolean isMatch = msPimInvoiceDetailRowList.stream().anyMatch(r -> this.commonService.getPureCargoName(InvoiceUtil.getCargoName((String)this.replaceHelper(r.getCargoName().trim()))).equals(this.commonService.getPureCargoName(this.replaceHelper(salesbillItemEntity.getItemName().trim()))));
                if (!isMatch.booleanValue()) {
                    logger.info("\u5355\u636e\u54c1\u540d\u4e0e\u53d1\u7968\u54c1\u540d\u4e0d\u5339\u914d\uff0c\u5355\u636e\u54c1\u540d:{}\uff0c\u5355\u636e\u660e\u7ec6id:{}", (Object)salesbillItemEntity.getItemName(), (Object)salesbillItemEntity.getSalesbillItemId());
                    billErrorItems.add(this.newMatchMapper.toBillItemVO(salesbillItemEntity));
                    continue;
                }
                logger.info("\u5355\u636e\u54c1\u540d\u4e0e\u53d1\u7968\u54c1\u540d\u76f8\u5339\u914d\uff0c\u5355\u636e\u54c1\u540d:{}\uff0c\u5355\u636e\u660e\u7ec6id:{}", (Object)salesbillItemEntity.getItemName(), (Object)salesbillItemEntity.getSalesbillItemId());
                billCorrectItems.add(this.newMatchMapper.toBillItemVO(salesbillItemEntity));
            }
            if (CollectionUtils.isNotEmpty((Collection)billCorrectItems)) {
                BillCorrectVO billCorrectVO = this.newMatchMapper.toBillCorrectVO(mtcSalesbillEntity);
                billCorrectVO.setBillCorrectItems((List)billCorrectItems);
                billCorrectVOList.add(billCorrectVO);
            }
            if (!CollectionUtils.isNotEmpty((Collection)billErrorItems)) continue;
            BillErrorVO billErrorVO = this.newMatchMapper.toBillErrorVO(mtcSalesbillEntity);
            billErrorVO.setBillErrorItems((List)billErrorItems);
            billErroVOList.add(billErrorVO);
        }
        return InvoiceBillCheckListVO.builder().invoiceCorrectVOList((List)invoiceCorrectVOList).invoiceErrorVOList((List)invoiceErrorVOList).billCorrectVOList((List)billCorrectVOList).billErroVOList((List)billErroVOList).build();
    }

    public String replaceHelper(String s) {
        s = s.replace("\uff08", "(");
        s = s.replace("\uff09", ")");
        return s;
    }

    private void setWeightAndRemark(Map<Long, Integer> weight, Map<Long, StringBuilder> weightRemark, Long id, String remark) {
        weight.put(id, weight.getOrDefault(id, 0) + 1);
        weightRemark.put(id, weightRemark.get(id).append(remark));
    }

    private void validateBangbangName(List<MtcSalesbillEntity> billList, List<MtcSalesbillItemEntity> billItemList, List<MsPimInvoiceDetailRow> invoiceDetailUnMatchList, Map<Long, Integer> weight, Map<Long, StringBuilder> weightRemark, Boolean flag) {
        List businessNoList = billList.stream().map(obj -> obj.getSalesbillNo()).collect(Collectors.toList());
        List goodsNameList = invoiceDetailUnMatchList.stream().map(obj -> InvoiceUtil.getCargoName((String)obj.getCargoName().trim())).collect(Collectors.toList());
        Map standardNameMap = this.dependService.getInvoiceCargoNames(billList.get(0).getPurchaserName(), billList.get(0).getSellerName(), businessNoList, goodsNameList);
        HashSet itemNameSet = new HashSet();
        billItemList.stream().forEach(item -> {
            CargoNameAndShortBean cargoNameAndShortBean = new CargoNameAndShortBean();
            cargoNameAndShortBean.setCargoName(item.getItemName());
            cargoNameAndShortBean.setShortName(item.getExt1());
            itemNameSet.add(cargoNameAndShortBean);
        });
        Map<String, List<CargoNameAndShortBean>> itemNameMap = itemNameSet.stream().collect(Collectors.groupingBy(CargoNameAndShortBean::getCargoName));
        List salesbillCargoNameList = billItemList.stream().map(r -> this.commonService.getPureCargoName(r.getItemName())).distinct().collect(Collectors.toList());
        List invoiceCargoNameList = invoiceDetailUnMatchList.stream().map(r -> InvoiceUtil.getCargoName((String)r.getCargoName())).distinct().collect(Collectors.toList());
        List anotherNameList = standardNameMap.entrySet().stream().map(Map.Entry::getKey).distinct().collect(Collectors.toList());
        List standardNameList = standardNameMap.entrySet().stream().map(Map.Entry::getValue).distinct().collect(Collectors.toList());
        Long salesbillId = billItemList.get(0).getSalesbillId();
        Long invoiceId = invoiceDetailUnMatchList.get(0).getInvoiceId();
        Boolean salesbillContainsAll = Boolean.TRUE;
        Boolean salesbillContainsSingle = Boolean.FALSE;
        for (Map.Entry entry : standardNameMap.entrySet()) {
            if (((String)entry.getValue()).contains(",")) {
                String[] array = ((String)entry.getValue()).split(",");
                salesbillContainsSingle = Boolean.FALSE;
                for (String single : array) {
                    if (!salesbillCargoNameList.contains(this.commonService.getPureCargoName(single))) continue;
                    salesbillContainsSingle = Boolean.TRUE;
                    standardNameMap.put(entry.getKey(), single);
                    break;
                }
                if (salesbillContainsSingle.booleanValue()) continue;
                salesbillContainsAll = Boolean.FALSE;
                break;
            }
            if (salesbillCargoNameList.contains(entry.getValue())) continue;
            salesbillContainsAll = Boolean.FALSE;
            break;
        }
        logger.info("\u5355\u636e\u54c1\u540d\u5305\u542b\u6240\u6709\u53d1\u7968\u522b\u540d\uff1a{},\u53d1\u7968\u522b\u540d\u4e0e\u6807\u51c6\u540d\u79f01\u5bf91\u5173\u7cfb{}", (Object)salesbillContainsAll, (Object)standardNameMap);
        if (invoiceCargoNameList.size() == anotherNameList.size() && salesbillContainsAll.booleanValue()) {
            this.setWeightAndRemark(weight, weightRemark, flag != false ? invoiceId : salesbillId, "\u5546\u54c1\u540d\u79f0\u4e00\u81f4,");
            Integer matchBillShortCount = 0;
            block2: for (MsPimInvoiceDetailRow detailRow : invoiceDetailUnMatchList) {
                List<CargoNameAndShortBean> cargoNameAndShortBeanList = itemNameMap.get(standardNameMap.get(InvoiceUtil.getCargoName((String)detailRow.getCargoName())));
                for (CargoNameAndShortBean cargoNameAndShortBean : cargoNameAndShortBeanList) {
                    if (!this.getShortFromInvoice(detailRow.getCargoName()).equals(cargoNameAndShortBean.getShortName())) continue;
                    Integer n = matchBillShortCount;
                    Integer n2 = matchBillShortCount = Integer.valueOf(matchBillShortCount + 1);
                    continue block2;
                }
            }
            if (matchBillShortCount.equals(invoiceDetailUnMatchList.size())) {
                this.setWeightAndRemark(weight, weightRemark, flag != false ? invoiceId : salesbillId, "\u7a0e\u7f16\u7b80\u79f0\u4e00\u81f4");
            }
        }
    }

    private boolean validateBangbangNameForMatch(List<MtcSalesbillEntity> mtcSalesbillEntityList, List<MtcSalesbillItemEntity> mtcSalesbillItemEntityList, List<MsPimInvoiceDetailRow> msPimInvoiceDetailRowUnMatchList, Long purchaserGroupId) {
        List businessNoList = mtcSalesbillEntityList.stream().map(obj -> obj.getSalesbillNo()).collect(Collectors.toList());
        List goodsNameList = msPimInvoiceDetailRowUnMatchList.stream().map(obj -> InvoiceUtil.getCargoName((String)obj.getCargoName().trim())).distinct().collect(Collectors.toList());
        Map standardNameMap = Maps.newConcurrentMap();
        logger.info("validateBangbangNameForMatch,purchaserGroupId:{},groupId:{}", (Object)purchaserGroupId, (Object)this.groupId);
        if (this.groupId.equals(purchaserGroupId)) {
            logger.info("\u8fdc\u7a0b\u8c03\u7528\u90a6\u90a6\u83b7\u53d6\u522b\u540d");
            standardNameMap = this.dependService.getInvoiceCargoNames(mtcSalesbillEntityList.get(0).getPurchaserName(), mtcSalesbillEntityList.get(0).getSellerName(), businessNoList, goodsNameList);
        }
        List salesbillCargoNameList = mtcSalesbillItemEntityList.stream().map(r -> this.commonService.getPureCargoName(r.getItemName().trim())).distinct().collect(Collectors.toList());
        Boolean isMatch = null;
        if (goodsNameList.size() == standardNameMap.size()) {
            for (MsPimInvoiceDetailRow msPimInvoiceDetailRow : msPimInvoiceDetailRowUnMatchList) {
                String standardName = (String)standardNameMap.get(InvoiceUtil.getCargoName((String)msPimInvoiceDetailRow.getCargoName()));
                String[] standardNameArray = standardName.split(",");
                isMatch = Boolean.TRUE;
                for (String singleStandardName : standardNameArray) {
                    if (!salesbillCargoNameList.contains(this.commonService.getPureCargoName(singleStandardName))) continue;
                    isMatch = Boolean.FALSE;
                    break;
                }
                if (!isMatch.booleanValue()) continue;
                return Boolean.TRUE;
            }
        } else {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String validateCreateMatchParameter(MatchRequest data) {
        if (CollectionUtils.isEmpty((Collection)data.getSalesBillIds())) {
            return "\u4e1a\u52a1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (CollectionUtils.isEmpty((Collection)data.getInvoiceIds())) {
            return "\u53d1\u7968\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        return "";
    }

    private String getShortFromInvoice(String cargoName) {
        String[] cargoSplit = cargoName.split("\\*");
        if (cargoSplit.length >= 3) {
            return cargoSplit[1];
        }
        return cargoName;
    }

    private Boolean checkInvoiceAndSalesbillQuantity(List<MsPimInvoiceDetailRow> msPimInvoiceDetailRowList, List<MtcSalesbillItemEntity> mtcSalesbillItemEntityList) {
        BigDecimal invoiceTotal = BigDecimal.ZERO;
        BigDecimal salesbillTotal = BigDecimal.ZERO;
        for (MsPimInvoiceDetailRow detail : msPimInvoiceDetailRowList) {
            invoiceTotal = invoiceTotal.add(NullableUtil.toBigDecimalValue((Object)detail.getQuantity(), (BigDecimal)BigDecimal.ZERO));
        }
        for (MtcSalesbillItemEntity item : mtcSalesbillItemEntityList) {
            salesbillTotal = salesbillTotal.add(item.getQuantity());
        }
        if (invoiceTotal.compareTo(salesbillTotal) == 0) {
            return true;
        }
        return false;
    }

    public List<MsPimInvoiceRow> validateMatchConditionRulesForRecommend(Long purchaserCompanyId, Long purchaserGroupId, List<MsPimInvoiceRow> msPimInvoiceRowList) {
        List matchList = this.dependService.getMatchConfigCondition(purchaserCompanyId, ConfigItemCodeEnum.MATCH_CONDITION, purchaserGroupId);
        msPimInvoiceRowList = msPimInvoiceRowList.stream().filter(row -> !matchList.stream().anyMatch(info -> StringUtils.isNotEmpty((CharSequence)((CharSequence)((Function)matchRuleMap.get(info.getCondition())).apply(row))))).collect(Collectors.toList());
        return msPimInvoiceRowList;
    }

    private /* synthetic */ boolean lambda$validateInvoiceCargoNameForMatch$18(MsPimInvoiceDetailRow pimInvoiceDetail, MtcSalesbillItemEntity r) {
        return this.commonService.getPureCargoName(InvoiceUtil.getCargoName((String)this.replaceHelper(pimInvoiceDetail.getCargoName().trim()))).equals(this.commonService.getPureCargoName(this.replaceHelper(r.getItemName().trim())));
    }
}

