/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.match.xxjob;

import com.xforceplus.phoenix.match.bean.PushMatchInfoBean;
import com.xforceplus.phoenix.match.repository.dao.MtcSalesbillDao;
import com.xforceplus.phoenix.match.repository.model.MtcSalesbillEntity;
import com.xforceplus.phoenix.match.service.MatchOperateLogService;
import com.xforceplus.phoenix.match.service.SalesbillService;
import com.xforceplus.phoenix.match.service.impl.CommonServiceImpl;
import com.xforceplus.purchaser.common.utils.CommonUtils;
import com.xforceplus.purchaser.common.utils.JsonUtils;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMatchStatusJobHandler {
    private Logger logger = LoggerFactory.getLogger(PushMatchStatusJobHandler.class);
    @Autowired
    private SalesbillService salesbillService;
    @Autowired
    SqsService sqsService;
    @Autowired
    private MtcSalesbillDao salesbillDao;
    @Autowired
    MatchOperateLogService operateLogService;
    @Autowired
    private CommonServiceImpl commonService;

    @XxlJob(value="pushMatchStatusJobHandler")
    public ReturnT<String> execute(String str) throws Exception {
        this.logger.info("PushMatchStatusJobHandler\u5f00\u59cb\u63a8\u9001\u5df2\u5b8c\u5168\u5339\u914d\u7684\u4e1a\u52a1\u5355\u7ed9\u96c6\u6210\u5165\u53c2:{}", (Object)str);
        ReturnT t = new ReturnT();
        try {
            int sendStatus = 0;
            String matchStatusStr = "2";
            String salesbillNoStr = "";
            if (!CommonUtils.isEmpty((String)str)) {
                String[] split = str.split("#");
                sendStatus = Integer.valueOf(split[0]);
                matchStatusStr = split[1];
                salesbillNoStr = split[2];
            }
            t.setCode(200);
            this.logger.info("pushMatchStatusJobHandler,\u83b7\u53d6\u4e1a\u52a1\u5355\u5165\u53c2:sendStatus:{},matchStatusStr:{},salesbillNoStr:{}", new Object[]{sendStatus, matchStatusStr, salesbillNoStr});
            List matchSalesbillList = this.salesbillService.getMatchSalesbillList(salesbillNoStr, matchStatusStr, sendStatus);
            if (CollectionUtils.isEmpty((Collection)matchSalesbillList)) {
                return t;
            }
            Map pushMatchInvoiceBeanMap = this.commonService.queryBillMatchedInvoice(matchSalesbillList.stream().map(r -> r.getSalesbillId()).collect(Collectors.toList()));
            PushMatchInfoBean pushMatchInfoBean = null;
            for (int i = 0; i < matchSalesbillList.size(); ++i) {
                MtcSalesbillEntity mtcSalesbillEntity = (MtcSalesbillEntity)matchSalesbillList.get(i);
                String salesbillNo = mtcSalesbillEntity.getSalesbillNo();
                Long salesbillId = mtcSalesbillEntity.getSalesbillId();
                List sourceBillNoList = this.commonService.querySourceBillNo(salesbillNo, salesbillId);
                pushMatchInfoBean = new PushMatchInfoBean();
                pushMatchInfoBean.setSalesbillNo(salesbillNo);
                pushMatchInfoBean.setSalesbillType(mtcSalesbillEntity.getSalesbillType());
                pushMatchInfoBean.setSourceSalesbillNo(sourceBillNoList);
                pushMatchInfoBean.setInvoiceList((List)pushMatchInvoiceBeanMap.getOrDefault(mtcSalesbillEntity.getSalesbillId(), new ArrayList()));
                String sendMsg = JsonUtils.writeObjectToJson((Object)pushMatchInfoBean);
                Boolean sendResult = this.commonService.billRendCooperation(sendMsg, mtcSalesbillEntity.getCustomerNo(), salesbillNo, "pushMatchStatusJobHandler", salesbillId, mtcSalesbillEntity.getPurchaserGroupId(), mtcSalesbillEntity.getSellerGroupId());
                if (!sendResult.booleanValue()) continue;
                mtcSalesbillEntity.setSendStatus(Integer.valueOf(1));
                mtcSalesbillEntity.setUpdateTime(new Date());
                this.salesbillDao.updateByPrimaryKeySelective(mtcSalesbillEntity);
            }
        }
        catch (Exception e) {
            t.setCode(500);
            t.setMsg(e.getMessage());
            this.logger.error("PushMatchStatusJobHandler\u5f00\u59cb\u63a8\u9001\u5df2\u5b8c\u5168\u5339\u914d\u7684\u4e1a\u52a1\u5355\u7ed9\u96c6\u6210\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return t;
    }
}

