package com.xforceplus.matchingassets.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-08-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.matchingassets.entity.BillDocument;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "matching-assets")
public interface BillDocumentFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/billDocument/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param billDocument ${table.comment}
   * @return R
   */
  @PostMapping("/billDocument/add")
  public R save(@RequestBody BillDocument billDocument);

  /**
   * 修改${table.comment}
   * @param billDocument ${table.comment}
   * @return R
   */
  @PostMapping("/billDocument/update")
  public R updateById(@RequestBody BillDocument billDocument);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/billDocument/del/{id}" )
  public R removeById(@PathVariable Long id);

}