package com.xforceplus.eccpsupplierportal.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-08-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.NewMfrsCert;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "new-certificate-manage")
public interface NewMfrsCertFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/newMfrsCert/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param newMfrsCert ${table.comment}
   * @return R
   */
  @PostMapping("/newMfrsCert/add")
  public R save(@RequestBody NewMfrsCert newMfrsCert);

  /**
   * 修改${table.comment}
   * @param newMfrsCert ${table.comment}
   * @return R
   */
  @PostMapping("/newMfrsCert/update")
  public R updateById(@RequestBody NewMfrsCert newMfrsCert);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/newMfrsCert/del/{id}" )
  public R removeById(@PathVariable Long id);

}