package com.xforceplus.new20.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * relation0526002
 * </p>
 *
 * @author ultraman
 * @since 2023-06-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Relation0526002 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * zfc0526002
   */
  private String zfc0526002;

  /**
   * zfc05260021
   */
  private String zfc05260021;

  /**
   * zx0526002
   */
  private Long zx0526002;

  /**
   * jine0526002
   */
  private BigDecimal jine0526002;

  /**
   * xs0526002
   */
  private BigDecimal xs0526002;

  /**
   * date0526002
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime date0526002;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 relation0526001
   */
    private Long yddgx0526001Id;
  /**
   * 对一关联关系 关联对象 relation0526003
   */
    private Long ddygx0526002Id;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc0526002", zfc0526002);
      map.put("zfc05260021", zfc05260021);
      map.put("zx0526002", zx0526002);
      map.put("jine0526002", jine0526002);
      map.put("xs0526002", xs0526002);
      map.put("date0526002", BocpGenUtils.toTimestamp(date0526002));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("yddgx0526001.id", yddgx0526001Id);
       map.put("ddygx0526002.id", ddygx0526002Id);
      return map;
  }

  public static Relation0526002 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Relation0526002 entity = new Relation0526002();
    if(map.containsKey("zfc0526002")) {
      Object obj = map.get("zfc0526002");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc0526002((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc05260021")) {
      Object obj = map.get("zfc05260021");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc05260021((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx0526002")) {
      Object obj = map.get("zx0526002");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx0526002((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx0526002(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx0526002(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("jine0526002")) {
      Object obj = map.get("jine0526002");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine0526002((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine0526002(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine0526002(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine0526002(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine0526002(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("xs0526002")) {
      Object obj = map.get("xs0526002");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs0526002((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs0526002(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs0526002(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs0526002(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs0526002(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("date0526002")) {
      Object obj = map.get("date0526002");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDate0526002(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDate0526002((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDate0526002(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDate0526002(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("yddgx0526001.id")) {
        Object obj = map.get("yddgx0526001.id");
      if(obj instanceof Long) {
        entity.setYddgx0526001Id((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setYddgx0526001Id(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("ddygx0526002.id")) {
        Object obj = map.get("ddygx0526002.id");
      if(obj instanceof Long) {
        entity.setDdygx0526002Id((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setDdygx0526002Id(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc0526002")) {
      Object obj = map.get("zfc0526002");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc0526002((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc05260021")) {
      Object obj = map.get("zfc05260021");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc05260021((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zx0526002")) {
      Object obj = map.get("zx0526002");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx0526002((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZx0526002(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx0526002(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("jine0526002")) {
      Object obj = map.get("jine0526002");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJine0526002((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJine0526002(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJine0526002(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJine0526002(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJine0526002(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("xs0526002")) {
      Object obj = map.get("xs0526002");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs0526002((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs0526002(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs0526002(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs0526002(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs0526002(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("date0526002")) {
      Object obj = map.get("date0526002");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDate0526002(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDate0526002((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDate0526002(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDate0526002(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("yddgx0526001.id")) {
        Object obj = map.get("yddgx0526001.id");
        if(obj instanceof Long) {
          this.setYddgx0526001Id((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setYddgx0526001Id(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("ddygx0526002.id")) {
        Object obj = map.get("ddygx0526002.id");
        if(obj instanceof Long) {
          this.setDdygx0526002Id((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDdygx0526002Id(Long.parseLong((String)obj));
        }
      }
  }
}
