package com.xforceplus.new20.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * yacees0530001x
 * </p>
 *
 * @author ultraman
 * @since 2023-06-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Yacees0530001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * cargo_code
   */
  private String cargoCode;

  /**
   * cargo_name
   */
  private String cargoName;

  /**
   * item_spec
   */
  private String itemSpec;

  /**
   * quantity_unit
   */
  private String quantityUnit;

  /**
   * quantity
   */
  private String quantity;

  /**
   * tax_rate
   */
  private String taxRate;

  /**
   * unit_price
   */
  private String unitPrice;

  /**
   * tax_amount
   */
  private String taxAmount;

  /**
   * amount_without_tax
   */
  private String amountWithoutTax;

  /**
   * amount_with_tax
   */
  private String amountWithTax;

  /**
   * tax_rate_type
   */
  private String taxRateType;

  /**
   * toll_start_date
   */
  private String tollStartDate;

  /**
   * toll_end_date
   */
  private String tollEndDate;

  /**
   * plate_number
   */
  private String plateNumber;

  /**
   * vehicle_type
   */
  private String vehicleType;

  /**
   * discount_without_tax
   */
  private String discountWithoutTax;

  /**
   * discount_tax
   */
  private String discountTax;

  /**
   * discount_with_tax
   */
  private String discountWithTax;

  /**
   * discount_rate
   */
  private String discountRate;

  /**
   * tax_item
   */
  private String taxItem;

  /**
   * goods_no_ver
   */
  private String goodsNoVer;

  /**
   * goods_tax_no
   */
  private String goodsTaxNo;

  /**
   * goods_erp_no
   */
  private String goodsErpNo;

  /**
   * tax_pre_flag
   */
  private String taxPreFlag;

  /**
   * tax_pre_content
   */
  private String taxPreContent;

  /**
   * tax_dedunction
   */
  private String taxDedunction;

  /**
   * discount_flag
   */
  private String discountFlag;

  /**
   * price_method
   */
  private String priceMethod;

  /**
   * org_id
   */
  private String orgId;

  /**
   * row_num
   */
  private String rowNum;

  /**
   * tax_incentives_type
   */
  private String taxIncentivesType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("cargo_code", cargoCode);
      map.put("cargo_name", cargoName);
      map.put("item_spec", itemSpec);
      map.put("quantity_unit", quantityUnit);
      map.put("quantity", quantity);
      map.put("tax_rate", taxRate);
      map.put("unit_price", unitPrice);
      map.put("tax_amount", taxAmount);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate_type", taxRateType);
      map.put("toll_start_date", tollStartDate);
      map.put("toll_end_date", tollEndDate);
      map.put("plate_number", plateNumber);
      map.put("vehicle_type", vehicleType);
      map.put("discount_without_tax", discountWithoutTax);
      map.put("discount_tax", discountTax);
      map.put("discount_with_tax", discountWithTax);
      map.put("discount_rate", discountRate);
      map.put("tax_item", taxItem);
      map.put("goods_no_ver", goodsNoVer);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("goods_erp_no", goodsErpNo);
      map.put("tax_pre_flag", taxPreFlag);
      map.put("tax_pre_content", taxPreContent);
      map.put("tax_dedunction", taxDedunction);
      map.put("discount_flag", discountFlag);
      map.put("price_method", priceMethod);
      map.put("org_id", orgId);
      map.put("row_num", rowNum);
      map.put("tax_incentives_type", taxIncentivesType);

      return map;
  }

  public static Yacees0530001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Yacees0530001 entity = new Yacees0530001();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargo_code")) {
      Object obj = map.get("cargo_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargo_name")) {
      Object obj = map.get("cargo_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate_type")) {
      Object obj = map.get("tax_rate_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toll_start_date")) {
      Object obj = map.get("toll_start_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTollStartDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toll_end_date")) {
      Object obj = map.get("toll_end_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTollEndDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plate_number")) {
      Object obj = map.get("plate_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlateNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_without_tax")) {
      Object obj = map.get("discount_without_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_tax")) {
      Object obj = map.get("discount_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_with_tax")) {
      Object obj = map.get("discount_with_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_rate")) {
      Object obj = map.get("discount_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_item")) {
      Object obj = map.get("tax_item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_no_ver")) {
      Object obj = map.get("goods_no_ver");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_erp_no")) {
      Object obj = map.get("goods_erp_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsErpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_flag")) {
      Object obj = map.get("tax_pre_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_content")) {
      Object obj = map.get("tax_pre_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_dedunction")) {
      Object obj = map.get("tax_dedunction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxDedunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_flag")) {
      Object obj = map.get("discount_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("row_num")) {
      Object obj = map.get("row_num");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRowNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_incentives_type")) {
      Object obj = map.get("tax_incentives_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxIncentivesType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cargo_code")) {
      Object obj = map.get("cargo_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCargoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cargo_name")) {
      Object obj = map.get("cargo_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCargoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate_type")) {
      Object obj = map.get("tax_rate_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("toll_start_date")) {
      Object obj = map.get("toll_start_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTollStartDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("toll_end_date")) {
      Object obj = map.get("toll_end_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTollEndDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plate_number")) {
      Object obj = map.get("plate_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlateNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_without_tax")) {
      Object obj = map.get("discount_without_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_tax")) {
      Object obj = map.get("discount_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_with_tax")) {
      Object obj = map.get("discount_with_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_rate")) {
      Object obj = map.get("discount_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_item")) {
      Object obj = map.get("tax_item");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_no_ver")) {
      Object obj = map.get("goods_no_ver");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNoVer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_erp_no")) {
      Object obj = map.get("goods_erp_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsErpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre_flag")) {
      Object obj = map.get("tax_pre_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_pre_content")) {
      Object obj = map.get("tax_pre_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_dedunction")) {
      Object obj = map.get("tax_dedunction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxDedunction((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount_flag")) {
      Object obj = map.get("discount_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("row_num")) {
      Object obj = map.get("row_num");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRowNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_incentives_type")) {
      Object obj = map.get("tax_incentives_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxIncentivesType((String)obj);
        }
      } else {
      }
    }
  }
}
