package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Bss;
import com.xforceplus.new20.service.IBssService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * sddssss前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class BssController {

  @Autowired
  private IBssService bssServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bss sddssss
   * @return
   */
  @GetMapping("/bsss" )
  public XfR getBsss(XfPage page, Bss bss) {
    return XfR.ok(bssServiceImpl.page(page, Wrappers.query(bss)));
  }

  /**
   * 通过id查询sddssss
   * @param  id
   * @return XfR
   */
  @GetMapping("/bsss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bssServiceImpl.getById(id));
  }

  /**
   * 新增sddssss
   * @param bss sddssss
   * @return XfR
   */
  @PostMapping("/bsss")
  public XfR save(@RequestBody Bss bss) {
     return XfR.ok(bssServiceImpl.save(bss));
  }

  /**
   * 修改-传入修改后的全部数据sddssss
   * @param bss sddssss
   * @return XfR
   */
  @PutMapping("/bsss/{id}")
  public XfR putUpdate(@RequestBody Bss bss,@PathVariable Long id) {
      bss.setId(id);
      return XfR.ok(bssServiceImpl.updateById(bss));
  }

  /**
   * 修改-传入修改的数据sddssss
   * @param bss sddssss
   * @return XfR
   */
  @PatchMapping("/bsss/{id}")
  public XfR patchUpdate(@RequestBody Bss bss,@PathVariable Long id) {
      Bss upbss = bssServiceImpl.getById(id);
      if(upbss != null){
        upbss = ObjectCopyUtils.copyProperties(bss,upbss,true);
      }
      return XfR.ok(bssServiceImpl.updateById(upbss));
  }

  /**
   * 通过id删除sddssss
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bsss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bssServiceImpl.removeById(id));
  }

  @PostMapping("/bsss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bss");
     params.put("request", condition);

     return XfR.ok(bssServiceImpl.querys(params));
  }

}
