package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Child1;
import com.xforceplus.new20.service.IChild1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Child1Controller {

  @Autowired
  private IChild1Service child1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param child1 ${table.comment}
   * @return
   */
  @GetMapping("/child1s" )
  public XfR getChild1s(XfPage page, Child1 child1) {
    return XfR.ok(child1ServiceImpl.page(page, Wrappers.query(child1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/child1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(child1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param child1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/child1s")
  public XfR save(@RequestBody Child1 child1) {
     return XfR.ok(child1ServiceImpl.save(child1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param child1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/child1s/{id}")
  public XfR putUpdate(@RequestBody Child1 child1,@PathVariable Long id) {
      child1.setId(id);
      return XfR.ok(child1ServiceImpl.updateById(child1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param child1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/child1s/{id}")
  public XfR patchUpdate(@RequestBody Child1 child1,@PathVariable Long id) {
      Child1 upchild1 = child1ServiceImpl.getById(id);
      if(upchild1 != null){
        upchild1 = ObjectCopyUtils.copyProperties(child1,upchild1,true);
      }
      return XfR.ok(child1ServiceImpl.updateById(upchild1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/child1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(child1ServiceImpl.removeById(id));
  }

  @PostMapping("/child1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child1");
     params.put("request", condition);

     return XfR.ok(child1ServiceImpl.querys(params));
  }

}
