package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei051801;
import com.xforceplus.new20.service.IFulei051801Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei051801前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Fulei051801Controller {

  @Autowired
  private IFulei051801Service fulei051801ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei051801 fulei051801
   * @return
   */
  @GetMapping("/fulei051801s" )
  public XfR getFulei051801s(XfPage page, Fulei051801 fulei051801) {
    return XfR.ok(fulei051801ServiceImpl.page(page, Wrappers.query(fulei051801)));
  }

  /**
   * 通过id查询fulei051801
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei051801s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei051801ServiceImpl.getById(id));
  }

  /**
   * 新增fulei051801
   * @param fulei051801 fulei051801
   * @return XfR
   */
  @PostMapping("/fulei051801s")
  public XfR save(@RequestBody Fulei051801 fulei051801) {
     return XfR.ok(fulei051801ServiceImpl.save(fulei051801));
  }

  /**
   * 修改-传入修改后的全部数据fulei051801
   * @param fulei051801 fulei051801
   * @return XfR
   */
  @PutMapping("/fulei051801s/{id}")
  public XfR putUpdate(@RequestBody Fulei051801 fulei051801,@PathVariable Long id) {
      fulei051801.setId(id);
      return XfR.ok(fulei051801ServiceImpl.updateById(fulei051801));
  }

  /**
   * 修改-传入修改的数据fulei051801
   * @param fulei051801 fulei051801
   * @return XfR
   */
  @PatchMapping("/fulei051801s/{id}")
  public XfR patchUpdate(@RequestBody Fulei051801 fulei051801,@PathVariable Long id) {
      Fulei051801 upfulei051801 = fulei051801ServiceImpl.getById(id);
      if(upfulei051801 != null){
        upfulei051801 = ObjectCopyUtils.copyProperties(fulei051801,upfulei051801,true);
      }
      return XfR.ok(fulei051801ServiceImpl.updateById(upfulei051801));
  }

  /**
   * 通过id删除fulei051801
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei051801s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei051801ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei051801s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei051801");
     params.put("request", condition);

     return XfR.ok(fulei051801ServiceImpl.querys(params));
  }

}
