package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei0801001;
import com.xforceplus.new20.service.IFulei0801001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei0801001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Fulei0801001Controller {

  @Autowired
  private IFulei0801001Service fulei0801001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei0801001 fulei0801001
   * @return
   */
  @GetMapping("/fulei0801001s" )
  public XfR getFulei0801001s(XfPage page, Fulei0801001 fulei0801001) {
    return XfR.ok(fulei0801001ServiceImpl.page(page, Wrappers.query(fulei0801001)));
  }

  /**
   * 通过id查询fulei0801001
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei0801001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei0801001ServiceImpl.getById(id));
  }

  /**
   * 新增fulei0801001
   * @param fulei0801001 fulei0801001
   * @return XfR
   */
  @PostMapping("/fulei0801001s")
  public XfR save(@RequestBody Fulei0801001 fulei0801001) {
     return XfR.ok(fulei0801001ServiceImpl.save(fulei0801001));
  }

  /**
   * 修改-传入修改后的全部数据fulei0801001
   * @param fulei0801001 fulei0801001
   * @return XfR
   */
  @PutMapping("/fulei0801001s/{id}")
  public XfR putUpdate(@RequestBody Fulei0801001 fulei0801001,@PathVariable Long id) {
      fulei0801001.setId(id);
      return XfR.ok(fulei0801001ServiceImpl.updateById(fulei0801001));
  }

  /**
   * 修改-传入修改的数据fulei0801001
   * @param fulei0801001 fulei0801001
   * @return XfR
   */
  @PatchMapping("/fulei0801001s/{id}")
  public XfR patchUpdate(@RequestBody Fulei0801001 fulei0801001,@PathVariable Long id) {
      Fulei0801001 upfulei0801001 = fulei0801001ServiceImpl.getById(id);
      if(upfulei0801001 != null){
        upfulei0801001 = ObjectCopyUtils.copyProperties(fulei0801001,upfulei0801001,true);
      }
      return XfR.ok(fulei0801001ServiceImpl.updateById(upfulei0801001));
  }

  /**
   * 通过id删除fulei0801001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei0801001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei0801001ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei0801001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei0801001");
     params.put("request", condition);

     return XfR.ok(fulei0801001ServiceImpl.querys(params));
  }

}
