package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei4;
import com.xforceplus.new20.service.IFulei4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei4前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Fulei4Controller {

  @Autowired
  private IFulei4Service fulei4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei4 fulei4
   * @return
   */
  @GetMapping("/fulei4s" )
  public XfR getFulei4s(XfPage page, Fulei4 fulei4) {
    return XfR.ok(fulei4ServiceImpl.page(page, Wrappers.query(fulei4)));
  }

  /**
   * 通过id查询fulei4
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei4ServiceImpl.getById(id));
  }

  /**
   * 新增fulei4
   * @param fulei4 fulei4
   * @return XfR
   */
  @PostMapping("/fulei4s")
  public XfR save(@RequestBody Fulei4 fulei4) {
     return XfR.ok(fulei4ServiceImpl.save(fulei4));
  }

  /**
   * 修改-传入修改后的全部数据fulei4
   * @param fulei4 fulei4
   * @return XfR
   */
  @PutMapping("/fulei4s/{id}")
  public XfR putUpdate(@RequestBody Fulei4 fulei4,@PathVariable Long id) {
      fulei4.setId(id);
      return XfR.ok(fulei4ServiceImpl.updateById(fulei4));
  }

  /**
   * 修改-传入修改的数据fulei4
   * @param fulei4 fulei4
   * @return XfR
   */
  @PatchMapping("/fulei4s/{id}")
  public XfR patchUpdate(@RequestBody Fulei4 fulei4,@PathVariable Long id) {
      Fulei4 upfulei4 = fulei4ServiceImpl.getById(id);
      if(upfulei4 != null){
        upfulei4 = ObjectCopyUtils.copyProperties(fulei4,upfulei4,true);
      }
      return XfR.ok(fulei4ServiceImpl.updateById(upfulei4));
  }

  /**
   * 通过id删除fulei4
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei4ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei4");
     params.put("request", condition);

     return XfR.ok(fulei4ServiceImpl.querys(params));
  }

}
