package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei5;
import com.xforceplus.new20.service.IFulei5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei5前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Fulei5Controller {

  @Autowired
  private IFulei5Service fulei5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei5 fulei5
   * @return
   */
  @GetMapping("/fulei5s" )
  public XfR getFulei5s(XfPage page, Fulei5 fulei5) {
    return XfR.ok(fulei5ServiceImpl.page(page, Wrappers.query(fulei5)));
  }

  /**
   * 通过id查询fulei5
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei5ServiceImpl.getById(id));
  }

  /**
   * 新增fulei5
   * @param fulei5 fulei5
   * @return XfR
   */
  @PostMapping("/fulei5s")
  public XfR save(@RequestBody Fulei5 fulei5) {
     return XfR.ok(fulei5ServiceImpl.save(fulei5));
  }

  /**
   * 修改-传入修改后的全部数据fulei5
   * @param fulei5 fulei5
   * @return XfR
   */
  @PutMapping("/fulei5s/{id}")
  public XfR putUpdate(@RequestBody Fulei5 fulei5,@PathVariable Long id) {
      fulei5.setId(id);
      return XfR.ok(fulei5ServiceImpl.updateById(fulei5));
  }

  /**
   * 修改-传入修改的数据fulei5
   * @param fulei5 fulei5
   * @return XfR
   */
  @PatchMapping("/fulei5s/{id}")
  public XfR patchUpdate(@RequestBody Fulei5 fulei5,@PathVariable Long id) {
      Fulei5 upfulei5 = fulei5ServiceImpl.getById(id);
      if(upfulei5 != null){
        upfulei5 = ObjectCopyUtils.copyProperties(fulei5,upfulei5,true);
      }
      return XfR.ok(fulei5ServiceImpl.updateById(upfulei5));
  }

  /**
   * 通过id删除fulei5
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei5ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei5");
     params.put("request", condition);

     return XfR.ok(fulei5ServiceImpl.querys(params));
  }

}
