package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei6;
import com.xforceplus.new20.service.IFulei6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * fulei6前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Fulei6Controller {

  @Autowired
  private IFulei6Service fulei6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei6 fulei6
   * @return
   */
  @GetMapping("/fulei6s" )
  public XfR getFulei6s(XfPage page, Fulei6 fulei6) {
    return XfR.ok(fulei6ServiceImpl.page(page, Wrappers.query(fulei6)));
  }

  /**
   * 通过id查询fulei6
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei6ServiceImpl.getById(id));
  }

  /**
   * 新增fulei6
   * @param fulei6 fulei6
   * @return XfR
   */
  @PostMapping("/fulei6s")
  public XfR save(@RequestBody Fulei6 fulei6) {
     return XfR.ok(fulei6ServiceImpl.save(fulei6));
  }

  /**
   * 修改-传入修改后的全部数据fulei6
   * @param fulei6 fulei6
   * @return XfR
   */
  @PutMapping("/fulei6s/{id}")
  public XfR putUpdate(@RequestBody Fulei6 fulei6,@PathVariable Long id) {
      fulei6.setId(id);
      return XfR.ok(fulei6ServiceImpl.updateById(fulei6));
  }

  /**
   * 修改-传入修改的数据fulei6
   * @param fulei6 fulei6
   * @return XfR
   */
  @PatchMapping("/fulei6s/{id}")
  public XfR patchUpdate(@RequestBody Fulei6 fulei6,@PathVariable Long id) {
      Fulei6 upfulei6 = fulei6ServiceImpl.getById(id);
      if(upfulei6 != null){
        upfulei6 = ObjectCopyUtils.copyProperties(fulei6,upfulei6,true);
      }
      return XfR.ok(fulei6ServiceImpl.updateById(upfulei6));
  }

  /**
   * 通过id删除fulei6
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei6ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei6");
     params.put("request", condition);

     return XfR.ok(fulei6ServiceImpl.querys(params));
  }

}
