package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0607001;
import com.xforceplus.new20.service.IOne0607001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0607001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class One0607001Controller {

  @Autowired
  private IOne0607001Service one0607001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0607001 one0607001
   * @return
   */
  @GetMapping("/one0607001s" )
  public XfR getOne0607001s(XfPage page, One0607001 one0607001) {
    return XfR.ok(one0607001ServiceImpl.page(page, Wrappers.query(one0607001)));
  }

  /**
   * 通过id查询one0607001
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0607001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0607001ServiceImpl.getById(id));
  }

  /**
   * 新增one0607001
   * @param one0607001 one0607001
   * @return XfR
   */
  @PostMapping("/one0607001s")
  public XfR save(@RequestBody One0607001 one0607001) {
     return XfR.ok(one0607001ServiceImpl.save(one0607001));
  }

  /**
   * 修改-传入修改后的全部数据one0607001
   * @param one0607001 one0607001
   * @return XfR
   */
  @PutMapping("/one0607001s/{id}")
  public XfR putUpdate(@RequestBody One0607001 one0607001,@PathVariable Long id) {
      one0607001.setId(id);
      return XfR.ok(one0607001ServiceImpl.updateById(one0607001));
  }

  /**
   * 修改-传入修改的数据one0607001
   * @param one0607001 one0607001
   * @return XfR
   */
  @PatchMapping("/one0607001s/{id}")
  public XfR patchUpdate(@RequestBody One0607001 one0607001,@PathVariable Long id) {
      One0607001 upone0607001 = one0607001ServiceImpl.getById(id);
      if(upone0607001 != null){
        upone0607001 = ObjectCopyUtils.copyProperties(one0607001,upone0607001,true);
      }
      return XfR.ok(one0607001ServiceImpl.updateById(upone0607001));
  }

  /**
   * 通过id删除one0607001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0607001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0607001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0607001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0607001");
     params.put("request", condition);

     return XfR.ok(one0607001ServiceImpl.querys(params));
  }

}
