package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0613002;
import com.xforceplus.new20.service.IOne0613002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0613002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class One0613002Controller {

  @Autowired
  private IOne0613002Service one0613002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0613002 one0613002
   * @return
   */
  @GetMapping("/one0613002s" )
  public XfR getOne0613002s(XfPage page, One0613002 one0613002) {
    return XfR.ok(one0613002ServiceImpl.page(page, Wrappers.query(one0613002)));
  }

  /**
   * 通过id查询one0613002
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0613002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0613002ServiceImpl.getById(id));
  }

  /**
   * 新增one0613002
   * @param one0613002 one0613002
   * @return XfR
   */
  @PostMapping("/one0613002s")
  public XfR save(@RequestBody One0613002 one0613002) {
     return XfR.ok(one0613002ServiceImpl.save(one0613002));
  }

  /**
   * 修改-传入修改后的全部数据one0613002
   * @param one0613002 one0613002
   * @return XfR
   */
  @PutMapping("/one0613002s/{id}")
  public XfR putUpdate(@RequestBody One0613002 one0613002,@PathVariable Long id) {
      one0613002.setId(id);
      return XfR.ok(one0613002ServiceImpl.updateById(one0613002));
  }

  /**
   * 修改-传入修改的数据one0613002
   * @param one0613002 one0613002
   * @return XfR
   */
  @PatchMapping("/one0613002s/{id}")
  public XfR patchUpdate(@RequestBody One0613002 one0613002,@PathVariable Long id) {
      One0613002 upone0613002 = one0613002ServiceImpl.getById(id);
      if(upone0613002 != null){
        upone0613002 = ObjectCopyUtils.copyProperties(one0613002,upone0613002,true);
      }
      return XfR.ok(one0613002ServiceImpl.updateById(upone0613002));
  }

  /**
   * 通过id删除one0613002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0613002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0613002ServiceImpl.removeById(id));
  }

  @PostMapping("/one0613002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0613002");
     params.put("request", condition);

     return XfR.ok(one0613002ServiceImpl.querys(params));
  }

}
