package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0625002;
import com.xforceplus.new20.service.IOne0625002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0625002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class One0625002Controller {

  @Autowired
  private IOne0625002Service one0625002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0625002 one0625002
   * @return
   */
  @GetMapping("/one0625002s" )
  public XfR getOne0625002s(XfPage page, One0625002 one0625002) {
    return XfR.ok(one0625002ServiceImpl.page(page, Wrappers.query(one0625002)));
  }

  /**
   * 通过id查询one0625002
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0625002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0625002ServiceImpl.getById(id));
  }

  /**
   * 新增one0625002
   * @param one0625002 one0625002
   * @return XfR
   */
  @PostMapping("/one0625002s")
  public XfR save(@RequestBody One0625002 one0625002) {
     return XfR.ok(one0625002ServiceImpl.save(one0625002));
  }

  /**
   * 修改-传入修改后的全部数据one0625002
   * @param one0625002 one0625002
   * @return XfR
   */
  @PutMapping("/one0625002s/{id}")
  public XfR putUpdate(@RequestBody One0625002 one0625002,@PathVariable Long id) {
      one0625002.setId(id);
      return XfR.ok(one0625002ServiceImpl.updateById(one0625002));
  }

  /**
   * 修改-传入修改的数据one0625002
   * @param one0625002 one0625002
   * @return XfR
   */
  @PatchMapping("/one0625002s/{id}")
  public XfR patchUpdate(@RequestBody One0625002 one0625002,@PathVariable Long id) {
      One0625002 upone0625002 = one0625002ServiceImpl.getById(id);
      if(upone0625002 != null){
        upone0625002 = ObjectCopyUtils.copyProperties(one0625002,upone0625002,true);
      }
      return XfR.ok(one0625002ServiceImpl.updateById(upone0625002));
  }

  /**
   * 通过id删除one0625002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0625002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0625002ServiceImpl.removeById(id));
  }

  @PostMapping("/one0625002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0625002");
     params.put("request", condition);

     return XfR.ok(one0625002ServiceImpl.querys(params));
  }

}
