package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0625005;
import com.xforceplus.new20.service.IOne0625005Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0625005前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class One0625005Controller {

  @Autowired
  private IOne0625005Service one0625005ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0625005 one0625005
   * @return
   */
  @GetMapping("/one0625005s" )
  public XfR getOne0625005s(XfPage page, One0625005 one0625005) {
    return XfR.ok(one0625005ServiceImpl.page(page, Wrappers.query(one0625005)));
  }

  /**
   * 通过id查询one0625005
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0625005s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0625005ServiceImpl.getById(id));
  }

  /**
   * 新增one0625005
   * @param one0625005 one0625005
   * @return XfR
   */
  @PostMapping("/one0625005s")
  public XfR save(@RequestBody One0625005 one0625005) {
     return XfR.ok(one0625005ServiceImpl.save(one0625005));
  }

  /**
   * 修改-传入修改后的全部数据one0625005
   * @param one0625005 one0625005
   * @return XfR
   */
  @PutMapping("/one0625005s/{id}")
  public XfR putUpdate(@RequestBody One0625005 one0625005,@PathVariable Long id) {
      one0625005.setId(id);
      return XfR.ok(one0625005ServiceImpl.updateById(one0625005));
  }

  /**
   * 修改-传入修改的数据one0625005
   * @param one0625005 one0625005
   * @return XfR
   */
  @PatchMapping("/one0625005s/{id}")
  public XfR patchUpdate(@RequestBody One0625005 one0625005,@PathVariable Long id) {
      One0625005 upone0625005 = one0625005ServiceImpl.getById(id);
      if(upone0625005 != null){
        upone0625005 = ObjectCopyUtils.copyProperties(one0625005,upone0625005,true);
      }
      return XfR.ok(one0625005ServiceImpl.updateById(upone0625005));
  }

  /**
   * 通过id删除one0625005
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0625005s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0625005ServiceImpl.removeById(id));
  }

  @PostMapping("/one0625005s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0625005");
     params.put("request", condition);

     return XfR.ok(one0625005ServiceImpl.querys(params));
  }

}
