package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject1;
import com.xforceplus.new20.service.IOneobject1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject1前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Oneobject1Controller {

  @Autowired
  private IOneobject1Service oneobject1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject1 oneobject1
   * @return
   */
  @GetMapping("/oneobject1s" )
  public XfR getOneobject1s(XfPage page, Oneobject1 oneobject1) {
    return XfR.ok(oneobject1ServiceImpl.page(page, Wrappers.query(oneobject1)));
  }

  /**
   * 通过id查询oneobject1
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject1ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject1
   * @param oneobject1 oneobject1
   * @return XfR
   */
  @PostMapping("/oneobject1s")
  public XfR save(@RequestBody Oneobject1 oneobject1) {
     return XfR.ok(oneobject1ServiceImpl.save(oneobject1));
  }

  /**
   * 修改-传入修改后的全部数据oneobject1
   * @param oneobject1 oneobject1
   * @return XfR
   */
  @PutMapping("/oneobject1s/{id}")
  public XfR putUpdate(@RequestBody Oneobject1 oneobject1,@PathVariable Long id) {
      oneobject1.setId(id);
      return XfR.ok(oneobject1ServiceImpl.updateById(oneobject1));
  }

  /**
   * 修改-传入修改的数据oneobject1
   * @param oneobject1 oneobject1
   * @return XfR
   */
  @PatchMapping("/oneobject1s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject1 oneobject1,@PathVariable Long id) {
      Oneobject1 uponeobject1 = oneobject1ServiceImpl.getById(id);
      if(uponeobject1 != null){
        uponeobject1 = ObjectCopyUtils.copyProperties(oneobject1,uponeobject1,true);
      }
      return XfR.ok(oneobject1ServiceImpl.updateById(uponeobject1));
  }

  /**
   * 通过id删除oneobject1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject1ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject1");
     params.put("request", condition);

     return XfR.ok(oneobject1ServiceImpl.querys(params));
  }

}
