package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject2;
import com.xforceplus.new20.service.IOneobject2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject2前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Oneobject2Controller {

  @Autowired
  private IOneobject2Service oneobject2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject2 oneobject2
   * @return
   */
  @GetMapping("/oneobject2s" )
  public XfR getOneobject2s(XfPage page, Oneobject2 oneobject2) {
    return XfR.ok(oneobject2ServiceImpl.page(page, Wrappers.query(oneobject2)));
  }

  /**
   * 通过id查询oneobject2
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject2ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject2
   * @param oneobject2 oneobject2
   * @return XfR
   */
  @PostMapping("/oneobject2s")
  public XfR save(@RequestBody Oneobject2 oneobject2) {
     return XfR.ok(oneobject2ServiceImpl.save(oneobject2));
  }

  /**
   * 修改-传入修改后的全部数据oneobject2
   * @param oneobject2 oneobject2
   * @return XfR
   */
  @PutMapping("/oneobject2s/{id}")
  public XfR putUpdate(@RequestBody Oneobject2 oneobject2,@PathVariable Long id) {
      oneobject2.setId(id);
      return XfR.ok(oneobject2ServiceImpl.updateById(oneobject2));
  }

  /**
   * 修改-传入修改的数据oneobject2
   * @param oneobject2 oneobject2
   * @return XfR
   */
  @PatchMapping("/oneobject2s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject2 oneobject2,@PathVariable Long id) {
      Oneobject2 uponeobject2 = oneobject2ServiceImpl.getById(id);
      if(uponeobject2 != null){
        uponeobject2 = ObjectCopyUtils.copyProperties(oneobject2,uponeobject2,true);
      }
      return XfR.ok(oneobject2ServiceImpl.updateById(uponeobject2));
  }

  /**
   * 通过id删除oneobject2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject2ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject2");
     params.put("request", condition);

     return XfR.ok(oneobject2ServiceImpl.querys(params));
  }

}
