package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject3;
import com.xforceplus.new20.service.IOneobject3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject3前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Oneobject3Controller {

  @Autowired
  private IOneobject3Service oneobject3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject3 oneobject3
   * @return
   */
  @GetMapping("/oneobject3s" )
  public XfR getOneobject3s(XfPage page, Oneobject3 oneobject3) {
    return XfR.ok(oneobject3ServiceImpl.page(page, Wrappers.query(oneobject3)));
  }

  /**
   * 通过id查询oneobject3
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject3ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject3
   * @param oneobject3 oneobject3
   * @return XfR
   */
  @PostMapping("/oneobject3s")
  public XfR save(@RequestBody Oneobject3 oneobject3) {
     return XfR.ok(oneobject3ServiceImpl.save(oneobject3));
  }

  /**
   * 修改-传入修改后的全部数据oneobject3
   * @param oneobject3 oneobject3
   * @return XfR
   */
  @PutMapping("/oneobject3s/{id}")
  public XfR putUpdate(@RequestBody Oneobject3 oneobject3,@PathVariable Long id) {
      oneobject3.setId(id);
      return XfR.ok(oneobject3ServiceImpl.updateById(oneobject3));
  }

  /**
   * 修改-传入修改的数据oneobject3
   * @param oneobject3 oneobject3
   * @return XfR
   */
  @PatchMapping("/oneobject3s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject3 oneobject3,@PathVariable Long id) {
      Oneobject3 uponeobject3 = oneobject3ServiceImpl.getById(id);
      if(uponeobject3 != null){
        uponeobject3 = ObjectCopyUtils.copyProperties(oneobject3,uponeobject3,true);
      }
      return XfR.ok(oneobject3ServiceImpl.updateById(uponeobject3));
  }

  /**
   * 通过id删除oneobject3
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject3ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject3");
     params.put("request", condition);

     return XfR.ok(oneobject3ServiceImpl.querys(params));
  }

}
