package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject4;
import com.xforceplus.new20.service.IOneobject4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject4前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Oneobject4Controller {

  @Autowired
  private IOneobject4Service oneobject4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject4 oneobject4
   * @return
   */
  @GetMapping("/oneobject4s" )
  public XfR getOneobject4s(XfPage page, Oneobject4 oneobject4) {
    return XfR.ok(oneobject4ServiceImpl.page(page, Wrappers.query(oneobject4)));
  }

  /**
   * 通过id查询oneobject4
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject4ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject4
   * @param oneobject4 oneobject4
   * @return XfR
   */
  @PostMapping("/oneobject4s")
  public XfR save(@RequestBody Oneobject4 oneobject4) {
     return XfR.ok(oneobject4ServiceImpl.save(oneobject4));
  }

  /**
   * 修改-传入修改后的全部数据oneobject4
   * @param oneobject4 oneobject4
   * @return XfR
   */
  @PutMapping("/oneobject4s/{id}")
  public XfR putUpdate(@RequestBody Oneobject4 oneobject4,@PathVariable Long id) {
      oneobject4.setId(id);
      return XfR.ok(oneobject4ServiceImpl.updateById(oneobject4));
  }

  /**
   * 修改-传入修改的数据oneobject4
   * @param oneobject4 oneobject4
   * @return XfR
   */
  @PatchMapping("/oneobject4s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject4 oneobject4,@PathVariable Long id) {
      Oneobject4 uponeobject4 = oneobject4ServiceImpl.getById(id);
      if(uponeobject4 != null){
        uponeobject4 = ObjectCopyUtils.copyProperties(oneobject4,uponeobject4,true);
      }
      return XfR.ok(oneobject4ServiceImpl.updateById(uponeobject4));
  }

  /**
   * 通过id删除oneobject4
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject4ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject4");
     params.put("request", condition);

     return XfR.ok(oneobject4ServiceImpl.querys(params));
  }

}
