package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject8;
import com.xforceplus.new20.service.IOneobject8Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * oneobject8前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Oneobject8Controller {

  @Autowired
  private IOneobject8Service oneobject8ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject8 oneobject8
   * @return
   */
  @GetMapping("/oneobject8s" )
  public XfR getOneobject8s(XfPage page, Oneobject8 oneobject8) {
    return XfR.ok(oneobject8ServiceImpl.page(page, Wrappers.query(oneobject8)));
  }

  /**
   * 通过id查询oneobject8
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject8s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject8ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject8
   * @param oneobject8 oneobject8
   * @return XfR
   */
  @PostMapping("/oneobject8s")
  public XfR save(@RequestBody Oneobject8 oneobject8) {
     return XfR.ok(oneobject8ServiceImpl.save(oneobject8));
  }

  /**
   * 修改-传入修改后的全部数据oneobject8
   * @param oneobject8 oneobject8
   * @return XfR
   */
  @PutMapping("/oneobject8s/{id}")
  public XfR putUpdate(@RequestBody Oneobject8 oneobject8,@PathVariable Long id) {
      oneobject8.setId(id);
      return XfR.ok(oneobject8ServiceImpl.updateById(oneobject8));
  }

  /**
   * 修改-传入修改的数据oneobject8
   * @param oneobject8 oneobject8
   * @return XfR
   */
  @PatchMapping("/oneobject8s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject8 oneobject8,@PathVariable Long id) {
      Oneobject8 uponeobject8 = oneobject8ServiceImpl.getById(id);
      if(uponeobject8 != null){
        uponeobject8 = ObjectCopyUtils.copyProperties(oneobject8,uponeobject8,true);
      }
      return XfR.ok(oneobject8ServiceImpl.updateById(uponeobject8));
  }

  /**
   * 通过id删除oneobject8
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject8s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject8ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject8s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject8");
     params.put("request", condition);

     return XfR.ok(oneobject8ServiceImpl.querys(params));
  }

}
