package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Parent1;
import com.xforceplus.new20.service.IParent1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zzzz前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Parent1Controller {

  @Autowired
  private IParent1Service parent1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parent1 zzzz
   * @return
   */
  @GetMapping("/parent1s" )
  public XfR getParent1s(XfPage page, Parent1 parent1) {
    return XfR.ok(parent1ServiceImpl.page(page, Wrappers.query(parent1)));
  }

  /**
   * 通过id查询zzzz
   * @param  id
   * @return XfR
   */
  @GetMapping("/parent1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parent1ServiceImpl.getById(id));
  }

  /**
   * 新增zzzz
   * @param parent1 zzzz
   * @return XfR
   */
  @PostMapping("/parent1s")
  public XfR save(@RequestBody Parent1 parent1) {
     return XfR.ok(parent1ServiceImpl.save(parent1));
  }

  /**
   * 修改-传入修改后的全部数据zzzz
   * @param parent1 zzzz
   * @return XfR
   */
  @PutMapping("/parent1s/{id}")
  public XfR putUpdate(@RequestBody Parent1 parent1,@PathVariable Long id) {
      parent1.setId(id);
      return XfR.ok(parent1ServiceImpl.updateById(parent1));
  }

  /**
   * 修改-传入修改的数据zzzz
   * @param parent1 zzzz
   * @return XfR
   */
  @PatchMapping("/parent1s/{id}")
  public XfR patchUpdate(@RequestBody Parent1 parent1,@PathVariable Long id) {
      Parent1 upparent1 = parent1ServiceImpl.getById(id);
      if(upparent1 != null){
        upparent1 = ObjectCopyUtils.copyProperties(parent1,upparent1,true);
      }
      return XfR.ok(parent1ServiceImpl.updateById(upparent1));
  }

  /**
   * 通过id删除zzzz
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parent1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parent1ServiceImpl.removeById(id));
  }

  @PostMapping("/parent1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent1");
     params.put("request", condition);

     return XfR.ok(parent1ServiceImpl.querys(params));
  }

}
