package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Relation0526003;
import com.xforceplus.new20.service.IRelation0526003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * relation0526003前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Relation0526003Controller {

  @Autowired
  private IRelation0526003Service relation0526003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param relation0526003 relation0526003
   * @return
   */
  @GetMapping("/relation0526003s" )
  public XfR getRelation0526003s(XfPage page, Relation0526003 relation0526003) {
    return XfR.ok(relation0526003ServiceImpl.page(page, Wrappers.query(relation0526003)));
  }

  /**
   * 通过id查询relation0526003
   * @param  id
   * @return XfR
   */
  @GetMapping("/relation0526003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(relation0526003ServiceImpl.getById(id));
  }

  /**
   * 新增relation0526003
   * @param relation0526003 relation0526003
   * @return XfR
   */
  @PostMapping("/relation0526003s")
  public XfR save(@RequestBody Relation0526003 relation0526003) {
     return XfR.ok(relation0526003ServiceImpl.save(relation0526003));
  }

  /**
   * 修改-传入修改后的全部数据relation0526003
   * @param relation0526003 relation0526003
   * @return XfR
   */
  @PutMapping("/relation0526003s/{id}")
  public XfR putUpdate(@RequestBody Relation0526003 relation0526003,@PathVariable Long id) {
      relation0526003.setId(id);
      return XfR.ok(relation0526003ServiceImpl.updateById(relation0526003));
  }

  /**
   * 修改-传入修改的数据relation0526003
   * @param relation0526003 relation0526003
   * @return XfR
   */
  @PatchMapping("/relation0526003s/{id}")
  public XfR patchUpdate(@RequestBody Relation0526003 relation0526003,@PathVariable Long id) {
      Relation0526003 uprelation0526003 = relation0526003ServiceImpl.getById(id);
      if(uprelation0526003 != null){
        uprelation0526003 = ObjectCopyUtils.copyProperties(relation0526003,uprelation0526003,true);
      }
      return XfR.ok(relation0526003ServiceImpl.updateById(uprelation0526003));
  }

  /**
   * 通过id删除relation0526003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/relation0526003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(relation0526003ServiceImpl.removeById(id));
  }

  @PostMapping("/relation0526003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "relation0526003");
     params.put("request", condition);

     return XfR.ok(relation0526003ServiceImpl.querys(params));
  }

}
