package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0605002;
import com.xforceplus.new20.service.ITest0605002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0605002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0605002Controller {

  @Autowired
  private ITest0605002Service test0605002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0605002 test0605002
   * @return
   */
  @GetMapping("/test0605002s" )
  public XfR getTest0605002s(XfPage page, Test0605002 test0605002) {
    return XfR.ok(test0605002ServiceImpl.page(page, Wrappers.query(test0605002)));
  }

  /**
   * 通过id查询test0605002
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0605002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0605002ServiceImpl.getById(id));
  }

  /**
   * 新增test0605002
   * @param test0605002 test0605002
   * @return XfR
   */
  @PostMapping("/test0605002s")
  public XfR save(@RequestBody Test0605002 test0605002) {
     return XfR.ok(test0605002ServiceImpl.save(test0605002));
  }

  /**
   * 修改-传入修改后的全部数据test0605002
   * @param test0605002 test0605002
   * @return XfR
   */
  @PutMapping("/test0605002s/{id}")
  public XfR putUpdate(@RequestBody Test0605002 test0605002,@PathVariable Long id) {
      test0605002.setId(id);
      return XfR.ok(test0605002ServiceImpl.updateById(test0605002));
  }

  /**
   * 修改-传入修改的数据test0605002
   * @param test0605002 test0605002
   * @return XfR
   */
  @PatchMapping("/test0605002s/{id}")
  public XfR patchUpdate(@RequestBody Test0605002 test0605002,@PathVariable Long id) {
      Test0605002 uptest0605002 = test0605002ServiceImpl.getById(id);
      if(uptest0605002 != null){
        uptest0605002 = ObjectCopyUtils.copyProperties(test0605002,uptest0605002,true);
      }
      return XfR.ok(test0605002ServiceImpl.updateById(uptest0605002));
  }

  /**
   * 通过id删除test0605002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0605002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0605002ServiceImpl.removeById(id));
  }

  @PostMapping("/test0605002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0605002");
     params.put("request", condition);

     return XfR.ok(test0605002ServiceImpl.querys(params));
  }

}
