package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0622001;
import com.xforceplus.new20.service.ITest0622001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0622001Controller {

  @Autowired
  private ITest0622001Service test0622001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0622001 ${table.comment}
   * @return
   */
  @GetMapping("/test0622001s" )
  public XfR getTest0622001s(XfPage page, Test0622001 test0622001) {
    return XfR.ok(test0622001ServiceImpl.page(page, Wrappers.query(test0622001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0622001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0622001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0622001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0622001s")
  public XfR save(@RequestBody Test0622001 test0622001) {
     return XfR.ok(test0622001ServiceImpl.save(test0622001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0622001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0622001s/{id}")
  public XfR putUpdate(@RequestBody Test0622001 test0622001,@PathVariable Long id) {
      test0622001.setId(id);
      return XfR.ok(test0622001ServiceImpl.updateById(test0622001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0622001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0622001s/{id}")
  public XfR patchUpdate(@RequestBody Test0622001 test0622001,@PathVariable Long id) {
      Test0622001 uptest0622001 = test0622001ServiceImpl.getById(id);
      if(uptest0622001 != null){
        uptest0622001 = ObjectCopyUtils.copyProperties(test0622001,uptest0622001,true);
      }
      return XfR.ok(test0622001ServiceImpl.updateById(uptest0622001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0622001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0622001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0622001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0622001");
     params.put("request", condition);

     return XfR.ok(test0622001ServiceImpl.querys(params));
  }

}
