package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0719002;
import com.xforceplus.new20.service.ITest0719002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0719002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0719002Controller {

  @Autowired
  private ITest0719002Service test0719002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0719002 test0719002
   * @return
   */
  @GetMapping("/test0719002s" )
  public XfR getTest0719002s(XfPage page, Test0719002 test0719002) {
    return XfR.ok(test0719002ServiceImpl.page(page, Wrappers.query(test0719002)));
  }

  /**
   * 通过id查询test0719002
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0719002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0719002ServiceImpl.getById(id));
  }

  /**
   * 新增test0719002
   * @param test0719002 test0719002
   * @return XfR
   */
  @PostMapping("/test0719002s")
  public XfR save(@RequestBody Test0719002 test0719002) {
     return XfR.ok(test0719002ServiceImpl.save(test0719002));
  }

  /**
   * 修改-传入修改后的全部数据test0719002
   * @param test0719002 test0719002
   * @return XfR
   */
  @PutMapping("/test0719002s/{id}")
  public XfR putUpdate(@RequestBody Test0719002 test0719002,@PathVariable Long id) {
      test0719002.setId(id);
      return XfR.ok(test0719002ServiceImpl.updateById(test0719002));
  }

  /**
   * 修改-传入修改的数据test0719002
   * @param test0719002 test0719002
   * @return XfR
   */
  @PatchMapping("/test0719002s/{id}")
  public XfR patchUpdate(@RequestBody Test0719002 test0719002,@PathVariable Long id) {
      Test0719002 uptest0719002 = test0719002ServiceImpl.getById(id);
      if(uptest0719002 != null){
        uptest0719002 = ObjectCopyUtils.copyProperties(test0719002,uptest0719002,true);
      }
      return XfR.ok(test0719002ServiceImpl.updateById(uptest0719002));
  }

  /**
   * 通过id删除test0719002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0719002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0719002ServiceImpl.removeById(id));
  }

  @PostMapping("/test0719002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0719002");
     params.put("request", condition);

     return XfR.ok(test0719002ServiceImpl.querys(params));
  }

}
