package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0719004x;
import com.xforceplus.new20.service.ITest0719004xService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0719004xController {

  @Autowired
  private ITest0719004xService test0719004xServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0719004x ${table.comment}
   * @return
   */
  @GetMapping("/test0719004xs" )
  public XfR getTest0719004xs(XfPage page, Test0719004x test0719004x) {
    return XfR.ok(test0719004xServiceImpl.page(page, Wrappers.query(test0719004x)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0719004xs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0719004xServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0719004x ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0719004xs")
  public XfR save(@RequestBody Test0719004x test0719004x) {
     return XfR.ok(test0719004xServiceImpl.save(test0719004x));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0719004x ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0719004xs/{id}")
  public XfR putUpdate(@RequestBody Test0719004x test0719004x,@PathVariable Long id) {
      test0719004x.setId(id);
      return XfR.ok(test0719004xServiceImpl.updateById(test0719004x));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0719004x ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0719004xs/{id}")
  public XfR patchUpdate(@RequestBody Test0719004x test0719004x,@PathVariable Long id) {
      Test0719004x uptest0719004x = test0719004xServiceImpl.getById(id);
      if(uptest0719004x != null){
        uptest0719004x = ObjectCopyUtils.copyProperties(test0719004x,uptest0719004x,true);
      }
      return XfR.ok(test0719004xServiceImpl.updateById(uptest0719004x));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0719004xs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0719004xServiceImpl.removeById(id));
  }

  @PostMapping("/test0719004xs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0719004x");
     params.put("request", condition);

     return XfR.ok(test0719004xServiceImpl.querys(params));
  }

}
