package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0731002;
import com.xforceplus.new20.service.ITest0731002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0731002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0731002Controller {

  @Autowired
  private ITest0731002Service test0731002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0731002 test0731002
   * @return
   */
  @GetMapping("/test0731002s" )
  public XfR getTest0731002s(XfPage page, Test0731002 test0731002) {
    return XfR.ok(test0731002ServiceImpl.page(page, Wrappers.query(test0731002)));
  }

  /**
   * 通过id查询test0731002
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0731002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0731002ServiceImpl.getById(id));
  }

  /**
   * 新增test0731002
   * @param test0731002 test0731002
   * @return XfR
   */
  @PostMapping("/test0731002s")
  public XfR save(@RequestBody Test0731002 test0731002) {
     return XfR.ok(test0731002ServiceImpl.save(test0731002));
  }

  /**
   * 修改-传入修改后的全部数据test0731002
   * @param test0731002 test0731002
   * @return XfR
   */
  @PutMapping("/test0731002s/{id}")
  public XfR putUpdate(@RequestBody Test0731002 test0731002,@PathVariable Long id) {
      test0731002.setId(id);
      return XfR.ok(test0731002ServiceImpl.updateById(test0731002));
  }

  /**
   * 修改-传入修改的数据test0731002
   * @param test0731002 test0731002
   * @return XfR
   */
  @PatchMapping("/test0731002s/{id}")
  public XfR patchUpdate(@RequestBody Test0731002 test0731002,@PathVariable Long id) {
      Test0731002 uptest0731002 = test0731002ServiceImpl.getById(id);
      if(uptest0731002 != null){
        uptest0731002 = ObjectCopyUtils.copyProperties(test0731002,uptest0731002,true);
      }
      return XfR.ok(test0731002ServiceImpl.updateById(uptest0731002));
  }

  /**
   * 通过id删除test0731002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0731002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0731002ServiceImpl.removeById(id));
  }

  @PostMapping("/test0731002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0731002");
     params.put("request", condition);

     return XfR.ok(test0731002ServiceImpl.querys(params));
  }

}
