package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test080001001;
import com.xforceplus.new20.service.ITest080001001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test080001001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test080001001Controller {

  @Autowired
  private ITest080001001Service test080001001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test080001001 test080001001
   * @return
   */
  @GetMapping("/test080001001s" )
  public XfR getTest080001001s(XfPage page, Test080001001 test080001001) {
    return XfR.ok(test080001001ServiceImpl.page(page, Wrappers.query(test080001001)));
  }

  /**
   * 通过id查询test080001001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test080001001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test080001001ServiceImpl.getById(id));
  }

  /**
   * 新增test080001001
   * @param test080001001 test080001001
   * @return XfR
   */
  @PostMapping("/test080001001s")
  public XfR save(@RequestBody Test080001001 test080001001) {
     return XfR.ok(test080001001ServiceImpl.save(test080001001));
  }

  /**
   * 修改-传入修改后的全部数据test080001001
   * @param test080001001 test080001001
   * @return XfR
   */
  @PutMapping("/test080001001s/{id}")
  public XfR putUpdate(@RequestBody Test080001001 test080001001,@PathVariable Long id) {
      test080001001.setId(id);
      return XfR.ok(test080001001ServiceImpl.updateById(test080001001));
  }

  /**
   * 修改-传入修改的数据test080001001
   * @param test080001001 test080001001
   * @return XfR
   */
  @PatchMapping("/test080001001s/{id}")
  public XfR patchUpdate(@RequestBody Test080001001 test080001001,@PathVariable Long id) {
      Test080001001 uptest080001001 = test080001001ServiceImpl.getById(id);
      if(uptest080001001 != null){
        uptest080001001 = ObjectCopyUtils.copyProperties(test080001001,uptest080001001,true);
      }
      return XfR.ok(test080001001ServiceImpl.updateById(uptest080001001));
  }

  /**
   * 通过id删除test080001001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test080001001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test080001001ServiceImpl.removeById(id));
  }

  @PostMapping("/test080001001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test080001001");
     params.put("request", condition);

     return XfR.ok(test080001001ServiceImpl.querys(params));
  }

}
