package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test080001003;
import com.xforceplus.new20.service.ITest080001003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test080001003前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test080001003Controller {

  @Autowired
  private ITest080001003Service test080001003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test080001003 test080001003
   * @return
   */
  @GetMapping("/test080001003s" )
  public XfR getTest080001003s(XfPage page, Test080001003 test080001003) {
    return XfR.ok(test080001003ServiceImpl.page(page, Wrappers.query(test080001003)));
  }

  /**
   * 通过id查询test080001003
   * @param  id
   * @return XfR
   */
  @GetMapping("/test080001003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test080001003ServiceImpl.getById(id));
  }

  /**
   * 新增test080001003
   * @param test080001003 test080001003
   * @return XfR
   */
  @PostMapping("/test080001003s")
  public XfR save(@RequestBody Test080001003 test080001003) {
     return XfR.ok(test080001003ServiceImpl.save(test080001003));
  }

  /**
   * 修改-传入修改后的全部数据test080001003
   * @param test080001003 test080001003
   * @return XfR
   */
  @PutMapping("/test080001003s/{id}")
  public XfR putUpdate(@RequestBody Test080001003 test080001003,@PathVariable Long id) {
      test080001003.setId(id);
      return XfR.ok(test080001003ServiceImpl.updateById(test080001003));
  }

  /**
   * 修改-传入修改的数据test080001003
   * @param test080001003 test080001003
   * @return XfR
   */
  @PatchMapping("/test080001003s/{id}")
  public XfR patchUpdate(@RequestBody Test080001003 test080001003,@PathVariable Long id) {
      Test080001003 uptest080001003 = test080001003ServiceImpl.getById(id);
      if(uptest080001003 != null){
        uptest080001003 = ObjectCopyUtils.copyProperties(test080001003,uptest080001003,true);
      }
      return XfR.ok(test080001003ServiceImpl.updateById(uptest080001003));
  }

  /**
   * 通过id删除test080001003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test080001003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test080001003ServiceImpl.removeById(id));
  }

  @PostMapping("/test080001003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test080001003");
     params.put("request", condition);

     return XfR.ok(test080001003ServiceImpl.querys(params));
  }

}
