package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0801001;
import com.xforceplus.new20.service.ITest0801001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0801001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0801001Controller {

  @Autowired
  private ITest0801001Service test0801001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0801001 test0801001
   * @return
   */
  @GetMapping("/test0801001s" )
  public XfR getTest0801001s(XfPage page, Test0801001 test0801001) {
    return XfR.ok(test0801001ServiceImpl.page(page, Wrappers.query(test0801001)));
  }

  /**
   * 通过id查询test0801001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0801001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0801001ServiceImpl.getById(id));
  }

  /**
   * 新增test0801001
   * @param test0801001 test0801001
   * @return XfR
   */
  @PostMapping("/test0801001s")
  public XfR save(@RequestBody Test0801001 test0801001) {
     return XfR.ok(test0801001ServiceImpl.save(test0801001));
  }

  /**
   * 修改-传入修改后的全部数据test0801001
   * @param test0801001 test0801001
   * @return XfR
   */
  @PutMapping("/test0801001s/{id}")
  public XfR putUpdate(@RequestBody Test0801001 test0801001,@PathVariable Long id) {
      test0801001.setId(id);
      return XfR.ok(test0801001ServiceImpl.updateById(test0801001));
  }

  /**
   * 修改-传入修改的数据test0801001
   * @param test0801001 test0801001
   * @return XfR
   */
  @PatchMapping("/test0801001s/{id}")
  public XfR patchUpdate(@RequestBody Test0801001 test0801001,@PathVariable Long id) {
      Test0801001 uptest0801001 = test0801001ServiceImpl.getById(id);
      if(uptest0801001 != null){
        uptest0801001 = ObjectCopyUtils.copyProperties(test0801001,uptest0801001,true);
      }
      return XfR.ok(test0801001ServiceImpl.updateById(uptest0801001));
  }

  /**
   * 通过id删除test0801001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0801001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0801001ServiceImpl.removeById(id));
  }

  @PostMapping("/test0801001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0801001");
     params.put("request", condition);

     return XfR.ok(test0801001ServiceImpl.querys(params));
  }

}
