package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test0801003;
import com.xforceplus.new20.service.ITest0801003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0801003前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test0801003Controller {

  @Autowired
  private ITest0801003Service test0801003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0801003 test0801003
   * @return
   */
  @GetMapping("/test0801003s" )
  public XfR getTest0801003s(XfPage page, Test0801003 test0801003) {
    return XfR.ok(test0801003ServiceImpl.page(page, Wrappers.query(test0801003)));
  }

  /**
   * 通过id查询test0801003
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0801003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0801003ServiceImpl.getById(id));
  }

  /**
   * 新增test0801003
   * @param test0801003 test0801003
   * @return XfR
   */
  @PostMapping("/test0801003s")
  public XfR save(@RequestBody Test0801003 test0801003) {
     return XfR.ok(test0801003ServiceImpl.save(test0801003));
  }

  /**
   * 修改-传入修改后的全部数据test0801003
   * @param test0801003 test0801003
   * @return XfR
   */
  @PutMapping("/test0801003s/{id}")
  public XfR putUpdate(@RequestBody Test0801003 test0801003,@PathVariable Long id) {
      test0801003.setId(id);
      return XfR.ok(test0801003ServiceImpl.updateById(test0801003));
  }

  /**
   * 修改-传入修改的数据test0801003
   * @param test0801003 test0801003
   * @return XfR
   */
  @PatchMapping("/test0801003s/{id}")
  public XfR patchUpdate(@RequestBody Test0801003 test0801003,@PathVariable Long id) {
      Test0801003 uptest0801003 = test0801003ServiceImpl.getById(id);
      if(uptest0801003 != null){
        uptest0801003 = ObjectCopyUtils.copyProperties(test0801003,uptest0801003,true);
      }
      return XfR.ok(test0801003ServiceImpl.updateById(uptest0801003));
  }

  /**
   * 通过id删除test0801003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0801003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0801003ServiceImpl.removeById(id));
  }

  @PostMapping("/test0801003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0801003");
     params.put("request", condition);

     return XfR.ok(test0801003ServiceImpl.querys(params));
  }

}
