package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Test1;
import com.xforceplus.new20.service.ITest1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Test1Controller {

  @Autowired
  private ITest1Service test1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test1 ${table.comment}
   * @return
   */
  @GetMapping("/test1s" )
  public XfR getTest1s(XfPage page, Test1 test1) {
    return XfR.ok(test1ServiceImpl.page(page, Wrappers.query(test1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test1s")
  public XfR save(@RequestBody Test1 test1) {
     return XfR.ok(test1ServiceImpl.save(test1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test1s/{id}")
  public XfR putUpdate(@RequestBody Test1 test1,@PathVariable Long id) {
      test1.setId(id);
      return XfR.ok(test1ServiceImpl.updateById(test1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test1s/{id}")
  public XfR patchUpdate(@RequestBody Test1 test1,@PathVariable Long id) {
      Test1 uptest1 = test1ServiceImpl.getById(id);
      if(uptest1 != null){
        uptest1 = ObjectCopyUtils.copyProperties(test1,uptest1,true);
      }
      return XfR.ok(test1ServiceImpl.updateById(uptest1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test1ServiceImpl.removeById(id));
  }

  @PostMapping("/test1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test1");
     params.put("request", condition);

     return XfR.ok(test1ServiceImpl.querys(params));
  }

}
