package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Three0607001;
import com.xforceplus.new20.service.IThree0607001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * three0607001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Three0607001Controller {

  @Autowired
  private IThree0607001Service three0607001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param three0607001 three0607001
   * @return
   */
  @GetMapping("/three0607001s" )
  public XfR getThree0607001s(XfPage page, Three0607001 three0607001) {
    return XfR.ok(three0607001ServiceImpl.page(page, Wrappers.query(three0607001)));
  }

  /**
   * 通过id查询three0607001
   * @param  id
   * @return XfR
   */
  @GetMapping("/three0607001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(three0607001ServiceImpl.getById(id));
  }

  /**
   * 新增three0607001
   * @param three0607001 three0607001
   * @return XfR
   */
  @PostMapping("/three0607001s")
  public XfR save(@RequestBody Three0607001 three0607001) {
     return XfR.ok(three0607001ServiceImpl.save(three0607001));
  }

  /**
   * 修改-传入修改后的全部数据three0607001
   * @param three0607001 three0607001
   * @return XfR
   */
  @PutMapping("/three0607001s/{id}")
  public XfR putUpdate(@RequestBody Three0607001 three0607001,@PathVariable Long id) {
      three0607001.setId(id);
      return XfR.ok(three0607001ServiceImpl.updateById(three0607001));
  }

  /**
   * 修改-传入修改的数据three0607001
   * @param three0607001 three0607001
   * @return XfR
   */
  @PatchMapping("/three0607001s/{id}")
  public XfR patchUpdate(@RequestBody Three0607001 three0607001,@PathVariable Long id) {
      Three0607001 upthree0607001 = three0607001ServiceImpl.getById(id);
      if(upthree0607001 != null){
        upthree0607001 = ObjectCopyUtils.copyProperties(three0607001,upthree0607001,true);
      }
      return XfR.ok(three0607001ServiceImpl.updateById(upthree0607001));
  }

  /**
   * 通过id删除three0607001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/three0607001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(three0607001ServiceImpl.removeById(id));
  }

  @PostMapping("/three0607001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "three0607001");
     params.put("request", condition);

     return XfR.ok(three0607001ServiceImpl.querys(params));
  }

}
