package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Yace002;
import com.xforceplus.new20.service.IYace002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * yace002前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Yace002Controller {

  @Autowired
  private IYace002Service yace002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yace002 yace002
   * @return
   */
  @GetMapping("/yace002s" )
  public XfR getYace002s(XfPage page, Yace002 yace002) {
    return XfR.ok(yace002ServiceImpl.page(page, Wrappers.query(yace002)));
  }

  /**
   * 通过id查询yace002
   * @param  id
   * @return XfR
   */
  @GetMapping("/yace002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yace002ServiceImpl.getById(id));
  }

  /**
   * 新增yace002
   * @param yace002 yace002
   * @return XfR
   */
  @PostMapping("/yace002s")
  public XfR save(@RequestBody Yace002 yace002) {
     return XfR.ok(yace002ServiceImpl.save(yace002));
  }

  /**
   * 修改-传入修改后的全部数据yace002
   * @param yace002 yace002
   * @return XfR
   */
  @PutMapping("/yace002s/{id}")
  public XfR putUpdate(@RequestBody Yace002 yace002,@PathVariable Long id) {
      yace002.setId(id);
      return XfR.ok(yace002ServiceImpl.updateById(yace002));
  }

  /**
   * 修改-传入修改的数据yace002
   * @param yace002 yace002
   * @return XfR
   */
  @PatchMapping("/yace002s/{id}")
  public XfR patchUpdate(@RequestBody Yace002 yace002,@PathVariable Long id) {
      Yace002 upyace002 = yace002ServiceImpl.getById(id);
      if(upyace002 != null){
        upyace002 = ObjectCopyUtils.copyProperties(yace002,upyace002,true);
      }
      return XfR.ok(yace002ServiceImpl.updateById(upyace002));
  }

  /**
   * 通过id删除yace002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yace002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yace002ServiceImpl.removeById(id));
  }

  @PostMapping("/yace002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yace002");
     params.put("request", condition);

     return XfR.ok(yace002ServiceImpl.querys(params));
  }

}
