package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Yi0523001;
import com.xforceplus.new20.service.IYi0523001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * yi0523001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Yi0523001Controller {

  @Autowired
  private IYi0523001Service yi0523001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yi0523001 yi0523001
   * @return
   */
  @GetMapping("/yi0523001s" )
  public XfR getYi0523001s(XfPage page, Yi0523001 yi0523001) {
    return XfR.ok(yi0523001ServiceImpl.page(page, Wrappers.query(yi0523001)));
  }

  /**
   * 通过id查询yi0523001
   * @param  id
   * @return XfR
   */
  @GetMapping("/yi0523001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yi0523001ServiceImpl.getById(id));
  }

  /**
   * 新增yi0523001
   * @param yi0523001 yi0523001
   * @return XfR
   */
  @PostMapping("/yi0523001s")
  public XfR save(@RequestBody Yi0523001 yi0523001) {
     return XfR.ok(yi0523001ServiceImpl.save(yi0523001));
  }

  /**
   * 修改-传入修改后的全部数据yi0523001
   * @param yi0523001 yi0523001
   * @return XfR
   */
  @PutMapping("/yi0523001s/{id}")
  public XfR putUpdate(@RequestBody Yi0523001 yi0523001,@PathVariable Long id) {
      yi0523001.setId(id);
      return XfR.ok(yi0523001ServiceImpl.updateById(yi0523001));
  }

  /**
   * 修改-传入修改的数据yi0523001
   * @param yi0523001 yi0523001
   * @return XfR
   */
  @PatchMapping("/yi0523001s/{id}")
  public XfR patchUpdate(@RequestBody Yi0523001 yi0523001,@PathVariable Long id) {
      Yi0523001 upyi0523001 = yi0523001ServiceImpl.getById(id);
      if(upyi0523001 != null){
        upyi0523001 = ObjectCopyUtils.copyProperties(yi0523001,upyi0523001,true);
      }
      return XfR.ok(yi0523001ServiceImpl.updateById(upyi0523001));
  }

  /**
   * 通过id删除yi0523001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yi0523001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yi0523001ServiceImpl.removeById(id));
  }

  @PostMapping("/yi0523001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yi0523001");
     params.put("request", condition);

     return XfR.ok(yi0523001ServiceImpl.querys(params));
  }

}
