package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei051801;
import com.xforceplus.new20.service.IZilei051801Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei051801前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei051801Controller {

  @Autowired
  private IZilei051801Service zilei051801ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei051801 zilei051801
   * @return
   */
  @GetMapping("/zilei051801s" )
  public XfR getZilei051801s(XfPage page, Zilei051801 zilei051801) {
    return XfR.ok(zilei051801ServiceImpl.page(page, Wrappers.query(zilei051801)));
  }

  /**
   * 通过id查询zilei051801
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei051801s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei051801ServiceImpl.getById(id));
  }

  /**
   * 新增zilei051801
   * @param zilei051801 zilei051801
   * @return XfR
   */
  @PostMapping("/zilei051801s")
  public XfR save(@RequestBody Zilei051801 zilei051801) {
     return XfR.ok(zilei051801ServiceImpl.save(zilei051801));
  }

  /**
   * 修改-传入修改后的全部数据zilei051801
   * @param zilei051801 zilei051801
   * @return XfR
   */
  @PutMapping("/zilei051801s/{id}")
  public XfR putUpdate(@RequestBody Zilei051801 zilei051801,@PathVariable Long id) {
      zilei051801.setId(id);
      return XfR.ok(zilei051801ServiceImpl.updateById(zilei051801));
  }

  /**
   * 修改-传入修改的数据zilei051801
   * @param zilei051801 zilei051801
   * @return XfR
   */
  @PatchMapping("/zilei051801s/{id}")
  public XfR patchUpdate(@RequestBody Zilei051801 zilei051801,@PathVariable Long id) {
      Zilei051801 upzilei051801 = zilei051801ServiceImpl.getById(id);
      if(upzilei051801 != null){
        upzilei051801 = ObjectCopyUtils.copyProperties(zilei051801,upzilei051801,true);
      }
      return XfR.ok(zilei051801ServiceImpl.updateById(upzilei051801));
  }

  /**
   * 通过id删除zilei051801
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei051801s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei051801ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei051801s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei051801");
     params.put("request", condition);

     return XfR.ok(zilei051801ServiceImpl.querys(params));
  }

}
