package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei0625001;
import com.xforceplus.new20.service.IZilei0625001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei0625001前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei0625001Controller {

  @Autowired
  private IZilei0625001Service zilei0625001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei0625001 zilei0625001
   * @return
   */
  @GetMapping("/zilei0625001s" )
  public XfR getZilei0625001s(XfPage page, Zilei0625001 zilei0625001) {
    return XfR.ok(zilei0625001ServiceImpl.page(page, Wrappers.query(zilei0625001)));
  }

  /**
   * 通过id查询zilei0625001
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei0625001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei0625001ServiceImpl.getById(id));
  }

  /**
   * 新增zilei0625001
   * @param zilei0625001 zilei0625001
   * @return XfR
   */
  @PostMapping("/zilei0625001s")
  public XfR save(@RequestBody Zilei0625001 zilei0625001) {
     return XfR.ok(zilei0625001ServiceImpl.save(zilei0625001));
  }

  /**
   * 修改-传入修改后的全部数据zilei0625001
   * @param zilei0625001 zilei0625001
   * @return XfR
   */
  @PutMapping("/zilei0625001s/{id}")
  public XfR putUpdate(@RequestBody Zilei0625001 zilei0625001,@PathVariable Long id) {
      zilei0625001.setId(id);
      return XfR.ok(zilei0625001ServiceImpl.updateById(zilei0625001));
  }

  /**
   * 修改-传入修改的数据zilei0625001
   * @param zilei0625001 zilei0625001
   * @return XfR
   */
  @PatchMapping("/zilei0625001s/{id}")
  public XfR patchUpdate(@RequestBody Zilei0625001 zilei0625001,@PathVariable Long id) {
      Zilei0625001 upzilei0625001 = zilei0625001ServiceImpl.getById(id);
      if(upzilei0625001 != null){
        upzilei0625001 = ObjectCopyUtils.copyProperties(zilei0625001,upzilei0625001,true);
      }
      return XfR.ok(zilei0625001ServiceImpl.updateById(upzilei0625001));
  }

  /**
   * 通过id删除zilei0625001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei0625001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei0625001ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei0625001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei0625001");
     params.put("request", condition);

     return XfR.ok(zilei0625001ServiceImpl.querys(params));
  }

}
