package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei0801001;
import com.xforceplus.new20.service.IZilei0801001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei0801001Controller {

  @Autowired
  private IZilei0801001Service zilei0801001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei0801001 ${table.comment}
   * @return
   */
  @GetMapping("/zilei0801001s" )
  public XfR getZilei0801001s(XfPage page, Zilei0801001 zilei0801001) {
    return XfR.ok(zilei0801001ServiceImpl.page(page, Wrappers.query(zilei0801001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei0801001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei0801001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param zilei0801001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/zilei0801001s")
  public XfR save(@RequestBody Zilei0801001 zilei0801001) {
     return XfR.ok(zilei0801001ServiceImpl.save(zilei0801001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param zilei0801001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/zilei0801001s/{id}")
  public XfR putUpdate(@RequestBody Zilei0801001 zilei0801001,@PathVariable Long id) {
      zilei0801001.setId(id);
      return XfR.ok(zilei0801001ServiceImpl.updateById(zilei0801001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param zilei0801001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/zilei0801001s/{id}")
  public XfR patchUpdate(@RequestBody Zilei0801001 zilei0801001,@PathVariable Long id) {
      Zilei0801001 upzilei0801001 = zilei0801001ServiceImpl.getById(id);
      if(upzilei0801001 != null){
        upzilei0801001 = ObjectCopyUtils.copyProperties(zilei0801001,upzilei0801001,true);
      }
      return XfR.ok(zilei0801001ServiceImpl.updateById(upzilei0801001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei0801001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei0801001ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei0801001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei0801001");
     params.put("request", condition);

     return XfR.ok(zilei0801001ServiceImpl.querys(params));
  }

}
