package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei1;
import com.xforceplus.new20.service.IZilei1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei1前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei1Controller {

  @Autowired
  private IZilei1Service zilei1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei1 zilei1
   * @return
   */
  @GetMapping("/zilei1s" )
  public XfR getZilei1s(XfPage page, Zilei1 zilei1) {
    return XfR.ok(zilei1ServiceImpl.page(page, Wrappers.query(zilei1)));
  }

  /**
   * 通过id查询zilei1
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei1ServiceImpl.getById(id));
  }

  /**
   * 新增zilei1
   * @param zilei1 zilei1
   * @return XfR
   */
  @PostMapping("/zilei1s")
  public XfR save(@RequestBody Zilei1 zilei1) {
     return XfR.ok(zilei1ServiceImpl.save(zilei1));
  }

  /**
   * 修改-传入修改后的全部数据zilei1
   * @param zilei1 zilei1
   * @return XfR
   */
  @PutMapping("/zilei1s/{id}")
  public XfR putUpdate(@RequestBody Zilei1 zilei1,@PathVariable Long id) {
      zilei1.setId(id);
      return XfR.ok(zilei1ServiceImpl.updateById(zilei1));
  }

  /**
   * 修改-传入修改的数据zilei1
   * @param zilei1 zilei1
   * @return XfR
   */
  @PatchMapping("/zilei1s/{id}")
  public XfR patchUpdate(@RequestBody Zilei1 zilei1,@PathVariable Long id) {
      Zilei1 upzilei1 = zilei1ServiceImpl.getById(id);
      if(upzilei1 != null){
        upzilei1 = ObjectCopyUtils.copyProperties(zilei1,upzilei1,true);
      }
      return XfR.ok(zilei1ServiceImpl.updateById(upzilei1));
  }

  /**
   * 通过id删除zilei1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei1ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei1");
     params.put("request", condition);

     return XfR.ok(zilei1ServiceImpl.querys(params));
  }

}
