package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei2;
import com.xforceplus.new20.service.IZilei2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei2前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei2Controller {

  @Autowired
  private IZilei2Service zilei2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei2 zilei2
   * @return
   */
  @GetMapping("/zilei2s" )
  public XfR getZilei2s(XfPage page, Zilei2 zilei2) {
    return XfR.ok(zilei2ServiceImpl.page(page, Wrappers.query(zilei2)));
  }

  /**
   * 通过id查询zilei2
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei2ServiceImpl.getById(id));
  }

  /**
   * 新增zilei2
   * @param zilei2 zilei2
   * @return XfR
   */
  @PostMapping("/zilei2s")
  public XfR save(@RequestBody Zilei2 zilei2) {
     return XfR.ok(zilei2ServiceImpl.save(zilei2));
  }

  /**
   * 修改-传入修改后的全部数据zilei2
   * @param zilei2 zilei2
   * @return XfR
   */
  @PutMapping("/zilei2s/{id}")
  public XfR putUpdate(@RequestBody Zilei2 zilei2,@PathVariable Long id) {
      zilei2.setId(id);
      return XfR.ok(zilei2ServiceImpl.updateById(zilei2));
  }

  /**
   * 修改-传入修改的数据zilei2
   * @param zilei2 zilei2
   * @return XfR
   */
  @PatchMapping("/zilei2s/{id}")
  public XfR patchUpdate(@RequestBody Zilei2 zilei2,@PathVariable Long id) {
      Zilei2 upzilei2 = zilei2ServiceImpl.getById(id);
      if(upzilei2 != null){
        upzilei2 = ObjectCopyUtils.copyProperties(zilei2,upzilei2,true);
      }
      return XfR.ok(zilei2ServiceImpl.updateById(upzilei2));
  }

  /**
   * 通过id删除zilei2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei2ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei2");
     params.put("request", condition);

     return XfR.ok(zilei2ServiceImpl.querys(params));
  }

}
